/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.flow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;

public enum FlowRunColumnPrefix implements ColumnPrefix<FlowRunTable>
{
    METRIC(FlowRunColumnFamily.INFO, "m", null, new LongConverter());

    private final ColumnFamily<FlowRunTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final ValueConverter valueConverter;
    private final AggregationOperation aggOp;

    private FlowRunColumnPrefix(ColumnFamily<FlowRunTable> columnFamily, String columnPrefix, AggregationOperation fra, ValueConverter converter) {
        this(columnFamily, columnPrefix, fra, converter, false);
    }

    private FlowRunColumnPrefix(ColumnFamily<FlowRunTable> columnFamily, String columnPrefix, AggregationOperation fra, ValueConverter converter, boolean compoundColQual) {
        this.valueConverter = converter;
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.aggOp = fra;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    public byte[] getColumnPrefixBytes() {
        return (byte[])this.columnPrefixBytes.clone();
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public byte[] getColumnPrefixInBytes() {
        return this.columnPrefixBytes != null ? (byte[])this.columnPrefixBytes.clone() : null;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return HBaseTimelineSchemaUtils.combineAttributes(attributes, this.aggOp);
    }

    @Override
    public boolean supplementCellTimeStamp() {
        return true;
    }

    public AggregationOperation getAttribute() {
        return this.aggOp;
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }
}

