/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class HermitianRank2Update
extends MatrixOperation {
    public static final HermitianRank2Update SETUP = new HermitianRank2Update();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] data, int firstColumn, int columnLimit, BigDecimal[] vector1, BigDecimal[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            BigDecimal tmpVal1j = vector1[j];
            BigDecimal tmpVal2j = vector2[j];
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                data[tmpIndex] = data[tmpIndex].subtract(vector2[i].multiply(tmpVal1j).add(vector1[i].multiply(tmpVal2j)));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int firstColumn, int columnLimit, ComplexNumber[] vector1, ComplexNumber[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            ComplexNumber tmpVal1j = vector1[j].conjugate();
            ComplexNumber tmpVal2j = vector2[j].conjugate();
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                data[tmpIndex] = data[tmpIndex].subtract(vector2[i].multiply(tmpVal1j).add(vector1[i].multiply(tmpVal2j)));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] data, int firstColumn, int columnLimit, double[] vector1, double[] vector2) {
        int structure = vector1.length;
        for (int j = firstColumn; j < columnLimit; ++j) {
            double tmpVal1j = vector1[j];
            double tmpVal2j = vector2[j];
            int tmpIndex = j + j * structure;
            for (int i = j; i < structure; ++i) {
                int n = tmpIndex++;
                data[n] = data[n] - (vector2[i] * tmpVal1j + vector1[i] * tmpVal2j);
            }
        }
    }

    private HermitianRank2Update() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

