/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.shaded.org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(about="Metrics for FederationStateStoreService", context="fedr")
public final class FederationStateStoreServiceMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreServiceMetrics.class);
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"FederationStateStoreServiceMetrics", (String)"Metrics for the RM FederationStateStoreService");
    private static volatile FederationStateStoreServiceMetrics instance = null;
    private MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    private static final Method[] STATESTORE_API_METHODS = FederationStateStore.class.getMethods();
    private static final Map<String, MutableCounterLong> FAILED_CALLS = new HashMap<String, MutableCounterLong>();
    private static final Map<String, MutableRate> SUCCESSFUL_CALLS = new HashMap<String, MutableRate>();
    private static final Map<String, MutableQuantiles> QUANTILE_METRICS = new HashMap<String, MutableQuantiles>();
    private static final String UNKOWN_FAIL_ERROR_MSG = "Not recording failed call for unknown FederationStateStore method {}";
    private static final String UNKNOWN_SUCCESS_ERROR_MSG = "Not recording successful call for unknown FederationStateStore method {}";
    @Metric(value={"Total number of successful calls and latency(ms)"})
    private static MutableRate totalSucceededCalls;
    @Metric(value={"Total number of failed StateStore calls"})
    private static MutableCounterLong totalFailedCalls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FederationStateStoreServiceMetrics getMetrics() {
        Class<FederationStateStoreServiceMetrics> clazz = FederationStateStoreServiceMetrics.class;
        synchronized (FederationStateStoreServiceMetrics.class) {
            if (instance == null) {
                instance = (FederationStateStoreServiceMetrics)DefaultMetricsSystem.instance().register((Object)new FederationStateStoreServiceMetrics());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FederationStateStoreServiceMetrics() {
        this.registry.tag(RECORD_INFO, "FederationStateStoreServiceMetrics");
        for (Method m : STATESTORE_API_METHODS) {
            String methodName = m.getName();
            LOG.debug("Registering Federation StateStore Service metrics for {}", (Object)methodName);
            FAILED_CALLS.put(methodName, this.registry.newCounter(methodName + "NumFailedCalls", "# failed calls to " + methodName, 0L));
            SUCCESSFUL_CALLS.put(methodName, this.registry.newRate(methodName + "SuccessfulCalls", "# successful calls and latency(ms) for" + methodName));
            QUANTILE_METRICS.put(methodName, this.registry.newQuantiles(methodName + "Latency", "Quantile latency (ms) for " + methodName, "ops", "latency", 10));
        }
    }

    public static void failedStateStoreServiceCall() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        MutableCounterLong methodMetric = FAILED_CALLS.get(methodName);
        if (methodMetric == null) {
            LOG.error(UNKOWN_FAIL_ERROR_MSG, (Object)methodName);
            return;
        }
        totalFailedCalls.incr();
        methodMetric.incr();
    }

    public static void failedStateStoreServiceCall(String methodName) {
        MutableCounterLong methodMetric = FAILED_CALLS.get(methodName);
        if (methodMetric == null) {
            LOG.error(UNKOWN_FAIL_ERROR_MSG, (Object)methodName);
            return;
        }
        totalFailedCalls.incr();
        methodMetric.incr();
    }

    public static void succeededStateStoreServiceCall(long duration) {
        Object[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (ArrayUtils.isNotEmpty((Object[])stackTraceElements) && stackTraceElements.length > 2) {
            String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            if (SUCCESSFUL_CALLS.containsKey(methodName)) {
                FederationStateStoreServiceMetrics.succeededStateStoreServiceCall(methodName, duration);
            } else {
                LOG.error(UNKNOWN_SUCCESS_ERROR_MSG, (Object)methodName);
            }
        } else {
            LOG.error("stackTraceElements is empty or length < 2.");
        }
    }

    public static void succeededStateStoreServiceCall(String methodName, long duration) {
        if (SUCCESSFUL_CALLS.containsKey(methodName)) {
            MutableRate methodMetric = SUCCESSFUL_CALLS.get(methodName);
            MutableQuantiles methodQuantileMetric = QUANTILE_METRICS.get(methodName);
            if (methodMetric == null || methodQuantileMetric == null) {
                LOG.error(UNKNOWN_SUCCESS_ERROR_MSG, (Object)methodName);
                return;
            }
            totalSucceededCalls.add(duration);
            methodMetric.add(duration);
            methodQuantileMetric.add(duration);
        }
    }

    @VisibleForTesting
    public static long getNumFailedCallsForMethod(String methodName) {
        return FAILED_CALLS.get(methodName).value();
    }

    @VisibleForTesting
    public static long getNumSucceessfulCallsForMethod(String methodName) {
        return SUCCESSFUL_CALLS.get(methodName).lastStat().numSamples();
    }

    @VisibleForTesting
    public static double getLatencySucceessfulCallsForMethod(String methodName) {
        return SUCCESSFUL_CALLS.get(methodName).lastStat().mean();
    }

    @VisibleForTesting
    public static long getNumFailedCalls() {
        return totalFailedCalls.value();
    }

    @VisibleForTesting
    public static long getNumSucceededCalls() {
        return totalSucceededCalls.lastStat().numSamples();
    }

    @VisibleForTesting
    public static double getLatencySucceededCalls() {
        return totalSucceededCalls.lastStat().mean();
    }
}

