/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport;

import java.io.EOFException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Context;
import org.apache.hadoop.shaded.org.glassfish.grizzly.EmptyCompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.FileTransfer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEvent;
import org.apache.hadoop.shaded.org.glassfish.grizzly.IOEventProcessingHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.PortRange;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Processor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorExecutor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Reader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.SocketBinder;
import org.apache.hadoop.shaded.org.glassfish.grizzly.SocketConnectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.StandaloneProcessor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.StandaloneProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Transport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.WriteResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Writer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.Filter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.BufferArray;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.ByteBufferArray;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.RegisterChannelResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.SelectorRunner;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOAsyncQueueWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTemporarySelectorWriter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.TCPNIOTransportFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.apache.hadoop.shaded.org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.WorkerThread;
import org.apache.hadoop.shaded.org.glassfish.grizzly.utils.Exceptions;

public final class TCPNIOTransport
extends NIOTransport
implements SocketBinder,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOTransport.class);
    private static final int DEFAULT_READ_BUFFER_SIZE = -1;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = -1;
    private static final String DEFAULT_TRANSPORT_NAME = "TCPNIOTransport";
    final Collection<TCPNIOServerConnection> serverConnections;
    final AsyncQueueIO<SocketAddress> asyncQueueIO;
    final TemporarySelectorIO temporarySelectorIO;
    int serverSocketSoTimeout = 0;
    boolean tcpNoDelay = true;
    boolean reuseAddress = true;
    int linger = -1;
    boolean isKeepAlive = false;
    int clientSocketSoTimeout = -1;
    int serverConnectionBackLog = 4096;
    int connectionTimeout = 30000;
    private final int maxReadAttempts = 3;
    private boolean isOptimizedForMultiplexing;
    private final Filter defaultTransportFilter;
    final RegisterChannelCompletionHandler selectorRegistrationHandler;
    private final TCPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private static final ThreadCache.CachedTypeIndex<DirectByteBufferRecord> CACHE_IDX = ThreadCache.obtainIndex("direct-buffer-cache", DirectByteBufferRecord.class, 4);

    public TCPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    TCPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.selectorRegistrationHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = AsyncQueueIO.Factory.createImmutable(new TCPNIOAsyncQueueReader(this), new TCPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new TCPNIOTemporarySelectorReader(this), new TCPNIOTemporarySelectorWriter(this));
        this.attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
        this.defaultTransportFilter = new TCPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<TCPNIOServerConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState());
            if (currentState != Transport.State.STOP) {
                LOGGER.log(Level.WARNING, "Transport is not in STOP or BOUND state!");
            }
            this.state.setState(Transport.State.STARTING);
            super.start();
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = new StandaloneProcessor();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = Runtime.getRuntime().availableProcessors();
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.kernelPool == null) {
                this.kernelPoolConfig.setMemoryManager(this.memoryManager);
                this.setKernelPool0(GrizzlyExecutorService.createInstance(this.kernelPoolConfig));
            }
            if (this.workerThreadPool == null && this.workerPoolConfig != null) {
                this.workerPoolConfig.getInitialMonitoringConfig().addProbes((ThreadPoolProbe[])this.getThreadPoolMonitoringConfig().getProbes());
                this.workerPoolConfig.setMemoryManager(this.memoryManager);
                this.setWorkerThreadPool0(GrizzlyExecutorService.createInstance(this.workerPoolConfig));
            }
            int selectorPoolSize = 32;
            if (this.workerThreadPool instanceof AbstractThreadPool) {
                selectorPoolSize = this.strategy instanceof SameThreadIOStrategy ? this.selectorRunnersCount : Math.min(((AbstractThreadPool)this.workerThreadPool).getConfig().getMaxPoolSize(), selectorPoolSize);
            }
            if (this.strategy == null) {
                this.strategy = WorkerThreadIOStrategy.getInstance();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(this.selectorProvider, selectorPoolSize));
            this.startSelectorRunners();
            this.listenServerConnections();
            this.state.setState(Transport.State.START);
            TCPNIOTransport.notifyProbesStart(this);
        }
        finally {
            lock.unlock();
        }
    }

    private void listenServerConnections() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                this.listenServerConnection(serverConnection);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    private void listenServerConnection(TCPNIOServerConnection serverConnection) throws IOException {
        serverConnection.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() == Transport.State.PAUSE) {
                this.resume();
            }
            this.unbindAll();
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.workerThreadPool != null && this.managedWorkerPool) {
                this.workerThreadPool.shutdown();
                this.workerThreadPool = null;
            }
            if (this.kernelPool != null) {
                this.kernelPool.shutdownNow();
                this.kernelPool = null;
            }
            TCPNIOTransport.notifyProbesStop(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.START) {
                LOGGER.log(Level.WARNING, "Transport is not in START state!");
            }
            this.state.setState(Transport.State.PAUSE);
            TCPNIOTransport.notifyProbesPause(this);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (this.state.getState() != Transport.State.PAUSE) {
                LOGGER.log(Level.WARNING, "Transport is not in PAUSE state!");
            }
            this.state.setState(Transport.State.START);
            TCPNIOTransport.notifyProbesResume(this);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public TCPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, this.serverConnectionBackLog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        NIOConnection serverConnection = null;
        ServerSocketChannel serverSocketChannel = this.selectorProvider.openServerSocketChannel();
        try {
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReuseAddress(this.reuseAddress);
            serverSocket.setSoTimeout(this.serverSocketSoTimeout);
            serverSocket.bind(socketAddress, backlog);
            serverSocketChannel.configureBlocking(false);
            serverConnection = this.obtainServerNIOConnection(serverSocketChannel);
            this.serverConnections.add((TCPNIOServerConnection)serverConnection);
            ((TCPNIOConnection)serverConnection).resetProperties();
            if (!this.isStopped()) {
                this.listenServerConnection((TCPNIOServerConnection)serverConnection);
            }
            NIOConnection nIOConnection = serverConnection;
            return nIOConnection;
        }
        catch (Exception e) {
            if (serverConnection != null) {
                this.serverConnections.remove(serverConnection);
                serverConnection.closeSilently();
            } else {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            throw Exceptions.makeIOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public TCPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        int offset;
        int lower = portRange.getLower();
        int range = portRange.getUpper() - lower + 1;
        int start = offset = RANDOM.nextInt(range);
        while (true) {
            int port = lower + offset;
            try {
                return this.bind(host, port, backlog);
            }
            catch (IOException e) {
                IOException ioException = e;
                if ((offset = (offset + 1) % range) != start) continue;
                throw ioException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (connection != null && this.serverConnections.remove(connection)) {
                GrizzlyFuture<Connection> future = connection.close();
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                    future.recycle(false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error unbinding connection: " + connection, e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (TCPNIOServerConnection serverConnection : this.serverConnections) {
                try {
                    this.unbind(serverConnection);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public GrizzlyFuture<Connection> connect(String host, int port) {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connectorHandler.connect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    TCPNIOConnection obtainNIOConnection(SocketChannel channel) {
        TCPNIOConnection connection = new TCPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    TCPNIOServerConnection obtainServerNIOConnection(ServerSocketChannel channel) {
        TCPNIOServerConnection connection = new TCPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    void configureNIOConnection(TCPNIOConnection connection) {
        connection.configureBlocking(this.isBlocking);
        connection.configureStandalone(this.isStandalone);
        connection.setProcessor(this.processor);
        connection.setProcessorSelector(this.processorSelector);
        connection.setMonitoringProbes((ConnectionProbe[])this.connectionMonitoringConfig.getProbes());
    }

    void configureChannel(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set linger to " + this.linger, e);
        }
        try {
            socket.setKeepAlive(this.isKeepAlive);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set keepAlive to " + this.isKeepAlive, e);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Can not set TcpNoDelay to " + this.tcpNoDelay, e);
        }
        socket.setReuseAddress(this.reuseAddress);
    }

    @Override
    public AsyncQueueIO<SocketAddress> getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerConnectionBackLog() {
        return this.serverConnectionBackLog;
    }

    public void setServerConnectionBackLog(int serverConnectionBackLog) {
        this.serverConnectionBackLog = serverConnectionBackLog;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getClientSocketSoTimeout() {
        return this.clientSocketSoTimeout;
    }

    public void setClientSocketSoTimeout(int socketTimeout) {
        this.clientSocketSoTimeout = socketTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public int getServerSocketSoTimeout() {
        return this.serverSocketSoTimeout;
    }

    public void setServerSocketSoTimeout(int serverSocketSoTimeout) {
        this.serverSocketSoTimeout = serverSocketSoTimeout;
        TCPNIOTransport.notifyProbesConfigChanged(this);
    }

    public boolean isOptimizedForMultiplexing() {
        return this.isOptimizedForMultiplexing;
    }

    public void setOptimizedForMultiplexing(boolean isOptimizedForMultiplexing) {
        this.isOptimizedForMultiplexing = isOptimizedForMultiplexing;
        ((TCPNIOAsyncQueueWriter)this.asyncQueueIO.getWriter()).setAllowDirectWrite(!isOptimizedForMultiplexing);
    }

    @Override
    public Filter getTransportFilter() {
        return this.defaultTransportFilter;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler) {
        if (ioEvent == IOEvent.SERVER_ACCEPT) {
            try {
                ((TCPNIOServerConnection)connection).onAccept();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, processingHandler, e);
            }
            return;
        }
        if (ioEvent == IOEvent.CLIENT_CONNECTED) {
            try {
                ((TCPNIOConnection)connection).onConnect();
            }
            catch (IOException e) {
                TCPNIOTransport.failProcessingHandler(ioEvent, connection, processingHandler, e);
            }
            return;
        }
        Processor conProcessor = connection.obtainProcessor(ioEvent);
        ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, processingHandler));
    }

    @Override
    public Reader<SocketAddress> getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader<SocketAddress> getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer<SocketAddress> getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer<SocketAddress> getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer read(Connection connection, Buffer buffer) throws IOException {
        boolean isAllocate;
        Thread currentThread = Thread.currentThread();
        boolean isSelectorThread = currentThread instanceof WorkerThread && ((WorkerThread)((Object)currentThread)).isSelectorThread();
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        boolean bl = isAllocate = buffer == null;
        if (isAllocate) {
            int read;
            try {
                int receiveBufferSize = connection.getReadBufferSize();
                if (!this.memoryManager.willAllocateDirect(receiveBufferSize)) {
                    DirectByteBufferRecord directByteBufferRecord = TCPNIOTransport.obtainDirectByteBuffer(receiveBufferSize);
                    try {
                        ByteBuffer directByteBuffer = directByteBufferRecord.strongRef;
                        read = this.readSimpleByteBuffer(tcpConnection, directByteBuffer, isSelectorThread);
                        directByteBuffer.flip();
                        buffer = this.memoryManager.allocate(read);
                        buffer.put(directByteBuffer);
                    }
                    finally {
                        TCPNIOTransport.releaseDirectByteBuffer(directByteBufferRecord);
                    }
                } else {
                    buffer = this.memoryManager.allocateAtLeast(receiveBufferSize);
                    read = this.readSimple(tcpConnection, buffer, isSelectorThread);
                }
                tcpConnection.onRead(buffer, read);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (allocated) read exception", e);
                }
                read = -1;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (allocated) read {1} bytes", new Object[]{connection, read});
            }
            if (read > 0) {
                buffer.allowBufferDispose(true);
                buffer.position(read);
            } else {
                if (buffer != null) {
                    buffer.dispose();
                    buffer = null;
                }
                if (read < 0) {
                    tcpConnection.close0(null, false);
                    throw new EOFException();
                }
            }
        } else if (buffer.hasRemaining()) {
            int read;
            int oldPos = buffer.position();
            SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
            try {
                if (buffer.isComposite()) {
                    ByteBufferArray array = buffer.toByteBufferArray();
                    ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
                    int size = array.size();
                    read = !isSelectorThread ? this.doReadInLoop(socketChannel, byteBuffers, 0, size) : (int)socketChannel.read(byteBuffers, 0, size);
                    array.restore();
                    array.recycle();
                } else {
                    read = this.readSimple(tcpConnection, buffer, isSelectorThread);
                }
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "TCPNIOConnection (" + connection + ") (existing) read exception", e);
                }
                read = -1;
            }
            if (read > 0) {
                buffer.position(oldPos + read);
            }
            tcpConnection.onRead(buffer, read);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (nonallocated) read {1} bytes", new Object[]{connection, read});
            }
            if (read < 0) {
                tcpConnection.close0(null, false);
                throw new EOFException();
            }
        }
        return buffer;
    }

    private int readSimple(TCPNIOConnection tcpConnection, Buffer buffer, boolean isSelectorThread) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read = !isSelectorThread ? this.doReadInLoop(socketChannel, buffer.toByteBuffer()) : socketChannel.read(buffer.toByteBuffer());
        return read;
    }

    private int readSimpleByteBuffer(TCPNIOConnection tcpConnection, ByteBuffer byteBuffer, boolean isSelectorThread) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int read = !isSelectorThread ? this.doReadInLoop(socketChannel, byteBuffer) : socketChannel.read(byteBuffer);
        return read;
    }

    private int doReadInLoop(SocketChannel socketChannel, ByteBuffer byteBuffer) throws IOException {
        int readNow;
        int read = 0;
        int readAttempt = 0;
        while ((readNow = socketChannel.read(byteBuffer)) > 0) {
            read += readNow;
            if (byteBuffer.hasRemaining() && ++readAttempt < 3) continue;
            return read;
        }
        if (read == 0) {
            read = readNow;
        }
        return read;
    }

    private int doReadInLoop(SocketChannel socketChannel, ByteBuffer[] byteBuffers, int offset, int length) throws IOException {
        int readNow;
        int read = 0;
        int readAttempt = 0;
        ByteBuffer lastByteBuffer = byteBuffers[length - 1];
        while ((readNow = (int)socketChannel.read(byteBuffers, offset, length)) > 0) {
            read += readNow;
            if (lastByteBuffer.hasRemaining() && ++readAttempt < 3) continue;
            return read;
        }
        if (read == 0) {
            read = readNow;
        }
        return read;
    }

    public int write(Connection connection, WritableMessage message) throws IOException {
        return this.write(connection, message, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(Connection connection, WritableMessage message, WriteResult currentResult) throws IOException {
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
            int oldPos = buffer.position();
            try {
                boolean hasWritten;
                int written;
                if (buffer.isComposite()) {
                    BufferArray array = buffer.toBufferArray();
                    written = TCPNIOTransport.writeGathered(tcpConnection, array);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (composite) write {1} bytes", new Object[]{connection, written});
                    }
                    array.restore();
                    array.recycle();
                } else {
                    written = TCPNIOTransport.writeSimple(tcpConnection, buffer);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "TCPNIOConnection ({0}) (plain) write {1} bytes", new Object[]{connection, written});
                    }
                }
                boolean bl = hasWritten = written >= 0;
                if (hasWritten) {
                    buffer.position(oldPos + written);
                }
                tcpConnection.onWrite(buffer, written);
                if (!hasWritten) return written;
                if (currentResult == null) return written;
                currentResult.setMessage(message);
                currentResult.setWrittenSize(currentResult.getWrittenSize() + (long)written);
                currentResult.setDstAddress(connection.getPeerAddress());
                return written;
            }
            catch (IOException e) {
                tcpConnection.close0(null, false);
                throw e;
            }
        } else {
            if (!(message instanceof FileTransfer)) throw new IllegalStateException("Unhandled message type");
            return (int)((FileTransfer)message).writeTo((SocketChannel)((TCPNIOConnection)connection).getChannel());
        }
    }

    private static int writeSimple(TCPNIOConnection tcpConnection, Buffer buffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        if (!buffer.hasRemaining()) {
            return 0;
        }
        return TCPNIOTransport.flushByteBuffer(socketChannel, buffer.toByteBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int writeGathered(TCPNIOConnection tcpConnection, BufferArray bufferArray) throws IOException {
        Buffer[] buffers = (Buffer[])bufferArray.getArray();
        int length = bufferArray.size();
        SocketChannel socketChannel = (SocketChannel)tcpConnection.getChannel();
        int written = 0;
        DirectByteBufferRecord record = null;
        ByteBuffer directByteBuffer = null;
        try {
            int i = TCPNIOTransport.findNextAvailBuffer(buffers, -1, length);
            while (i < length) {
                int next;
                block13: {
                    Buffer buffer;
                    block12: {
                        int remaining;
                        int currentBufferRemaining;
                        boolean isAdaptByteBuffer;
                        boolean isFlush;
                        buffer = buffers[i];
                        next = TCPNIOTransport.findNextAvailBuffer(buffers, i, length);
                        boolean bl = isFlush = next == length || buffers[next].isDirect();
                        if (buffer.isDirect()) break block12;
                        if (record == null) {
                            record = TCPNIOTransport.obtainDirectByteBuffer(tcpConnection.getWriteBufferSize());
                            directByteBuffer = record.strongRef;
                        }
                        boolean bl2 = isAdaptByteBuffer = (currentBufferRemaining = buffer.remaining()) < directByteBuffer.remaining();
                        if (isAdaptByteBuffer) {
                            directByteBuffer.limit(directByteBuffer.position() + currentBufferRemaining);
                        }
                        buffer.get(directByteBuffer);
                        if (isAdaptByteBuffer) {
                            directByteBuffer.limit(directByteBuffer.capacity());
                        }
                        if (directByteBuffer.hasRemaining() && !isFlush) break block13;
                        directByteBuffer.flip();
                        written += TCPNIOTransport.flushByteBuffer(socketChannel, directByteBuffer);
                        if (remaining > 0) {
                            int shift;
                            for (remaining = directByteBuffer.remaining(); remaining > 0; remaining -= shift) {
                                Buffer revertBuffer = buffers[i];
                                shift = Math.min(remaining, revertBuffer.position() - bufferArray.getInitialPosition(i));
                                revertBuffer.position(revertBuffer.position() - shift);
                                --i;
                            }
                            break;
                        }
                        directByteBuffer.clear();
                        if (!buffer.hasRemaining()) break block13;
                        next = i;
                        break block13;
                    }
                    ByteBuffer byteBuffer = buffer.toByteBuffer();
                    written += socketChannel.write(byteBuffer);
                    if (byteBuffer.hasRemaining()) {
                        break;
                    }
                }
                i = next;
            }
        }
        finally {
            if (record != null) {
                directByteBuffer.clear();
                TCPNIOTransport.releaseDirectByteBuffer(record);
            }
        }
        return written;
    }

    private static int findNextAvailBuffer(Buffer[] buffers, int start, int end) {
        for (int i = start + 1; i < end; ++i) {
            if (!buffers[i].hasRemaining()) continue;
            return i;
        }
        return end;
    }

    static int flushByteBuffer(SocketChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.write(byteBuffer);
    }

    static DirectByteBufferRecord obtainDirectByteBuffer(int size) {
        DirectByteBufferRecord record = ThreadCache.takeFromCache(CACHE_IDX);
        if (record != null) {
            ByteBuffer byteBuffer = record.switchToStrong();
            if (byteBuffer != null && byteBuffer.remaining() >= size) {
                return record;
            }
        } else {
            record = new DirectByteBufferRecord();
        }
        record.reset(ByteBuffer.allocateDirect(size));
        return record;
    }

    static void releaseDirectByteBuffer(DirectByteBufferRecord directByteBufferRecord) {
        directByteBufferRecord.strongRef.clear();
        directByteBufferRecord.switchToSoft();
        ThreadCache.putToCache(CACHE_IDX, directByteBufferRecord);
    }

    private static void failProcessingHandler(IOEvent ioEvent, Connection connection, IOEventProcessingHandler processingHandler, IOException e) {
        if (processingHandler != null) {
            try {
                processingHandler.onError(Context.create(connection, null, ioEvent, processingHandler), e);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.apache.hadoop.shaded.org.glassfish.grizzly.nio.transport.jmx.TCPNIOTransport(this);
    }

    class TransportConnectorHandler
    extends TCPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(TCPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return TCPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return TCPNIOTransport.this.getProcessorSelector();
        }
    }

    class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            SelectionKey selectionKey = result.getSelectionKey();
            TCPNIOConnection connection = (TCPNIOConnection)TCPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }

    static final class DirectByteBufferRecord {
        ByteBuffer strongRef;
        private SoftReference<ByteBuffer> softRef;

        DirectByteBufferRecord() {
        }

        void reset(ByteBuffer byteBuffer) {
            this.strongRef = byteBuffer;
            this.softRef = null;
        }

        ByteBuffer switchToStrong() {
            if (this.strongRef == null && this.softRef != null) {
                this.strongRef = this.softRef.get();
            }
            return this.strongRef;
        }

        void switchToSoft() {
            if (this.strongRef != null && this.softRef == null) {
                this.softRef = new SoftReference<ByteBuffer>(this.strongRef);
            }
            this.strongRef = null;
        }
    }
}

