/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.hbck1;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hbase.hbck1.HBaseFsck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfflineMetaRepair {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineMetaRepair.class.getName());

    private OfflineMetaRepair() {
    }

    protected static void printUsageAndExit() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: OfflineMetaRepair [opts]\n").append("Where [opts] are:\n").append(" -details               report of all regions before hbase:meta rebuild.\n").append(" -base <hdfs://>        Base HBase Data directory to read from.\n").append(" -sidelineDir <hdfs://> path of where to backup existing hbase:meta.\n").append("Master should be down (Script runs regardless!)");
        System.err.println(sb.toString());
        Runtime.getRuntime().exit(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CommonFSUtils.setFsDefault((Configuration)conf, (Path)CommonFSUtils.getRootDir((Configuration)conf));
        HBaseFsck fsck = new HBaseFsck(conf);
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            if (cmd.equals("-details")) {
                HBaseFsck.setDisplayFullReport();
                continue;
            }
            if (cmd.equals("-base")) {
                if (i == args.length - 1) {
                    System.err.println("OfflineMetaRepair: -base needs an HDFS path.");
                    OfflineMetaRepair.printUsageAndExit();
                }
                CommonFSUtils.setRootDir((Configuration)conf, (Path)new Path(args[++i]));
                CommonFSUtils.setFsDefault((Configuration)conf, (Path)CommonFSUtils.getRootDir((Configuration)conf));
                continue;
            }
            if (cmd.equals("-sidelineDir")) {
                if (i == args.length - 1) {
                    System.err.println("OfflineMetaRepair: -sidelineDir needs an HDFS path.");
                    OfflineMetaRepair.printUsageAndExit();
                }
                fsck.setSidelineDir(args[++i]);
                continue;
            }
            String str = "Unknown command line option : " + cmd;
            LOG.info(str);
            System.out.println(str);
            OfflineMetaRepair.printUsageAndExit();
        }
        System.out.println("OfflineMetaRepair command line options: " + String.join((CharSequence)" ", args));
        boolean success = false;
        try {
            success = fsck.rebuildMeta();
            System.exit(success ? 0 : 1);
        }
        catch (MultipleIOException mioes) {
            for (IOException ioe : mioes.getExceptions()) {
                LOG.error("Bailed out due to:", ioe);
            }
            System.exit(success ? 0 : 1);
        }
        catch (Exception e) {
            LOG.error("Bailed out due to: ", e);
            System.exit(success ? 0 : 1);
            {
                catch (Throwable throwable) {
                    System.exit(success ? 0 : 1);
                    throw throwable;
                }
            }
        }
    }
}

