/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.cursor.AllEntriesCursor;
import org.apache.directory.server.xdbm.search.evaluator.ApproximateEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproximateCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = "ApproximateCursors only support positioning by element when a user index exists on the asserted attribute.";
    private final ApproximateEvaluator<V> approximateEvaluator;
    private final Cursor<IndexEntry<V, String>> userIdxCursor;
    private final Cursor<IndexEntry<String, String>> uuidIdxCursor;

    public ApproximateCursor(Store store, ApproximateEvaluator<V> approximateEvaluator) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ApproximateCursor {}", (Object)this);
        }
        this.approximateEvaluator = approximateEvaluator;
        AttributeType attributeType = approximateEvaluator.getExpression().getAttributeType();
        Value value = approximateEvaluator.getExpression().getValue();
        if (store.hasIndexOn(attributeType)) {
            Index<?, Entry, String> index = store.getIndex(attributeType);
            this.userIdxCursor = index.forwardCursor(value.getValue());
            this.uuidIdxCursor = null;
        } else {
            this.uuidIdxCursor = new AllEntriesCursor(store);
            this.userIdxCursor = null;
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public boolean available() {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.available();
        }
        return super.available();
    }

    @Override
    public void before(IndexEntry<V, String> element) throws LdapException, CursorException {
        this.checkNotClosed("before()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.before(element);
        } else {
            super.before(element);
        }
    }

    @Override
    public void after(IndexEntry<V, String> element) throws LdapException, CursorException {
        this.checkNotClosed("after()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.after(element);
        } else {
            super.after(element);
        }
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.beforeFirst();
        } else {
            this.uuidIdxCursor.beforeFirst();
            this.setAvailable(false);
        }
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        if (this.userIdxCursor != null) {
            this.userIdxCursor.afterLast();
        } else {
            this.uuidIdxCursor.afterLast();
            this.setAvailable(false);
        }
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws LdapException, CursorException {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.previous();
        }
        while (this.uuidIdxCursor.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public boolean next() throws LdapException, CursorException {
        if (this.userIdxCursor != null) {
            return this.userIdxCursor.next();
        }
        while (this.uuidIdxCursor.next()) {
            this.checkNotClosed("next()");
            IndexEntry candidate = (IndexEntry)this.uuidIdxCursor.get();
            if (!this.approximateEvaluator.evaluate(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    public IndexEntry<V, String> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.userIdxCursor != null) {
            return (IndexEntry)this.userIdxCursor.get();
        }
        if (this.available()) {
            return (IndexEntry)this.uuidIdxCursor.get();
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ApproximateCursor {}", (Object)this);
        }
        super.close();
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close();
        } else {
            this.uuidIdxCursor.close();
        }
    }

    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ApproximateCursor {}", (Object)this);
        }
        super.close(cause);
        if (this.userIdxCursor != null) {
            this.userIdxCursor.close(cause);
        } else {
            this.uuidIdxCursor.close(cause);
        }
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ApproximateCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append(" :\n");
        sb.append(tabs + "  >>").append(this.approximateEvaluator).append('\n');
        if (this.userIdxCursor != null) {
            sb.append(tabs + "  <user>\n");
            sb.append(this.userIdxCursor.toString(tabs + "    "));
        }
        if (this.uuidIdxCursor != null) {
            sb.append(tabs + "  <uuid>\n");
            sb.append(this.uuidIdxCursor.toString(tabs + "  "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

