/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomRebalancer
extends AbstractRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ResourceControllerDataProvider clusterData) {
        return currentIdealState;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ResourceControllerDataProvider cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        ResourceAssignment partitionMapping = cache.getCachedResourceAssignment(resource.getResourceName());
        if (partitionMapping != null) {
            return partitionMapping;
        }
        LOG.info("Computing BestPossibleMapping for " + resource.getResourceName());
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            Map<String, String> idealStateMap = idealState.getInstanceStateMap(partition.getPartitionName());
            Map<String, String> bestStateForPartition = this.computeCustomizedBestStateForPartition(cache, stateModelDef, idealStateMap, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        cache.setCachedResourceAssignment(resource.getResourceName(), partitionMapping);
        LOG.debug("Processing resource: {}", (Object)resource.getResourceName());
        LOG.debug("Final Mapping of resource : {}", (Object)partitionMapping.toString());
        return partitionMapping;
    }

    private Map<String, String> computeCustomizedBestStateForPartition(ResourceControllerDataProvider cache, StateModelDefinition stateModelDef, Map<String, String> idealStateMap, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(idealStateMap != null && idealStateMap.containsKey(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name()) || isResourceEnabled && !disabledInstancesForPartition.contains(instance)) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (idealStateMap == null) {
            return instanceStateMap;
        }
        Map<String, LiveInstance> assignableLiveInstancesMap = cache.getAssignableLiveInstances();
        for (String instance : idealStateMap.keySet()) {
            boolean enabled;
            boolean notInErrorState = currentStateMap != null && !HelixDefinedState.ERROR.toString().equals(currentStateMap.get(instance));
            boolean bl = enabled = !disabledInstancesForPartition.contains(instance) && isResourceEnabled;
            if (!assignableLiveInstancesMap.containsKey(instance) || !notInErrorState) continue;
            if (enabled) {
                instanceStateMap.put(instance, idealStateMap.get(instance));
                continue;
            }
            instanceStateMap.put(instance, stateModelDef.getInitialState());
        }
        return instanceStateMap;
    }
}

