/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iceberg.hive;

import com.google.errorprone.annotations.FormatMethod;
import org.apache.hadoop.hive.metastore.api.MetaException;

/**
 * Exception used to wrap {@link MetaException} as a {@link RuntimeException} and add context.
 */
public class RuntimeMetaException extends RuntimeException {
  public RuntimeMetaException(MetaException cause) {
    super(cause);
  }

  @FormatMethod
  public RuntimeMetaException(MetaException cause, String message, Object... args) {
    super(String.format(message, args), cause);
  }

  @FormatMethod
  public RuntimeMetaException(Throwable throwable, String message, Object... args) {
    super(String.format(message, args), throwable);
  }
}
