/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.hive.CatalogUtils;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public final class Catalogs {
    public static final String ICEBERG_DEFAULT_CATALOG_NAME = "default_iceberg";
    public static final String ICEBERG_HADOOP_TABLE_NAME = "location_based_table";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String SNAPSHOT_REF = "snapshot_ref";
    private static final String NO_CATALOG_TYPE = "no catalog";
    private static final Set<String> PROPERTIES_TO_REMOVE = ImmutableSet.of("iceberg.mr.table.schema", "iceberg.mr.table.partition.spec", "location", "name", "iceberg.catalog");

    private Catalogs() {
    }

    public static Table loadTable(Configuration conf) {
        return Catalogs.loadTable(conf, conf.get("iceberg.mr.table.identifier"), conf.get("iceberg.mr.table.location"), conf.get("iceberg.catalog"));
    }

    public static Table loadTable(Configuration conf, Properties props) {
        return Catalogs.loadTable(conf, props.getProperty(NAME), props.getProperty(LOCATION), props.getProperty("iceberg.catalog"));
    }

    private static Table loadTable(Configuration conf, String tableIdentifier, String tableLocation, String catalogName) {
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            Preconditions.checkArgument(tableIdentifier != null, "Table identifier not set");
            return catalog.get().loadTable(TableIdentifier.parse(tableIdentifier));
        }
        Preconditions.checkArgument(tableLocation != null, "Table location not set");
        return new HadoopTables(conf).load(tableLocation);
    }

    public static Table createTable(Configuration conf, Properties props) {
        Schema schema = Catalogs.schema(props);
        PartitionSpec spec = Catalogs.spec(props, schema);
        String location = props.getProperty(LOCATION);
        String catalogName = props.getProperty("iceberg.catalog");
        Map<String, String> map = Catalogs.filterIcebergTableProperties(props);
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        SortOrder sortOrder = HMSTablePropertyHelper.getSortOrder(props, schema);
        if (catalog.isPresent()) {
            String name = props.getProperty(NAME);
            Preconditions.checkNotNull(name, "Table identifier not set");
            return catalog.get().buildTable(TableIdentifier.parse(name), schema).withPartitionSpec(spec).withLocation(location).withProperties(map).withSortOrder(sortOrder).create();
        }
        Preconditions.checkNotNull(location, "Table location not set");
        return new HadoopTables(conf).create(schema, spec, sortOrder, map, location);
    }

    public static boolean dropTable(Configuration conf, Properties props) {
        String location = props.getProperty(LOCATION);
        String catalogName = props.getProperty("iceberg.catalog");
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            String name = props.getProperty(NAME);
            Preconditions.checkNotNull(name, "Table identifier not set");
            return catalog.get().dropTable(TableIdentifier.parse(name));
        }
        Preconditions.checkNotNull(location, "Table location not set");
        return new HadoopTables(conf).dropTable(location);
    }

    public static boolean hiveCatalog(Configuration conf, Properties props) {
        return CatalogUtils.assertCatalogType(conf, props, "hive", null);
    }

    public static Table registerTable(Configuration conf, Properties props, String metadataLocation) {
        Schema schema = Catalogs.schema(props);
        PartitionSpec spec = Catalogs.spec(props, schema);
        Map<String, String> map = Catalogs.filterIcebergTableProperties(props);
        String location = props.getProperty(LOCATION);
        String catalogName = props.getProperty("iceberg.catalog");
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (catalog.isPresent()) {
            String name = props.getProperty(NAME);
            Preconditions.checkNotNull(name, "Table identifier not set");
            return catalog.get().registerTable(TableIdentifier.parse(name), metadataLocation);
        }
        Preconditions.checkNotNull(location, "Table location not set");
        SortOrder sortOrder = HMSTablePropertyHelper.getSortOrder(props, schema);
        return new HadoopTables(conf).create(schema, spec, sortOrder, map, location);
    }

    public static void renameTable(Configuration conf, Properties props, TableIdentifier to) {
        String catalogName = props.getProperty("iceberg.catalog");
        Optional<Catalog> catalog = Catalogs.loadCatalog(conf, catalogName);
        if (!catalog.isPresent()) {
            throw new RuntimeException("Rename from " + props.getProperty(NAME) + " to " + String.valueOf(to) + " failed");
        }
        String name = props.getProperty(NAME);
        Preconditions.checkNotNull(name, "Table identifier not set");
        catalog.get().renameTable(TableIdentifier.parse(name), to);
    }

    static Optional<Catalog> loadCatalog(Configuration conf, String catalogName) {
        String catalogType = CatalogUtils.getCatalogType(conf, catalogName);
        if (NO_CATALOG_TYPE.equalsIgnoreCase(catalogType)) {
            return Optional.empty();
        }
        String name = catalogName == null ? ICEBERG_DEFAULT_CATALOG_NAME : catalogName;
        return Optional.of(CatalogUtil.buildIcebergCatalog(name, CatalogUtils.getCatalogProperties(conf, name), conf));
    }

    private static Schema schema(Properties props) {
        String schemaString = props.getProperty("iceberg.mr.table.schema");
        Preconditions.checkNotNull(schemaString, "Table schema not set");
        return SchemaParser.fromJson(schemaString);
    }

    private static PartitionSpec spec(Properties props, Schema schema) {
        String specString = props.getProperty("iceberg.mr.table.partition.spec");
        PartitionSpec spec = PartitionSpec.unpartitioned();
        if (specString != null) {
            spec = PartitionSpecParser.fromJson(schema, specString);
        }
        return spec;
    }

    private static Map<String, String> filterIcebergTableProperties(Properties props) {
        HashMap<String, String> map = Maps.newHashMapWithExpectedSize(props.size());
        for (Object key : props.keySet()) {
            if (PROPERTIES_TO_REMOVE.contains(key)) continue;
            map.put(key.toString(), props.get(key).toString());
        }
        return map;
    }
}

