/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.core.GraphUsage;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.apache.hop.neo4j.model.validation.ModelValidator;
import org.apache.hop.neo4j.model.validation.NodeProperty;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoConnectionUtils;
import org.apache.hop.neo4j.transforms.BaseNeoTransform;
import org.apache.hop.neo4j.transforms.graph.CypherParameters;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutputData;
import org.apache.hop.neo4j.transforms.graph.GraphOutputMeta;
import org.apache.hop.neo4j.transforms.graph.ModelTargetHint;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;
import org.apache.hop.neo4j.transforms.graph.NodeMapping;
import org.apache.hop.neo4j.transforms.graph.NodeMappingType;
import org.apache.hop.neo4j.transforms.graph.RelationshipMapping;
import org.apache.hop.neo4j.transforms.graph.RelationshipMappingType;
import org.apache.hop.neo4j.transforms.graph.SelectedNode;
import org.apache.hop.neo4j.transforms.graph.SelectedRelationship;
import org.apache.hop.neo4j.transforms.graph.TargetParameter;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class GraphOutput
extends BaseNeoTransform<GraphOutputMeta, GraphOutputData> {
    public GraphOutput(TransformMeta transformMeta, GraphOutputMeta meta, GraphOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    @Override
    public boolean init() {
        try {
            if (!((GraphOutputMeta)this.meta).isReturningGraph()) {
                if (StringUtils.isEmpty((String)((GraphOutputMeta)this.meta).getConnectionName())) {
                    this.logError("You need to specify a Neo4j connection to use in this transform");
                    return false;
                }
                IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(NeoConnection.class);
                ((GraphOutputData)this.data).neoConnection = (NeoConnection)serializer.load(((GraphOutputMeta)this.meta).getConnectionName());
                if (((GraphOutputData)this.data).neoConnection == null) {
                    this.logError("Connection '" + ((GraphOutputMeta)this.meta).getConnectionName() + "' could not be found in the metadata : " + this.metadataProvider.getDescription());
                    return false;
                }
                try {
                    ((GraphOutputData)this.data).driver = ((GraphOutputData)this.data).neoConnection.getDriver(this.getLogChannel(), (IVariables)this);
                    ((GraphOutputData)this.data).session = ((GraphOutputData)this.data).neoConnection.getSession(this.getLogChannel(), ((GraphOutputData)this.data).driver, (IVariables)this);
                    ((GraphOutputData)this.data).version4 = ((GraphOutputData)this.data).neoConnection.isVersion4();
                }
                catch (Exception e) {
                    this.logError("Unable to get or create Neo4j database driver for database '" + ((GraphOutputData)this.data).neoConnection.getName() + "'", e);
                    return false;
                }
                ((GraphOutputData)this.data).batchSize = Const.toLong((String)this.resolve(((GraphOutputMeta)this.meta).getBatchSize()), (long)1L);
            }
            if (StringUtils.isEmpty((String)((GraphOutputMeta)this.meta).getModel())) {
                this.logError("No model name is specified");
                return false;
            }
            IHopMetadataSerializer modelSerializer = this.metadataProvider.getSerializer(GraphModel.class);
            ((GraphOutputData)this.data).graphModel = (GraphModel)modelSerializer.load(((GraphOutputMeta)this.meta).getModel());
            if (((GraphOutputData)this.data).graphModel == null) {
                this.logError("Model '" + ((GraphOutputMeta)this.meta).getModel() + "' could not be found!");
                return false;
            }
            ((GraphOutputData)this.data).graphModel.validateIntegrity();
            ((GraphOutputData)this.data).modelValidator = null;
            if (((GraphOutputMeta)this.meta).isValidatingAgainstModel()) {
                List<NodeProperty> usedNodeProperties = this.findUsedNodeProperties();
                ((GraphOutputData)this.data).modelValidator = new ModelValidator(((GraphOutputData)this.data).graphModel, usedNodeProperties);
                int nrErrors = ((GraphOutputData)this.data).modelValidator.validateBeforeLoad(this.getLogChannel(), ((GraphOutputData)this.data).session);
                if (nrErrors > 0) {
                    this.logError("Validation against graph model '" + ((GraphOutputData)this.data).graphModel.getName() + "' failed with " + nrErrors + " errors.");
                    return false;
                }
                this.logBasic("Validation against graph model '" + ((GraphOutputData)this.data).graphModel.getName() + "' was successful.");
            }
        }
        catch (HopException e) {
            this.logError("Could not find Neo4j connection'" + ((GraphOutputMeta)this.meta).getConnectionName() + "'", e);
            return false;
        }
        return super.init();
    }

    private List<NodeProperty> findUsedNodeProperties() {
        ArrayList<NodeProperty> list = new ArrayList<NodeProperty>();
        for (FieldModelMapping fieldModelMapping : ((GraphOutputMeta)this.meta).getFieldModelMappings()) {
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            list.add(new NodeProperty(fieldModelMapping.getTargetName(), fieldModelMapping.getTargetProperty()));
        }
        return list;
    }

    @Override
    public void dispose() {
        this.wrapUpTransaction();
        if (((GraphOutputData)this.data).session != null) {
            ((GraphOutputData)this.data).session.close();
        }
        if (((GraphOutputData)this.data).driver != null) {
            ((GraphOutputData)this.data).driver.close();
        }
        if (((GraphOutputData)this.data).cypherMap != null) {
            ((GraphOutputData)this.data).cypherMap.clear();
        }
        super.dispose();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.wrapUpTransaction();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            GraphRelationship relationship;
            int i;
            this.first = false;
            ((GraphOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GraphOutputMeta)this.meta).getFields(((GraphOutputData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            ((GraphOutputData)this.data).fieldIndexes = new int[((GraphOutputMeta)this.meta).getFieldModelMappings().size()];
            for (i = 0; i < ((GraphOutputMeta)this.meta).getFieldModelMappings().size(); ++i) {
                String field = ((GraphOutputMeta)this.meta).getFieldModelMappings().get(i).getField();
                ((GraphOutputData)this.data).fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field);
                if (((GraphOutputData)this.data).fieldIndexes[i] >= 0) continue;
                throw new HopException("Unable to find parameter field '" + field);
            }
            ((GraphOutputData)this.data).relMappingIndexes = new ArrayList<GraphOutputData.RelationshipMappingIndexes>();
            ((GraphOutputData)this.data).fieldValueRelationshipMap = new HashMap<String, Map<String, GraphRelationship>>();
            for (i = 0; i < ((GraphOutputMeta)this.meta).getRelationshipMappings().size(); ++i) {
                Iterator relationshipMapping = ((GraphOutputMeta)this.meta).getRelationshipMappings().get(i);
                GraphOutputData.RelationshipMappingIndexes mappingIndexes = new GraphOutputData.RelationshipMappingIndexes();
                if (((RelationshipMapping)((Object)relationshipMapping)).getType() == RelationshipMappingType.UsingValue) {
                    String field = ((RelationshipMapping)((Object)relationshipMapping)).getFieldName();
                    if (StringUtils.isEmpty((String)field)) {
                        throw new HopException("Please specify a field to use to select a relationship for mapping: " + relationshipMapping);
                    }
                    if (StringUtils.isEmpty((String)((RelationshipMapping)((Object)relationshipMapping)).getFieldValue())) {
                        throw new HopException("Please specify a field value to use to select a relationship for mapping: " + relationshipMapping);
                    }
                    if (StringUtils.isEmpty((String)((RelationshipMapping)((Object)relationshipMapping)).getTargetRelationship())) {
                        throw new HopException("Please specify a relationship to map to for relationship mapping: " + relationshipMapping);
                    }
                    mappingIndexes.fieldIndex = this.getInputRowMeta().indexOfValue(field);
                    if (mappingIndexes.fieldIndex < 0) {
                        throw new HopException("Unable to find relationship mapping field '" + field + "' to update a specific relationship");
                    }
                    relationship = ((GraphOutputData)this.data).graphModel.findRelationship(((RelationshipMapping)((Object)relationshipMapping)).getTargetRelationship());
                    if (relationship == null) {
                        throw new HopException("Unable to find relationship mapping target mapping '" + ((RelationshipMapping)((Object)relationshipMapping)).getTargetRelationship());
                    }
                    Map valueRelationshipMap = ((GraphOutputData)this.data).fieldValueRelationshipMap.computeIfAbsent(field, k -> new HashMap());
                    valueRelationshipMap.put(Const.NVL((String)((RelationshipMapping)((Object)relationshipMapping)).getFieldValue(), (String)""), relationship);
                }
                ((GraphOutputData)this.data).relMappingIndexes.add(mappingIndexes);
            }
            ((GraphOutputData)this.data).relationshipPropertyIndexMap = new HashMap();
            HashMap<String, Set> nodeTargetHintMap = new HashMap<String, Set>();
            for (FieldModelMapping mapping : ((GraphOutputMeta)this.meta).getFieldModelMappings()) {
                if (mapping.getTargetType() == ModelTargetType.Relationship) {
                    String relationshipName = mapping.getTargetName();
                    relationship = ((GraphOutputData)this.data).graphModel.findRelationship(relationshipName);
                    if (relationship == null) {
                        throw new HopException("Unable to find relationship '" + relationshipName + "' in the graph model");
                    }
                    String propertyName = mapping.getTargetProperty();
                    GraphProperty graphProperty = relationship.findProperty(propertyName);
                    if (graphProperty == null) {
                        throw new HopException("Unable to find relationship property '" + relationshipName + "." + propertyName + "' in the graph model");
                    }
                    this.checkGraphProperty(graphProperty);
                    String fieldName = mapping.getField();
                    int fieldIndex = this.getInputRowMeta().indexOfValue(fieldName);
                    if (fieldIndex < 0) {
                        throw new HopException("Unable to find field to map to relationship property: " + relationshipName + "." + propertyName);
                    }
                    Map propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.computeIfAbsent(relationshipName, k -> new HashMap());
                    propertyIndexMap.put(graphProperty, fieldIndex);
                    continue;
                }
                if (mapping.getTargetType() != ModelTargetType.Node) continue;
                Set modelTargetHints = nodeTargetHintMap.computeIfAbsent(mapping.getTargetName(), f -> new HashSet());
                modelTargetHints.add(mapping.getTargetHint());
            }
            for (String nodeName : nodeTargetHintMap.keySet()) {
                Set hints = (Set)nodeTargetHintMap.get(nodeName);
                if ((!hints.contains((Object)ModelTargetHint.SelfRelationshipSource) || !hints.contains((Object)ModelTargetHint.None)) && (!hints.contains((Object)ModelTargetHint.SelfRelationshipTarget) || !hints.contains((Object)ModelTargetHint.None))) continue;
                throw new HopException("There are mappings to node " + nodeName + " with both a specific Self relationship target and None. This is not allowed.");
            }
            ((GraphOutputData)this.data).nodeValueLabelMergeMap = new HashMap<String, Map<String, String>>();
            ((GraphOutputData)this.data).nodeValueLabelSetMap = new HashMap<String, Map<String, String>>();
            ((GraphOutputData)this.data).nodeMappingIndexes = new ArrayList<Integer>();
            for (int i2 = 0; i2 < ((GraphOutputMeta)this.meta).getNodeMappings().size(); ++i2) {
                NodeMapping nodeMapping = ((GraphOutputMeta)this.meta).getNodeMappings().get(i2);
                if (StringUtils.isEmpty((String)nodeMapping.getTargetNode())) {
                    throw new HopException("Please specify a valid target node for node mapping: " + nodeMapping);
                }
                GraphNode targetNode = ((GraphOutputData)this.data).graphModel.findNode(nodeMapping.getTargetNode());
                if (targetNode == null) {
                    throw new HopException("Target node '" + nodeMapping.getTargetNode() + "' can not be found in the graph model. Specified in node mapping: " + nodeMapping);
                }
                int index = -1;
                if (nodeMapping.getType() == NodeMappingType.UsingValue || nodeMapping.getType() == NodeMappingType.AddLabel) {
                    if (StringUtils.isEmpty((String)nodeMapping.getFieldName())) {
                        throw new HopException("Please specify an input field name to use to determine the label to use in node mapping: " + nodeMapping);
                    }
                    if (StringUtils.isEmpty((String)nodeMapping.getFieldValue())) {
                        throw new HopException("Please specify a field value to use to determine the label to use in node mapping: " + nodeMapping);
                    }
                    if (StringUtils.isEmpty((String)nodeMapping.getTargetLabel())) {
                        throw new HopException("Please specify a target label in node mapping: " + nodeMapping);
                    }
                    if (!targetNode.getLabels().contains(nodeMapping.getTargetLabel())) {
                        throw new HopException("The specified target label '" + nodeMapping.getTargetLabel() + "' doesn't exist in the graph model for node '" + targetNode.getName() + "'");
                    }
                    index = this.getInputRowMeta().indexOfValue(nodeMapping.getFieldName());
                    if (index < 0) {
                        throw new HopException("Unable to find field '" + nodeMapping.getFieldName() + "' in node mapping: " + nodeMapping);
                    }
                    Map valueLabelMap = ((GraphOutputData)this.data).nodeValueLabelMergeMap.computeIfAbsent(nodeMapping.getTargetNode(), f -> new HashMap());
                    valueLabelMap.put(nodeMapping.getFieldValue(), nodeMapping.getTargetLabel());
                }
                ((GraphOutputData)this.data).nodeMappingIndexes.add(index);
            }
            if (!((GraphOutputMeta)this.meta).isReturningGraph() && ((GraphOutputMeta)this.meta).isCreatingIndexes()) {
                this.createNodePropertyIndexes((GraphOutputMeta)this.meta, (GraphOutputData)this.data);
            }
            ((GraphOutputData)this.data).relationshipsCache = new HashMap<String, Map<String, List<GraphRelationship>>>();
            ((GraphOutputData)this.data).cypherMap = new HashMap<String, CypherParameters>();
        }
        if (((GraphOutputMeta)this.meta).isReturningGraph()) {
            GraphData graphData = this.getGraphData(row, this.getInputRowMeta());
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((GraphOutputData)this.data).outputRowMeta.size());
            outputRowData[this.getInputRowMeta().size()] = graphData;
            this.putRow(((GraphOutputData)this.data).outputRowMeta, outputRowData);
        } else {
            boolean errors;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            String cypher = this.getCypher(row, this.getInputRowMeta(), parameters);
            if (this.isDebug()) {
                this.logDebug("Parameters found : " + parameters.size());
                this.logDebug("Merge statement : " + cypher);
            }
            if (errors = this.executeStatement((GraphOutputData)this.data, cypher, parameters)) {
                this.setErrors(1L);
                this.setOutputDone();
                return false;
            }
            this.putRow(this.getInputRowMeta(), row);
        }
        return true;
    }

    private void createNodePropertyIndexes(GraphOutputMeta meta, GraphOutputData data) throws HopException {
        if (this.getCopy() > 0) {
            return;
        }
        HashMap<GraphNode, ArrayList<String>> nodePropertiesMap = new HashMap<GraphNode, ArrayList<String>>();
        for (int f = 0; f < meta.getFieldModelMappings().size(); ++f) {
            FieldModelMapping fieldModelMapping = meta.getFieldModelMappings().get(f);
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            int index = data.fieldIndexes[f];
            GraphNode node = data.graphModel.findNode(fieldModelMapping.getTargetName());
            if (node == null) {
                throw new HopException("Unable to find target node '" + fieldModelMapping.getTargetName() + "'");
            }
            GraphProperty graphProperty = node.findProperty(fieldModelMapping.getTargetProperty());
            if (graphProperty == null) {
                throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of node '" + fieldModelMapping.getTargetName() + "'");
            }
            if (!graphProperty.isPrimary()) continue;
            ArrayList<String> propertiesList = (ArrayList<String>)nodePropertiesMap.get(node);
            if (propertiesList == null) {
                propertiesList = new ArrayList<String>();
                nodePropertiesMap.put(node, propertiesList);
            }
            propertiesList.add(graphProperty.getName());
        }
        for (GraphNode node : nodePropertiesMap.keySet()) {
            NeoConnectionUtils.createNodeIndex(this.getLogChannel(), data.session, node.getLabels(), (List)nodePropertiesMap.get(node));
        }
    }

    private boolean executeStatement(GraphOutputData data, String cypher, Map<String, Object> parameters) {
        boolean errors = false;
        if (data.batchSize <= 1L) {
            Result result = data.session.run(cypher, parameters);
            errors = this.processSummary(result);
        } else if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            if (data.unwindCount == 0) {
                data.unwindMapList = new HashMap<String, List<Map<String, Object>>>();
            }
            List unwindList = data.unwindMapList.computeIfAbsent(cypher, k -> new ArrayList());
            unwindList.add(parameters);
            ++data.unwindCount;
            if ((long)data.unwindCount >= data.batchSize) {
                errors = this.emptyUnwindMap();
            }
        } else {
            if (data.outputCount == 0L) {
                data.transaction = data.session.beginTransaction();
            }
            Result result = data.transaction.run(cypher, parameters);
            errors = this.processSummary(result);
            ++data.outputCount;
            this.incrementLinesOutput();
            if (!errors && data.outputCount >= data.batchSize) {
                data.transaction.commit();
                data.transaction.close();
                data.outputCount = 0L;
            }
        }
        if (errors) {
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
        }
        return errors;
    }

    private boolean emptyUnwindMap() {
        List<Map<String, Object>> unwindList;
        Map<String, List<Map<String, Object>>> props;
        String unwindCypher;
        Result result;
        if (((GraphOutputData)this.data).unwindCount == 0 || ((GraphOutputData)this.data).unwindMapList == null || ((GraphOutputData)this.data).unwindMapList.isEmpty()) {
            return false;
        }
        boolean errors = false;
        Iterator<String> iterator = ((GraphOutputData)this.data).unwindMapList.keySet().iterator();
        while (iterator.hasNext() && !(errors = this.processSummary(result = (Result)((GraphOutputData)this.data).session.writeTransaction(arg_0 -> GraphOutput.lambda$emptyUnwindMap$5(unwindCypher = iterator.next(), props = Collections.singletonMap("props", unwindList = ((GraphOutputData)this.data).unwindMapList.get(unwindCypher)), arg_0))))) {
            this.setLinesOutput(this.getLinesOutput() + (long)unwindList.size());
        }
        ((GraphOutputData)this.data).unwindCount = 0;
        ((GraphOutputData)this.data).unwindMapList.clear();
        return errors;
    }

    private boolean processSummary(Result result) {
        boolean errors = false;
        ResultSummary summary = result.consume();
        for (Notification notification : summary.notifications()) {
            this.logError(notification.title() + " (" + notification.severity() + ")");
            this.logError(notification.code() + " : " + notification.description() + ", position " + notification.position());
            errors = true;
        }
        return errors;
    }

    protected String getCypher(Object[] row, IRowMeta rowMeta, Map<String, Object> parameters) throws HopException {
        String pattern = this.buildCypherKeyPattern(row, rowMeta);
        CypherParameters cypherParameters = ((GraphOutputData)this.data).cypherMap.get(pattern);
        if (cypherParameters != null) {
            this.setParameters(rowMeta, row, parameters, cypherParameters);
            return cypherParameters.getCypher();
        }
        cypherParameters = new CypherParameters();
        SelectedNodesAndRelationships nar = this.selectNodesAndRelationships(rowMeta, row);
        int relationshipIndex = 0;
        AtomicInteger parameterIndex = new AtomicInteger(0);
        AtomicInteger nodeIndex = new AtomicInteger(0);
        StringBuilder cypher = new StringBuilder();
        HashSet<SelectedNode> handled = new HashSet<SelectedNode>();
        HashMap<SelectedNode, Integer> nodeIndexMap = new HashMap<SelectedNode, Integer>();
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            cypher.append("UNWIND $props AS pr ");
            cypher.append(Const.CR);
        }
        if (nar.relationships.isEmpty()) {
            if (nar.nodes.isEmpty()) {
                throw new HopException("We didn't find a node to write to.  Did you specify a field mapping to node properties?");
            }
            if (nar.nodes.size() > 1) {
                this.logBasic("Warning: writing to multiple nodes but not to any relationships");
            }
            for (SelectedNode node : nar.nodes) {
                this.addNodeCypher(cypher, node, handled, nar.ignored, parameterIndex, nodeIndex, nodeIndexMap, nar.nodeProperties, parameters, cypherParameters);
            }
        } else {
            for (SelectedRelationship selectedRelationship : nar.relationships) {
                if (nar.avoided.contains(selectedRelationship)) continue;
                SelectedNode sourceNode = selectedRelationship.getSourceNode();
                SelectedNode targetNode = selectedRelationship.getTargetNode();
                GraphRelationship relationship = selectedRelationship.getRelationship();
                ++relationshipIndex;
                if (this.isDebug()) {
                    this.logDebug("Handling relationship : " + relationship.getName());
                }
                this.addNodeCypher(cypher, sourceNode, handled, nar.ignored, parameterIndex, nodeIndex, nodeIndexMap, nar.nodeProperties, parameters, cypherParameters);
                this.addNodeCypher(cypher, targetNode, handled, nar.ignored, parameterIndex, nodeIndex, nodeIndexMap, nar.nodeProperties, parameters, cypherParameters);
                if (nodeIndexMap.get(sourceNode) == null || nodeIndexMap.get(targetNode) == null) continue;
                String sourceNodeName = "node" + nodeIndexMap.get(sourceNode);
                String targetNodeName = "node" + nodeIndexMap.get(targetNode);
                String relationshipAlias = "rel" + relationshipIndex;
                cypher.append("MERGE(" + sourceNodeName + ")-[" + relationshipAlias + ":" + relationship.getLabel() + "]->(" + targetNodeName + ") ");
                cypher.append(Const.CR);
                ArrayList<GraphProperty> relProps = new ArrayList<GraphProperty>();
                ArrayList<Integer> relPropIndexes = new ArrayList<Integer>();
                Map<GraphProperty, Integer> propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.get(relationship.getName());
                if (propertyIndexMap != null) {
                    for (GraphProperty relProp : propertyIndexMap.keySet()) {
                        Integer relFieldIndex = propertyIndexMap.get(relProp);
                        if (relFieldIndex == null) continue;
                        relProps.add(relProp);
                        relPropIndexes.add(relFieldIndex);
                    }
                }
                if (!relProps.isEmpty()) {
                    cypher.append("SET ");
                    for (int i = 0; i < relProps.size(); ++i) {
                        parameterIndex.incrementAndGet();
                        String parameterName = "param" + parameterIndex;
                        if (i > 0) {
                            cypher.append(", ");
                        }
                        GraphProperty relProp = (GraphProperty)relProps.get(i);
                        int propFieldIndex = (Integer)relPropIndexes.get(i);
                        IValueMeta sourceFieldMeta = rowMeta.getValueMeta(propFieldIndex);
                        Object sourceFieldValue = row[propFieldIndex];
                        boolean isNull = sourceFieldMeta.isNull(sourceFieldValue);
                        cypher.append(relationshipAlias + "." + relProp.getName());
                        cypher.append(" = ");
                        if (isNull) {
                            cypher.append("NULL");
                            continue;
                        }
                        Object neoValue = relProp.getType().convertFromHop(sourceFieldMeta, sourceFieldValue);
                        parameters.put(parameterName, neoValue);
                        cypher.append(this.buildParameterClause(parameterName));
                        TargetParameter targetParameter = new TargetParameter(sourceFieldMeta.getName(), propFieldIndex, parameterName, relProp.getType());
                        cypherParameters.getTargetParameters().add(targetParameter);
                    }
                    cypher.append(Const.CR);
                }
                this.updateUsageMap(Arrays.asList(relationship.getLabel()), GraphUsage.RELATIONSHIP_UPDATE);
            }
            cypher.append(";" + Const.CR);
        }
        cypherParameters.setCypher(cypher.toString());
        ((GraphOutputData)this.data).cypherMap.put(pattern, cypherParameters);
        return cypher.toString();
    }

    private SelectedNodesAndRelationships selectNodesAndRelationships(IRowMeta rowMeta, Object[] row) throws HopException {
        ArrayList<NodeAndPropertyData> nodeProperties = new ArrayList<NodeAndPropertyData>();
        Set<SelectedNode> nodesSet = this.getInvolvedNodes(row, rowMeta, nodeProperties);
        HashSet<SelectedNode> ignored = new HashSet<SelectedNode>();
        for (NodeAndPropertyData nodeProperty : nodeProperties) {
            if (!nodeProperty.property.isPrimary() || !nodeProperty.sourceValueMeta.isNull(nodeProperty.sourceValueData)) continue;
            if (this.isDebug()) {
                this.logDebug("Detected primary null property for node " + nodeProperty.node + " property " + nodeProperty.property + " value : " + nodeProperty.sourceValueMeta.getString(nodeProperty.sourceValueData));
            }
            ignored.add(nodeProperty.node);
        }
        HashSet<SelectedRelationship> selectedRelationships = new HashSet<SelectedRelationship>();
        HashSet<SelectedRelationship> avoidedRelationships = new HashSet<SelectedRelationship>();
        for (SelectedNode source : nodesSet) {
            for (SelectedNode target : nodesSet) {
                String targetNodeName;
                String sourceNodeName;
                List<GraphRelationship> relationships;
                if (source.equals(target) || (relationships = this.findRelationships(sourceNodeName = source.getNode().getName(), targetNodeName = target.getNode().getName())) == null || relationships.isEmpty() || source.getHint() == ModelTargetHint.SelfRelationshipTarget || target.getHint() == ModelTargetHint.SelfRelationshipSource) continue;
                for (GraphRelationship relationship : relationships) {
                    boolean isApplicable = true;
                    boolean avoidRelationship = false;
                    boolean addRelationship = false;
                    block10: for (int i = 0; i < ((GraphOutputMeta)this.meta).getRelationshipMappings().size(); ++i) {
                        RelationshipMapping mapping = ((GraphOutputMeta)this.meta).getRelationshipMappings().get(i);
                        GraphOutputData.RelationshipMappingIndexes mappingIndexes = ((GraphOutputData)this.data).relMappingIndexes.get(i);
                        boolean nodesMatch = sourceNodeName.equals(mapping.getSourceNode()) && targetNodeName.equals(mapping.getTargetNode());
                        boolean relationshipMatch = relationship.getName().equals(mapping.getTargetRelationship());
                        switch (mapping.getType()) {
                            case NoMapping: {
                                continue block10;
                            }
                            case NoRelationship: {
                                if (!nodesMatch) continue block10;
                                avoidRelationship = true;
                                continue block10;
                            }
                            case All: {
                                if (!nodesMatch) continue block10;
                                addRelationship = true;
                                continue block10;
                            }
                            case UsingValue: {
                                if (!relationshipMatch) continue block10;
                                String value = rowMeta.getString(row, mappingIndexes.fieldIndex);
                                if (value != null && value.equals(mapping.getFieldValue())) {
                                    addRelationship = true;
                                }
                                isApplicable = false;
                            }
                        }
                    }
                    SelectedRelationship selectedRelationship = new SelectedRelationship(source, target, relationship);
                    if (addRelationship) {
                        selectedRelationships.add(selectedRelationship);
                        continue;
                    }
                    if (avoidRelationship) {
                        avoidedRelationships.add(selectedRelationship);
                        continue;
                    }
                    if (!isApplicable) continue;
                    selectedRelationships.add(new SelectedRelationship(source, target, relationship));
                }
            }
        }
        if (this.isDebug()) {
            this.logDebug("Found " + selectedRelationships.size() + " relationships to consider : " + ((Object)selectedRelationships).toString());
            this.logDebug("Found " + ignored.size() + " nodes to ignore : " + ((Object)ignored).toString());
        }
        return new SelectedNodesAndRelationships(nodesSet, selectedRelationships, avoidedRelationships, nodeProperties, ignored);
    }

    private List<GraphRelationship> findRelationships(String sourceNodeName, String targetNodeName) {
        Map targetsMap = ((GraphOutputData)this.data).relationshipsCache.computeIfAbsent(sourceNodeName, f -> new HashMap());
        return targetsMap.computeIfAbsent(targetNodeName, f -> ((GraphOutputData)this.data).graphModel.findRelationships(sourceNodeName, targetNodeName));
    }

    private String buildCypherKeyPattern(Object[] row, IRowMeta rowMeta) throws HopValueException {
        int i;
        StringBuffer pattern = new StringBuffer();
        for (int index : ((GraphOutputData)this.data).fieldIndexes) {
            boolean isNull = rowMeta.isNull(row, index);
            pattern.append(isNull ? (char)'0' : '1');
        }
        for (i = 0; i < ((GraphOutputData)this.data).relMappingIndexes.size(); ++i) {
            int index;
            RelationshipMapping relationshipMapping = ((GraphOutputMeta)this.meta).getRelationshipMappings().get(i);
            GraphOutputData.RelationshipMappingIndexes mappingIndexes = ((GraphOutputData)this.data).relMappingIndexes.get(i);
            if (relationshipMapping.getType() != RelationshipMappingType.UsingValue) continue;
            index = mappingIndexes.fieldIndex;
            String value = Const.NVL((String)rowMeta.getString(row, index), (String)"");
            pattern.append('-').append(value);
        }
        for (i = 0; i < ((GraphOutputData)this.data).nodeMappingIndexes.size(); ++i) {
            int index = ((GraphOutputData)this.data).nodeMappingIndexes.get(i);
            if (index < 0) continue;
            String value = Const.NVL((String)rowMeta.getString(row, index), (String)"");
            pattern.append('-').append(value);
        }
        return pattern.toString();
    }

    private Set<SelectedNode> getInvolvedNodes(Object[] row, IRowMeta rowMeta, List<NodeAndPropertyData> nodeProperties) throws HopException {
        List<FieldModelMapping> fieldModelMappings = ((GraphOutputMeta)this.meta).getFieldModelMappings();
        HashSet<SelectedNode> nodesSet = new HashSet<SelectedNode>();
        for (int f = 0; f < fieldModelMappings.size(); ++f) {
            FieldModelMapping fieldModelMapping = fieldModelMappings.get(f);
            ModelTargetHint targetHint = fieldModelMapping.getTargetHint();
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            int index = ((GraphOutputData)this.data).fieldIndexes[f];
            IValueMeta valueMeta = rowMeta.getValueMeta(index);
            Object valueData = row[index];
            GraphNode node = ((GraphOutputData)this.data).graphModel.findNode(fieldModelMapping.getTargetName());
            if (node == null) {
                throw new HopException("Unable to find target node '" + fieldModelMapping.getTargetName() + "'");
            }
            GraphProperty graphProperty = node.findProperty(fieldModelMapping.getTargetProperty());
            if (graphProperty == null) {
                throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of node '" + fieldModelMapping.getTargetName() + "'");
            }
            this.checkGraphProperty(graphProperty);
            HashSet<String> labels = new HashSet<String>();
            HashSet<String> labelsToSet = new HashSet<String>();
            boolean implicitNodeMapping = true;
            block6: for (int i = 0; i < ((GraphOutputMeta)this.meta).getNodeMappings().size(); ++i) {
                NodeMapping mapping = ((GraphOutputMeta)this.meta).getNodeMappings().get(i);
                if (!node.getName().equals(mapping.getTargetNode())) continue;
                implicitNodeMapping = false;
                switch (mapping.getType()) {
                    case All: {
                        labels.addAll(node.getLabels());
                        continue block6;
                    }
                    case First: {
                        if (node.getLabels().isEmpty()) continue block6;
                        labels.add(node.getLabels().get(0));
                        continue block6;
                    }
                    case UsingValue: 
                    case AddLabel: {
                        int valueIndex = ((GraphOutputData)this.data).nodeMappingIndexes.get(i);
                        if (rowMeta.isNull(row, valueIndex)) {
                            throw new HopException("Null value found for field " + mapping.getFieldName() + " in node mapping " + mapping);
                        }
                        String value = rowMeta.getString(row, valueIndex);
                        Map<String, String> valueLabelMap = ((GraphOutputData)this.data).nodeValueLabelMergeMap.get(node.getName());
                        if (valueLabelMap == null) {
                            throw new HopException("No field-to-label mapping was specified for node " + node.getName());
                        }
                        String label = valueLabelMap.get(value);
                        if (label == null) continue block6;
                        if (mapping.getType() == NodeMappingType.UsingValue) {
                            labels.add(label);
                            continue block6;
                        }
                        labelsToSet.add(label);
                    }
                }
            }
            if (implicitNodeMapping) {
                labels.addAll(node.getLabels());
            }
            if (labels.isEmpty()) {
                throw new HopException("No node labels could be found for node: " + node.getName());
            }
            SelectedNode selectedNode = new SelectedNode(node, targetHint, new ArrayList<String>(labels), new ArrayList<String>(labelsToSet));
            nodesSet.add(selectedNode);
            nodeProperties.add(new NodeAndPropertyData(selectedNode, graphProperty, valueMeta, valueData, index));
        }
        return nodesSet;
    }

    private void setParameters(IRowMeta rowMeta, Object[] row, Map<String, Object> parameters, CypherParameters cypherParameters) throws HopValueException {
        for (TargetParameter targetParameter : cypherParameters.getTargetParameters()) {
            int fieldIndex = targetParameter.getInputFieldIndex();
            IValueMeta valueMeta = rowMeta.getValueMeta(fieldIndex);
            Object valueData = row[fieldIndex];
            String parameterName = targetParameter.getParameterName();
            GraphPropertyType parameterType = targetParameter.getParameterType();
            Object neoObject = parameterType.convertFromHop(valueMeta, valueData);
            parameters.put(parameterName, neoObject);
        }
    }

    private void addNodeCypher(StringBuilder cypher, SelectedNode selectedNode, Set<SelectedNode> handled, Set<SelectedNode> ignored, AtomicInteger parameterIndex, AtomicInteger nodeIndex, Map<SelectedNode, Integer> nodeIndexMap, List<NodeAndPropertyData> nodeProperties, Map<String, Object> parameters, CypherParameters cypherParameters) throws HopValueException {
        if (ignored.contains(selectedNode) || handled.contains(selectedNode)) {
            return;
        }
        handled.add(selectedNode);
        nodeIndexMap.put(selectedNode, nodeIndex.incrementAndGet());
        GraphNode node = selectedNode.getNode();
        StringBuilder nodeLabels = new StringBuilder();
        for (String nodeLabel : selectedNode.getLabels()) {
            nodeLabels.append(":");
            nodeLabels.append(nodeLabel);
        }
        StringBuilder matchCypher = new StringBuilder();
        String nodeAlias = "node" + nodeIndex;
        cypher.append("MERGE (").append(nodeAlias).append((CharSequence)nodeLabels).append(" { ");
        this.updateUsageMap(node.getLabels(), GraphUsage.NODE_UPDATE);
        if (this.isDebug()) {
            this.logDebug(" - node merge : " + node.getName());
        }
        boolean firstPrimary = true;
        boolean firstMatch = true;
        for (NodeAndPropertyData napd : nodeProperties) {
            if (!napd.node.equals(selectedNode)) continue;
            parameterIndex.incrementAndGet();
            boolean isNull = napd.sourceValueMeta.isNull(napd.sourceValueData);
            String parameterName = "param" + parameterIndex;
            if (napd.property.isPrimary()) {
                if (!firstPrimary) {
                    cypher.append(", ");
                }
                cypher.append(napd.property.getName()).append(" : ").append(this.buildParameterClause(parameterName)).append(" ");
                firstPrimary = false;
                if (this.isDebug()) {
                    this.logDebug("   * property match/create : " + napd.property.getName() + " with value " + napd.sourceValueMeta.toStringMeta() + " : " + napd.sourceValueMeta.getString(napd.sourceValueData));
                }
            } else {
                if (firstMatch) {
                    matchCypher.append("SET ");
                } else {
                    matchCypher.append(", ");
                }
                firstMatch = false;
                matchCypher.append(nodeAlias).append(".").append(napd.property.getName()).append(" = ");
                if (isNull) {
                    matchCypher.append("NULL ");
                } else {
                    matchCypher.append(this.buildParameterClause(parameterName)).append(" ");
                }
                if (this.isDebug()) {
                    this.logDebug("   * property update : " + napd.property.getName() + " with value " + napd.sourceValueMeta.toStringMeta() + " : " + napd.sourceValueMeta.getString(napd.sourceValueData));
                }
            }
            if (isNull) continue;
            parameters.put(parameterName, napd.property.getType().convertFromHop(napd.sourceValueMeta, napd.sourceValueData));
            TargetParameter targetParameter = new TargetParameter(napd.sourceValueMeta.getName(), napd.sourceFieldIndex, parameterName, napd.property.getType());
            cypherParameters.getTargetParameters().add(targetParameter);
        }
        for (String label : selectedNode.getLabelsToSet()) {
            if (firstMatch) {
                matchCypher.append("SET ");
            } else {
                matchCypher.append(", ");
            }
            matchCypher.append(nodeAlias).append(":").append(label).append(" ");
            firstMatch = false;
        }
        cypher.append("}) ").append(Const.CR);
        if (matchCypher.length() > 0) {
            cypher.append((CharSequence)matchCypher).append(Const.CR);
        }
    }

    private String buildParameterClause(String parameterName) {
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            return "pr." + parameterName;
        }
        return "$" + parameterName;
    }

    public void batchComplete() {
        this.wrapUpTransaction();
    }

    private void wrapUpTransaction() {
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            boolean errors = this.emptyUnwindMap();
            if (errors) {
                this.stopAll();
                this.setErrors(1L);
            }
        } else if (((GraphOutputData)this.data).outputCount > 0L) {
            ((GraphOutputData)this.data).transaction.commit();
            ((GraphOutputData)this.data).transaction.close();
            ((GraphOutputData)this.data).outputCount = 0L;
        }
    }

    protected void updateUsageMap(List<String> nodeLabels, GraphUsage usage) {
        Map transformsMap = ((GraphOutputData)this.data).usageMap.computeIfAbsent(usage.name(), k -> new HashMap());
        Set labelSet = transformsMap.computeIfAbsent(this.getTransformName(), k -> new HashSet());
        for (String label : nodeLabels) {
            if (!StringUtils.isNotEmpty((String)label)) continue;
            labelSet.add(label);
        }
    }

    protected GraphData getGraphData(Object[] row, IRowMeta rowMeta) throws HopException {
        GraphData graphData = new GraphData();
        graphData.setSourcePipelineName(this.getPipelineMeta().getName());
        graphData.setSourceTransformName(this.getTransformMeta().getName());
        SelectedNodesAndRelationships nar = this.selectNodesAndRelationships(rowMeta, row);
        AtomicInteger nodeIndex = new AtomicInteger(0);
        HashSet<SelectedNode> handled = new HashSet<SelectedNode>();
        HashMap<SelectedNode, Integer> nodeIndexMap = new HashMap<SelectedNode, Integer>();
        if (nar.relationships.isEmpty()) {
            if (nar.nodes.isEmpty()) {
                throw new HopException("We didn't find a node to write to.  Did you specify a field mapping to node properties?");
            }
            if (nar.nodes.size() > 1) {
                this.logBasic("Warning: writing to multiple nodes but not to any relationships");
            }
            for (SelectedNode node : nar.nodes) {
                GraphNodeData nodeData = this.getGraphNodeData(node, handled, nar.ignored, nodeIndex, nodeIndexMap, nar.nodeProperties);
                if (nodeData == null) continue;
                graphData.getNodes().add(nodeData);
            }
        } else {
            for (SelectedRelationship relationship : nar.relationships) {
                if (nar.avoided.contains(relationship)) continue;
                SelectedNode nodeSource = relationship.getSourceNode();
                SelectedNode nodeTarget = relationship.getTargetNode();
                for (SelectedNode node : new SelectedNode[]{nodeSource, nodeTarget}) {
                    GraphNodeData nodeData = this.getGraphNodeData(node, handled, nar.ignored, nodeIndex, nodeIndexMap, nar.nodeProperties);
                    if (nodeData == null) continue;
                    graphData.getNodes().add(nodeData);
                }
                if (nodeIndexMap.get(nodeSource) == null || nodeIndexMap.get(nodeTarget) == null) continue;
                String sourceNodeId = this.getGraphNodeDataId(nodeSource, nar.nodeProperties);
                String targetNodeId = this.getGraphNodeDataId(nodeTarget, nar.nodeProperties);
                String id = sourceNodeId + " -> " + targetNodeId;
                GraphRelationshipData relationshipData = new GraphRelationshipData();
                relationshipData.setId(id);
                relationshipData.setLabel(relationship.getRelationship().getLabel());
                relationshipData.setSourceNodeId(sourceNodeId);
                relationshipData.setTargetNodeId(targetNodeId);
                relationshipData.setPropertySetId(relationship.getRelationship().getName());
                ArrayList<GraphProperty> relProps = new ArrayList<GraphProperty>();
                ArrayList<Integer> relPropIndexes = new ArrayList<Integer>();
                Map<GraphProperty, Integer> propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.get(relationship.getRelationship().getName());
                if (propertyIndexMap != null) {
                    for (GraphProperty relProp : propertyIndexMap.keySet()) {
                        Integer relFieldIndex = propertyIndexMap.get(relProp);
                        if (relFieldIndex == null) continue;
                        relProps.add(relProp);
                        relPropIndexes.add(relFieldIndex);
                    }
                }
                if (!relProps.isEmpty()) {
                    for (int i = 0; i < relProps.size(); ++i) {
                        GraphProperty relProp;
                        relProp = (GraphProperty)relProps.get(i);
                        int propFieldIndex = (Integer)relPropIndexes.get(i);
                        IValueMeta sourceFieldMeta = rowMeta.getValueMeta(propFieldIndex);
                        Object sourceFieldValue = row[propFieldIndex];
                        String propId = relProp.getName();
                        GraphPropertyDataType relPropType = GraphPropertyDataType.getTypeFromHop(sourceFieldMeta);
                        Object neoValue = relPropType.convertFromHop(sourceFieldMeta, sourceFieldValue);
                        boolean primary = false;
                        relationshipData.getProperties().add(new GraphPropertyData(propId, neoValue, relPropType, primary));
                    }
                }
                graphData.getRelationships().add(relationshipData);
            }
        }
        return graphData;
    }

    private Set<SelectedNode> getIgnoredNodesWithPkNull(List<NodeAndPropertyData> nodeProperties) throws HopValueException {
        HashSet<SelectedNode> ignored = new HashSet<SelectedNode>();
        for (NodeAndPropertyData nodeProperty : nodeProperties) {
            if (!nodeProperty.property.isPrimary() || !nodeProperty.sourceValueMeta.isNull(nodeProperty.sourceValueData)) continue;
            if (this.isDebug()) {
                this.logDebug("Detected primary null property for node " + nodeProperty.node + " property " + nodeProperty.property + " value : " + nodeProperty.sourceValueMeta.getString(nodeProperty.sourceValueData));
            }
            if (ignored.contains(nodeProperty.node)) continue;
            ignored.add(nodeProperty.node);
        }
        return ignored;
    }

    private GraphNodeData getGraphNodeData(SelectedNode node, Set<SelectedNode> handled, Set<SelectedNode> ignored, AtomicInteger nodeIndex, Map<SelectedNode, Integer> nodeIndexMap, List<NodeAndPropertyData> nodeProperties) throws HopValueException {
        if (ignored.contains(node) || handled.contains(node)) {
            return null;
        }
        GraphNodeData graphNodeData = new GraphNodeData();
        graphNodeData.setPropertySetId(node.getNode().getName());
        handled.add(node);
        nodeIndexMap.put(node, nodeIndex.incrementAndGet());
        graphNodeData.getLabels().addAll(node.getNode().getLabels());
        boolean firstPrimary = true;
        boolean firstMatch = true;
        for (NodeAndPropertyData napd : nodeProperties) {
            if (!napd.node.equals(node)) continue;
            boolean isNull = napd.sourceValueMeta.isNull(napd.sourceValueData);
            if (napd.property.isPrimary()) {
                String oldId = graphNodeData.getId();
                String propertyString = napd.sourceValueMeta.getString(napd.sourceValueData);
                if (oldId == null) {
                    graphNodeData.setId(propertyString);
                } else {
                    graphNodeData.setId(oldId + "-" + propertyString);
                }
            }
            if (isNull) continue;
            GraphPropertyData propertyData = new GraphPropertyData();
            propertyData.setId(napd.property.getName());
            GraphPropertyDataType type = GraphPropertyDataType.getTypeFromHop(napd.sourceValueMeta);
            propertyData.setType(type);
            propertyData.setValue(type.convertFromHop(napd.sourceValueMeta, napd.sourceValueData));
            propertyData.setPrimary(napd.property.isPrimary());
            graphNodeData.getProperties().add(propertyData);
        }
        return graphNodeData;
    }

    public String getGraphNodeDataId(SelectedNode node, List<NodeAndPropertyData> nodeProperties) throws HopValueException {
        StringBuffer id = new StringBuffer();
        for (NodeAndPropertyData napd : nodeProperties) {
            if (!napd.node.equals(node) || !napd.property.isPrimary()) continue;
            String propertyString = napd.sourceValueMeta.getString(napd.sourceValueData);
            if (id.length() > 0) {
                id.append("-");
            }
            id.append(propertyString);
        }
        return id.toString();
    }

    public void checkGraphProperty(GraphProperty graphProperty) {
        Object graphPropertyValue = graphProperty.getName();
        Pattern p = Pattern.compile("[^A-Za-z0-9]");
        Matcher m = p.matcher((CharSequence)graphPropertyValue);
        if (m.find()) {
            graphPropertyValue = "`" + (String)graphPropertyValue + "`";
            graphProperty.setName((String)graphPropertyValue);
        }
    }

    private static /* synthetic */ Result lambda$emptyUnwindMap$5(String unwindCypher, Map props, Transaction tx) {
        return tx.run(unwindCypher, props);
    }

    private class SelectedNodesAndRelationships {
        public Set<SelectedNode> nodes;
        public Set<SelectedRelationship> relationships;
        public Set<SelectedRelationship> avoided;
        public List<NodeAndPropertyData> nodeProperties;
        public Set<SelectedNode> ignored;

        public SelectedNodesAndRelationships(Set<SelectedNode> nodes, Set<SelectedRelationship> relationships, Set<SelectedRelationship> avoided, List<NodeAndPropertyData> nodeProperties, Set<SelectedNode> ignored) {
            this.nodes = nodes;
            this.relationships = relationships;
            this.avoided = avoided;
            this.nodeProperties = nodeProperties;
            this.ignored = ignored;
        }
    }

    private static class NodeAndPropertyData {
        public SelectedNode node;
        public GraphProperty property;
        public IValueMeta sourceValueMeta;
        public Object sourceValueData;
        public int sourceFieldIndex;

        public NodeAndPropertyData(SelectedNode node, GraphProperty property, IValueMeta sourceValueMeta, Object sourceValueData, int sourceFieldIndex) {
            this.node = node;
            this.property = property;
            this.sourceValueMeta = sourceValueMeta;
            this.sourceValueData = sourceValueData;
            this.sourceFieldIndex = sourceFieldIndex;
        }
    }
}

