/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import java.io.DataInputStream;
import java.io.EOFException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaPluginType;
import org.apache.hop.core.row.value.ValueMetaString;
import org.json.simple.JSONObject;

public class ValueMetaFactory {
    public static PluginRegistry pluginRegistry = PluginRegistry.getInstance();

    private ValueMetaFactory() {
    }

    public static IValueMeta createValueMeta(String name, int type, int length, int precision) throws HopPluginException {
        IPlugin stringPlugin = pluginRegistry.getPlugin(ValueMetaPluginType.class, String.valueOf(type));
        if (stringPlugin == null) {
            throw new HopPluginException("Unable to locate value meta plugin of type (id) " + type);
        }
        IValueMeta valueMeta = pluginRegistry.loadClass(stringPlugin, IValueMeta.class);
        valueMeta.setName(name);
        valueMeta.setLength(length, precision);
        return valueMeta;
    }

    public static IValueMeta createValueMeta(String name, int type) throws HopPluginException {
        return ValueMetaFactory.createValueMeta(name, type, -1, -1);
    }

    public static IValueMeta createValueMeta(int type) throws HopPluginException {
        return ValueMetaFactory.createValueMeta(null, type, -1, -1);
    }

    public static IValueMeta cloneValueMeta(IValueMeta source) throws HopPluginException {
        return ValueMetaFactory.cloneValueMeta(source, source.getType());
    }

    public static IValueMeta cloneValueMeta(IValueMeta source, int targetType) throws HopPluginException {
        IValueMeta target = null;
        target = source.getType() == targetType ? source.clone() : ValueMetaFactory.createValueMeta(source.getName(), targetType, source.getLength(), source.getPrecision());
        ValueMetaFactory.cloneInfo(source, target);
        return target;
    }

    public static void cloneInfo(IValueMeta source, IValueMeta target) throws HopPluginException {
        target.setConversionMask(source.getConversionMask());
        target.setDecimalSymbol(source.getDecimalSymbol());
        target.setGroupingSymbol(source.getGroupingSymbol());
        target.setStorageType(source.getStorageType());
        if (source.getStorageMetadata() != null) {
            target.setStorageMetadata(ValueMetaFactory.cloneValueMeta(source.getStorageMetadata(), source.getStorageMetadata().getType()));
        }
        target.setStringEncoding(source.getStringEncoding());
        target.setTrimType(source.getTrimType());
        target.setDateFormatLenient(source.isDateFormatLenient());
        target.setDateFormatLocale(source.getDateFormatLocale());
        target.setDateFormatTimeZone(source.getDateFormatTimeZone());
        target.setLenientStringToNumber(source.isLenientStringToNumber());
        target.setLargeTextField(source.isLargeTextField());
        target.setComments(source.getComments());
        target.setCaseInsensitive(source.isCaseInsensitive());
        target.setCollatorDisabled(source.isCollatorDisabled());
        target.setCollatorStrength(source.getCollatorStrength());
        target.setIndex(source.getIndex());
        target.setOrigin(source.getOrigin());
        target.setOriginalAutoIncrement(source.isOriginalAutoIncrement());
        target.setOriginalColumnType(source.getOriginalColumnType());
        target.setOriginalColumnTypeName(source.getOriginalColumnTypeName());
        target.setOriginalNullable(source.isOriginalNullable());
        target.setOriginalPrecision(source.getOriginalPrecision());
        target.setOriginalScale(source.getOriginalScale());
        target.setOriginalSigned(source.isOriginalSigned());
    }

    public static String[] getValueMetaNames() {
        ArrayList<String> strings = new ArrayList<String>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (IPlugin plugin : plugins) {
            int id = Integer.valueOf(plugin.getIds()[0]);
            if (id <= 0 || id == 7) continue;
            strings.add(plugin.getName());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String[] getAllValueMetaNames() {
        ArrayList<String> strings = new ArrayList<String>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (IPlugin plugin : plugins) {
            String id = plugin.getIds()[0];
            if ("0".equals(id)) continue;
            strings.add(plugin.getName());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String getValueMetaName(int type) {
        for (IPlugin plugin : pluginRegistry.getPlugins(ValueMetaPluginType.class)) {
            if (!Integer.toString(type).equals(plugin.getIds()[0])) continue;
            return plugin.getName();
        }
        return "-";
    }

    public static int getIdForValueMeta(String valueMetaName) {
        for (IPlugin plugin : pluginRegistry.getPlugins(ValueMetaPluginType.class)) {
            if (valueMetaName == null || !valueMetaName.equalsIgnoreCase(plugin.getName())) continue;
            return Integer.valueOf(plugin.getIds()[0]);
        }
        return 0;
    }

    public static List<IValueMeta> getValueMetaPluginClasses() throws HopPluginException {
        ArrayList<IValueMeta> list = new ArrayList<IValueMeta>();
        List plugins = pluginRegistry.getPlugins(ValueMetaPluginType.class);
        for (IPlugin plugin : plugins) {
            IValueMeta iValueMeta = (IValueMeta)pluginRegistry.loadClass(plugin);
            list.add(iValueMeta);
        }
        return list;
    }

    public static IValueMeta guessValueMetaInterface(Object object) {
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                return new ValueMetaBigNumber();
            }
            if (object instanceof Double) {
                return new ValueMetaNumber();
            }
            if (object instanceof Long) {
                return new ValueMetaInteger();
            }
        } else {
            if (object instanceof String) {
                return new ValueMetaString();
            }
            if (object instanceof Date) {
                return new ValueMetaDate();
            }
            if (object instanceof Boolean) {
                return new ValueMetaBoolean();
            }
            if (object instanceof byte[]) {
                return new ValueMetaBinary();
            }
        }
        return null;
    }

    public static IValueMeta loadValueMetaFromJson(JSONObject jValue) throws HopPluginException {
        String name = (String)jValue.get((Object)"name");
        long type = (Long)jValue.get((Object)"type");
        IValueMeta valueMeta = ValueMetaFactory.createValueMeta(name, (int)type);
        valueMeta.loadMetaFromJson(jValue);
        return valueMeta;
    }

    public static IValueMeta loadValueMeta(DataInputStream inputStream) throws HopFileException {
        try {
            int type = inputStream.readInt();
            IValueMeta valueMeta = ValueMetaFactory.createValueMeta(type);
            valueMeta.readMetaData(inputStream);
            return valueMeta;
        }
        catch (EOFException e) {
            throw new HopEofException(e);
        }
        catch (Exception e) {
            throw new HopFileException("Unable to read value metadata from input stream", e);
        }
    }
}

