/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PCollectionTranslation {
    private PCollectionTranslation() {
    }

    public static  @UnknownKeyFor @NonNull @Initialized RunnerApi.PCollection toProto(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pCollection, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String coderId = components.registerCoder(pCollection.getCoder());
        String windowingStrategyId = components.registerWindowingStrategy(pCollection.getWindowingStrategy());
        return RunnerApi.PCollection.newBuilder().setUniqueName(pCollection.getName()).setCoderId(coderId).setIsBounded(PCollectionTranslation.toProto(pCollection.isBounded())).setWindowingStrategyId(windowingStrategyId).build();
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fromProto( @UnknownKeyFor @NonNull @Initialized RunnerApi.PCollection pCollection, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized RehydratedComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Coder<?> coder = components.getCoder(pCollection.getCoderId());
        return PCollection.createPrimitiveOutputInternal(pipeline, components.getWindowingStrategy(pCollection.getWindowingStrategyId()), PCollectionTranslation.fromProto(pCollection.getIsBounded()), coder);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded( @UnknownKeyFor @NonNull @Initialized RunnerApi.PCollection pCollection) {
        return PCollectionTranslation.fromProto(pCollection.getIsBounded());
    }

    static  @UnknownKeyFor @NonNull @Initialized RunnerApi.IsBounded.Enum toProto(@UnknownKeyFor @NonNull @Initialized PCollection.IsBounded bounded) {
        switch (bounded) {
            case BOUNDED: {
                return RunnerApi.IsBounded.Enum.BOUNDED;
            }
            case UNBOUNDED: {
                return RunnerApi.IsBounded.Enum.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s %s", new Object[]{PCollection.IsBounded.class.getSimpleName(), bounded}));
    }

    static @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded fromProto( @UnknownKeyFor @NonNull @Initialized RunnerApi.IsBounded.Enum isBounded) {
        switch (isBounded) {
            case BOUNDED: {
                return PCollection.IsBounded.BOUNDED;
            }
            case UNBOUNDED: {
                return PCollection.IsBounded.UNBOUNDED;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", new Object[]{RunnerApi.IsBounded.class.getCanonicalName(), PCollection.IsBounded.class.getCanonicalName(), isBounded}));
    }
}

