/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.spark.api.java.JavaSparkContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkPCollectionView
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkPCollectionView.class);
    private volatile transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast> broadcastHelperMap = null;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>>> pviews = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void putPView(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> coder) {
        this.pviews.put(view, new Tuple2((Object)CoderHelpers.toByteArray(value, coder), coder));
        if (this.broadcastHelperMap == null) return;
        Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
        synchronized (SparkPCollectionView.class) {
            SideInputBroadcast helper = this.broadcastHelperMap.get(view);
            if (helper == null) return;
            helper.unpersist();
            this.broadcastHelperMap.remove(view);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @UnknownKeyFor @NonNull @Initialized SideInputBroadcast getPCollectionView(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized JavaSparkContext context) {
        SideInputBroadcast helper;
        if (this.broadcastHelperMap == null) {
            Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
            // MONITORENTER : org.apache.beam.runners.spark.translation.SparkPCollectionView.class
            if (this.broadcastHelperMap == null) {
                this.broadcastHelperMap = new LinkedHashMap();
            }
            // MONITOREXIT : clazz
        }
        if ((helper = this.broadcastHelperMap.get(view)) != null) return helper;
        Class<SparkPCollectionView> clazz = SparkPCollectionView.class;
        // MONITORENTER : org.apache.beam.runners.spark.translation.SparkPCollectionView.class
        helper = this.broadcastHelperMap.get(view);
        if (helper == null) {
            helper = this.createBroadcastHelper(view, context);
        }
        // MONITOREXIT : clazz
        return helper;
    }

    private @UnknownKeyFor @NonNull @Initialized SideInputBroadcast createBroadcastHelper(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized JavaSparkContext context) {
        Tuple2<byte[], Coder<Iterable<WindowedValue<?>>>> tuple2 = this.pviews.get(view);
        SideInputBroadcast helper = SideInputBroadcast.create((byte[])tuple2._1, (Coder)tuple2._2);
        String pCollectionName = view.getPCollection() != null ? view.getPCollection().getName() : "UNKNOWN";
        LOG.debug("Broadcasting [size={}B] view {} from pCollection {}", new Object[]{helper.getBroadcastSizeEstimate(), view, pCollectionName});
        helper.broadcast(context);
        this.broadcastHelperMap.put(view, helper);
        return helper;
    }
}

