/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.LanguageModelChatMeta;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.FormDataBuilder;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.IDialogComposite;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.i18nUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class GeneralSettingsComposite
implements IDialogComposite {
    private final Composite composite;
    private final LanguageModelChatMeta meta;
    private final Label inputFieldLabel;
    private final CCombo inputFieldInput;
    private final Label outputFieldNamePrefixLabel;
    private final TextVar outputFieldNamePrefixInput;
    private final Label identifierLabel;
    private final TextVar identifierInput;
    private final Button inputChatJsonInput;
    private final Button outputChatJsonInput;
    private final Button mockInput;
    private final Label mockOutputValueLabel;
    private final TextVar mockOutputValueInput;
    private final Label parallelismLabel;
    private final TextVar parallelismInput;
    private final Label modelTypeLabel;
    private final CCombo modelTypeInput;
    private final Control control;
    private final CompositeParameters parameters;
    private boolean gotPreviousFields = false;

    public GeneralSettingsComposite(final CompositeParameters parameters) {
        this.parameters = parameters;
        this.meta = (LanguageModelChatMeta)parameters.meta();
        this.composite = new Composite(parameters.parent(), 0);
        int middle = parameters.middlePct();
        int margin = parameters.margin();
        FormDataBuilder.Builder layout = FormDataBuilder.Builder.buildFormData().margin(margin);
        this.inputChatJsonInput = new Button(parameters.parent(), 32);
        PropsUi.setLook((Widget)this.inputChatJsonInput);
        layout.control((Control)this.composite);
        this.inputChatJsonInput.setText(i18nUtil.i18n("LanguageModelChatDialog.InputChatJson.Label"));
        this.inputChatJsonInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.outputChatJsonInput = new Button(parameters.parent(), 32);
        PropsUi.setLook((Widget)this.outputChatJsonInput);
        layout.control((Control)this.inputChatJsonInput);
        this.outputChatJsonInput.setText(i18nUtil.i18n("LanguageModelChatDialog.OutputChatJson.Label"));
        this.outputChatJsonInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.inputFieldLabel = new Label(parameters.parent(), 131072);
        this.inputFieldLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.InputFieldName.Label"));
        PropsUi.setLook((Widget)this.inputFieldLabel);
        layout.control((Control)this.outputChatJsonInput);
        this.inputFieldLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.inputFieldInput = new CCombo(parameters.parent(), 2056);
        PropsUi.setLook((Widget)this.inputFieldInput);
        this.inputFieldInput.addModifyListener(e -> this.meta.setChanged());
        this.inputFieldInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.inputFieldInput.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)parameters.shell().getDisplay(), 1);
                parameters.shell().setCursor(busy);
                GeneralSettingsComposite.this.get();
                parameters.shell().setCursor(null);
                busy.dispose();
            }
        });
        this.outputFieldNamePrefixLabel = new Label(parameters.parent(), 131072);
        this.outputFieldNamePrefixInput = new TextVar(parameters.variables(), parameters.parent(), 18436);
        PropsUi.setLook((Widget)this.outputFieldNamePrefixLabel);
        PropsUi.setLook((Widget)this.outputFieldNamePrefixInput);
        layout.control((Control)this.inputFieldInput);
        this.outputFieldNamePrefixLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.OutputFieldNamePrefixName.Label"));
        this.outputFieldNamePrefixLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.outputFieldNamePrefixInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.identifierLabel = new Label(parameters.parent(), 131072);
        this.identifierInput = new TextVar(parameters.variables(), parameters.parent(), 18436);
        PropsUi.setLook((Widget)this.identifierLabel);
        PropsUi.setLook((Widget)this.identifierInput);
        layout.control((Control)this.outputFieldNamePrefixInput);
        this.identifierLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.Identifier.Label"));
        this.identifierLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.identifierInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.parallelismLabel = new Label(parameters.parent(), 131072);
        this.parallelismInput = new TextVar(parameters.variables(), parameters.parent(), 18436);
        PropsUi.setLook((Widget)this.parallelismLabel);
        PropsUi.setLook((Widget)this.parallelismInput);
        layout.control((Control)this.identifierInput);
        this.parallelismLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.Parallelism.Label"));
        this.parallelismLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.parallelismInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.mockInput = new Button(parameters.parent(), 32);
        PropsUi.setLook((Widget)this.mockInput);
        layout.control((Control)this.parallelismInput);
        this.mockInput.setText(i18nUtil.i18n("LanguageModelChatDialog.Mock.Label"));
        this.mockInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.mockOutputValueLabel = new Label(parameters.parent(), 131072);
        this.mockOutputValueInput = new TextVar(parameters.variables(), parameters.parent(), 18436);
        PropsUi.setLook((Widget)this.mockOutputValueLabel);
        PropsUi.setLook((Widget)this.mockOutputValueInput);
        layout.control((Control)this.mockInput);
        this.mockOutputValueLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.MockOutputValue.Label"));
        this.mockOutputValueLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.mockOutputValueInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.modelTypeLabel = new Label(parameters.parent(), 131072);
        this.modelTypeInput = new CCombo(parameters.parent(), 2056);
        PropsUi.setLook((Widget)this.modelTypeLabel);
        PropsUi.setLook((Widget)this.modelTypeInput);
        layout.control((Control)this.mockOutputValueInput);
        this.modelTypeLabel.setText(i18nUtil.i18n("LanguageModelChatDialog.ModelType.Label"));
        this.modelTypeLabel.setLayoutData((Object)layout.left(0, 0).right(middle, -margin).build());
        this.modelTypeInput.setItems(ModelType.modelTypeDescriptions());
        this.modelTypeInput.addModifyListener(e -> this.meta.setChanged());
        this.modelTypeInput.setLayoutData((Object)layout.left(middle, 0).right(100, 0).build());
        this.modelTypeInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String modelType = ModelType.typeFromDescription(GeneralSettingsComposite.this.modelTypeInput.getText()).code();
                ((LanguageModelChatMeta)parameters.meta()).setModelType(modelType);
                parameters.getPopulateInputsAdapter().populateInputs();
            }
        });
        this.control = this.modelTypeInput;
    }

    @Override
    public void updateLayouts() {
        this.composite().layout(true, true);
    }

    @Override
    public boolean validateInputs() {
        if (StringUtils.isBlank((CharSequence)this.inputFieldInput.getText())) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.modelTypeInput.getText())) {
            return false;
        }
        String parallelism = StringUtils.trim((String)this.parallelismInput.getText());
        return StringUtils.isBlank((CharSequence)parallelism) || NumberUtils.isCreatable((String)parallelism);
    }

    @Override
    public Control control() {
        return this.control;
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setInputField(this.inputFieldInput.getText());
        this.meta.setInputChatJson(this.inputChatJsonInput.getSelection());
        this.meta.setOutputChatJson(this.outputChatJsonInput.getSelection());
        this.meta.setMock(this.mockInput.getSelection());
        this.meta.setMockOutputValue(this.mockOutputValueInput.getText());
        this.meta.setOutputFieldNamePrefix(this.outputFieldNamePrefixInput.getText());
        this.meta.setIdentifierValue(this.identifierInput.getText());
        this.meta.setModelType(ModelType.typeFromDescription(this.modelTypeInput.getText()).code());
        this.meta.setParallelism(NumberUtils.toInt((String)StringUtils.trim((String)this.parallelismInput.getText()), (int)1));
    }

    @Override
    public void populateInputs() {
        this.inputFieldInput.setText(this.meta.getInputField() != null ? this.meta.getInputField() : "");
        this.inputChatJsonInput.setSelection(this.meta.isInputChatJson());
        this.outputChatJsonInput.setSelection(this.meta.isOutputChatJson());
        this.mockInput.setSelection(this.meta.isMock());
        this.mockOutputValueInput.setText(this.meta.getMockOutputValue() != null ? this.meta.getMockOutputValue() : "");
        this.outputFieldNamePrefixInput.setText(this.meta.getOutputFieldNamePrefix() != null ? this.meta.getOutputFieldNamePrefix() : "");
        this.identifierInput.setText(this.meta.getIdentifierValue() != null ? this.meta.getIdentifierValue() : "");
        String modelType = this.meta.getModelType() != null ? this.meta.getModelType() : "";
        this.modelTypeInput.setText(ModelType.valueOf(modelType).description());
        this.parallelismInput.setText(String.valueOf(this.meta.getParallelism()));
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String inputField = null;
                if (this.inputFieldInput.getText() != null) {
                    inputField = this.inputFieldInput.getText();
                }
                this.inputFieldInput.removeAll();
                IRowMeta r = this.parameters.pipelineMeta().getPrevTransformFields(this.parameters.variables(), this.parameters.transformName());
                if (r != null) {
                    this.inputFieldInput.setItems(r.getFieldNames());
                }
                if (inputField != null) {
                    this.inputFieldInput.setText(inputField);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.parameters.shell(), i18nUtil.i18n("LanguageModelChatDialog.FailedToGetFields.DialogTitle"), i18nUtil.i18n("LanguageModelChatDialog.FailedToGetFields.DialogMessage"), (Exception)((Object)ke));
            }
        }
    }

    @Override
    public Composite composite() {
        return this.composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Label getInputFieldLabel() {
        return this.inputFieldLabel;
    }

    public CCombo getInputFieldInput() {
        return this.inputFieldInput;
    }

    public Label getOutputFieldNamePrefixLabel() {
        return this.outputFieldNamePrefixLabel;
    }

    public TextVar getOutputFieldNamePrefixInput() {
        return this.outputFieldNamePrefixInput;
    }

    public Label getIdentifierLabel() {
        return this.identifierLabel;
    }

    public TextVar getIdentifierInput() {
        return this.identifierInput;
    }

    public Button getInputChatJsonInput() {
        return this.inputChatJsonInput;
    }

    public Button getOutputChatJsonInput() {
        return this.outputChatJsonInput;
    }

    public Button getMockInput() {
        return this.mockInput;
    }

    public Label getMockOutputValueLabel() {
        return this.mockOutputValueLabel;
    }

    public TextVar getMockOutputValueInput() {
        return this.mockOutputValueInput;
    }

    public Label getParallelismLabel() {
        return this.parallelismLabel;
    }

    public TextVar getParallelismInput() {
        return this.parallelismInput;
    }

    public Label getModelTypeLabel() {
        return this.modelTypeLabel;
    }

    public CCombo getModelTypeInput() {
        return this.modelTypeInput;
    }
}

