/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hop.databases.cassandra.util.Selector;

public class CqlUtils {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s){2,}");
    private static final Pattern WHITESPACE_IN_FUNCTION_OPEN_BRACKET_PATTERN = Pattern.compile("(\\s)*(\\()(\\s)*");
    private static final Pattern WHITESPACE_IN_FUNCTION_CLOSE_BRACKET_PATTERN = Pattern.compile("(\\s)*(\\))");
    private static final Pattern UNNECESSARY_WHITESPACE_BEFORE_COMMA_PATTERN = Pattern.compile("(\\s)+(,)");
    private static final Pattern ADD_WHITESPACE_AFTER_COMMA_PATTERN = Pattern.compile("(,)(?=[\\da-zA-Z])");
    private static final Pattern DOUBLE_QUOTES_PATTERN = Pattern.compile("\"");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("'");
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");
    private static final String DISTINCT = "distinct";
    private static final String FIRST = "first";
    private static final String OPEN_BRACKET = "(";
    private static final String CLOSE_BRACKET = ")";
    private static final String ALIAS_INDICATOR = " AS ";
    private static final String COMMA = ",";
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String WHITESPACE = " ";

    private static ArrayList<Selector> getSelectors(String selectExpression, boolean isCql3) {
        ArrayList<Selector> sList = new ArrayList<Selector>();
        selectExpression = CqlUtils.clean(selectExpression);
        while (selectExpression.length() > 0) {
            int possibleEnd = selectExpression.indexOf(COMMA);
            String possibleSelectorElement = possibleEnd != -1 ? selectExpression.substring(0, possibleEnd) : selectExpression;
            selectExpression = possibleEnd != -1 ? selectExpression.substring(possibleEnd + 1, selectExpression.length()).trim() : "";
            Selector realSelectorElement = CqlUtils.buildSelector(possibleSelectorElement, isCql3);
            if (!CqlUtils.isPartOfFunction(possibleSelectorElement) || CqlUtils.isFunction(possibleSelectorElement)) {
                realSelectorElement = CqlUtils.buildSelector(possibleSelectorElement, isCql3);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(possibleSelectorElement).append(COMMA).append(WHITESPACE);
                int indexFunctionEnd = selectExpression.indexOf(CLOSE_BRACKET);
                possibleEnd = selectExpression.indexOf(COMMA, indexFunctionEnd);
                possibleSelectorElement = possibleEnd != -1 ? selectExpression.substring(0, possibleEnd) : selectExpression;
                sb.append(possibleSelectorElement);
                possibleSelectorElement = sb.toString();
                selectExpression = possibleEnd != -1 ? selectExpression.substring(possibleEnd + 1, selectExpression.length()).trim() : "";
                realSelectorElement = CqlUtils.buildSelector(possibleSelectorElement, isCql3);
            }
            sList.add(realSelectorElement);
        }
        return sList;
    }

    public static String getSelectExpression(String cqlExpression) {
        String selectExpression = null;
        if (cqlExpression != null && !cqlExpression.isEmpty()) {
            cqlExpression = CqlUtils.clean(cqlExpression);
            int end = cqlExpression.toLowerCase().indexOf(FROM);
            int start = cqlExpression.toLowerCase().indexOf(SELECT) + SELECT.length();
            if (start > -1 && end > -1) {
                int distInd;
                selectExpression = cqlExpression.substring(start, end);
                int firstInd = selectExpression.toLowerCase().indexOf(FIRST);
                if (firstInd > -1) {
                    int nearWsIndex;
                    String numberPart = (selectExpression = selectExpression.substring(firstInd + FIRST.length()).trim()).substring(0, nearWsIndex = selectExpression.indexOf(WHITESPACE));
                    String string = selectExpression = CqlUtils.isNumeric(numberPart) ? selectExpression.substring(nearWsIndex) : selectExpression;
                }
                if ((distInd = selectExpression.toLowerCase().indexOf(DISTINCT)) > -1) {
                    selectExpression = selectExpression.substring(distInd + DISTINCT.length()).trim();
                }
                selectExpression = selectExpression.trim();
            }
        }
        return selectExpression;
    }

    public static Selector[] getColumnsInSelect(String selectExpression, boolean isCql3) {
        if (selectExpression != null && !selectExpression.isEmpty()) {
            ArrayList<Selector> selectors = CqlUtils.getSelectors(selectExpression.trim(), isCql3);
            return selectors.toArray(new Selector[selectors.size()]);
        }
        return null;
    }

    public static Selector buildSelector(String selector, boolean isCql3) {
        String columnName = CqlUtils.getColumnName(selector, isCql3);
        return new Selector(CqlUtils.getGeneralVariantForSpecificNames(columnName), CqlUtils.getAlias(selector, isCql3), CqlUtils.getFunction(selector));
    }

    private static String getFunction(String selector) {
        String f = null;
        if (CqlUtils.isFunction(selector)) {
            f = selector.substring(0, selector.indexOf(OPEN_BRACKET)).trim().toLowerCase();
        }
        return f;
    }

    private static boolean isPartOfFunction(String element) {
        return element.contains(OPEN_BRACKET) || element.contains(CLOSE_BRACKET);
    }

    private static boolean isFunction(String element) {
        return element.contains(OPEN_BRACKET) && element.contains(CLOSE_BRACKET);
    }

    private static final String getColumnName(String element, boolean isCql3) {
        String name = element.trim();
        int idx = element.toUpperCase().indexOf(ALIAS_INDICATOR);
        if (idx > -1) {
            name = name.substring(0, idx).trim();
        }
        if (!CqlUtils.isFunction(element)) {
            name = CqlUtils.getNormalizedForCql3Name(name, isCql3);
        }
        name = CqlUtils.cleanQuotes(name);
        return name;
    }

    private static String getAlias(String element, boolean isCql3) {
        String alias = null;
        int idx = element.toUpperCase().indexOf(ALIAS_INDICATOR);
        if (idx > -1) {
            alias = CqlUtils.getNormalizedForCql3Name(element.substring(idx + ALIAS_INDICATOR.length()), isCql3);
            alias = CqlUtils.cleanQuotes(alias);
        }
        return alias;
    }

    private static String cleanUnnecessaryWhitespaces(String input) {
        String cleaned = null;
        if (input != null) {
            cleaned = WHITESPACE_PATTERN.matcher(input.trim()).replaceAll(WHITESPACE);
            cleaned = WHITESPACE_IN_FUNCTION_OPEN_BRACKET_PATTERN.matcher(cleaned.trim()).replaceAll("$2");
            cleaned = WHITESPACE_IN_FUNCTION_CLOSE_BRACKET_PATTERN.matcher(cleaned.trim()).replaceAll("$2");
            cleaned = UNNECESSARY_WHITESPACE_BEFORE_COMMA_PATTERN.matcher(cleaned.trim()).replaceAll("$2");
        }
        return cleaned;
    }

    private static String addWhitespaceAfterComa(String input) {
        String cleaned = null;
        if (input != null) {
            cleaned = ADD_WHITESPACE_AFTER_COMMA_PATTERN.matcher(input.trim()).replaceAll("$1 ");
        }
        return cleaned;
    }

    public static String clean(String input) {
        String cleaned = null;
        if (input != null) {
            cleaned = CqlUtils.cleanUnnecessaryWhitespaces(input);
            cleaned = CqlUtils.addWhitespaceAfterComa(cleaned);
        }
        return cleaned;
    }

    public static String cleanQuotes(String input) {
        String cleaned = null;
        if (input != null) {
            cleaned = DOUBLE_QUOTES_PATTERN.matcher(input).replaceAll("");
            cleaned = QUOTE_PATTERN.matcher(cleaned).replaceAll("");
        }
        return cleaned;
    }

    private static boolean isQuoted(String input) {
        return DOUBLE_QUOTES_PATTERN.matcher(input).find() || QUOTE_PATTERN.matcher(input).find();
    }

    private static String getGeneralVariantForSpecificNames(String sName) {
        String gName = null;
        if (sName != null) {
            String name = SpecificNames.getName(sName);
            gName = name != null ? name : sName;
        }
        return gName;
    }

    private static String getNormalizedForCql3Name(String input, boolean isCql3) {
        String normalizedName = input;
        if (isCql3 && !CqlUtils.isQuoted(input)) {
            normalizedName = input.toLowerCase();
        }
        return normalizedName;
    }

    private static boolean isNumeric(String input) {
        boolean result = false;
        if (input != null) {
            result = NUMERIC_PATTERN.matcher(input).matches();
        }
        return result;
    }

    private static enum SpecificNames {
        COUNT("count", "count(*)", "count(1)");

        List<String> variants;
        private static final Map<String, String> SPECIFIC_NAMES;

        private SpecificNames(String ... variants) {
            this.variants = Arrays.asList(variants);
        }

        private List<String> getVariants() {
            return this.variants;
        }

        private static String getName(String value) {
            return SPECIFIC_NAMES.get(value.toUpperCase());
        }

        static {
            SPECIFIC_NAMES = new HashMap<String, String>();
            for (SpecificNames sName : SpecificNames.values()) {
                for (String variants : sName.getVariants()) {
                    SPECIFIC_NAMES.put(variants.toUpperCase(), sName.name());
                }
            }
        }
    }
}

