/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.UploadSessionOffsetError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UploadSessionAppendError {
    public static final UploadSessionAppendError NOT_FOUND = new UploadSessionAppendError().withTag(Tag.NOT_FOUND);
    public static final UploadSessionAppendError CLOSED = new UploadSessionAppendError().withTag(Tag.CLOSED);
    public static final UploadSessionAppendError NOT_CLOSED = new UploadSessionAppendError().withTag(Tag.NOT_CLOSED);
    public static final UploadSessionAppendError TOO_LARGE = new UploadSessionAppendError().withTag(Tag.TOO_LARGE);
    public static final UploadSessionAppendError CONCURRENT_SESSION_INVALID_OFFSET = new UploadSessionAppendError().withTag(Tag.CONCURRENT_SESSION_INVALID_OFFSET);
    public static final UploadSessionAppendError CONCURRENT_SESSION_INVALID_DATA_SIZE = new UploadSessionAppendError().withTag(Tag.CONCURRENT_SESSION_INVALID_DATA_SIZE);
    public static final UploadSessionAppendError PAYLOAD_TOO_LARGE = new UploadSessionAppendError().withTag(Tag.PAYLOAD_TOO_LARGE);
    public static final UploadSessionAppendError OTHER = new UploadSessionAppendError().withTag(Tag.OTHER);
    public static final UploadSessionAppendError CONTENT_HASH_MISMATCH = new UploadSessionAppendError().withTag(Tag.CONTENT_HASH_MISMATCH);
    private Tag _tag;
    private UploadSessionOffsetError incorrectOffsetValue;

    private UploadSessionAppendError() {
    }

    private UploadSessionAppendError withTag(Tag _tag) {
        UploadSessionAppendError result = new UploadSessionAppendError();
        result._tag = _tag;
        return result;
    }

    private UploadSessionAppendError withTagAndIncorrectOffset(Tag _tag, UploadSessionOffsetError incorrectOffsetValue) {
        UploadSessionAppendError result = new UploadSessionAppendError();
        result._tag = _tag;
        result.incorrectOffsetValue = incorrectOffsetValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isNotFound() {
        return this._tag == Tag.NOT_FOUND;
    }

    public boolean isIncorrectOffset() {
        return this._tag == Tag.INCORRECT_OFFSET;
    }

    public static UploadSessionAppendError incorrectOffset(UploadSessionOffsetError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadSessionAppendError().withTagAndIncorrectOffset(Tag.INCORRECT_OFFSET, value);
    }

    public UploadSessionOffsetError getIncorrectOffsetValue() {
        if (this._tag != Tag.INCORRECT_OFFSET) {
            throw new IllegalStateException("Invalid tag: required Tag.INCORRECT_OFFSET, but was Tag." + this._tag.name());
        }
        return this.incorrectOffsetValue;
    }

    public boolean isClosed() {
        return this._tag == Tag.CLOSED;
    }

    public boolean isNotClosed() {
        return this._tag == Tag.NOT_CLOSED;
    }

    public boolean isTooLarge() {
        return this._tag == Tag.TOO_LARGE;
    }

    public boolean isConcurrentSessionInvalidOffset() {
        return this._tag == Tag.CONCURRENT_SESSION_INVALID_OFFSET;
    }

    public boolean isConcurrentSessionInvalidDataSize() {
        return this._tag == Tag.CONCURRENT_SESSION_INVALID_DATA_SIZE;
    }

    public boolean isPayloadTooLarge() {
        return this._tag == Tag.PAYLOAD_TOO_LARGE;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isContentHashMismatch() {
        return this._tag == Tag.CONTENT_HASH_MISMATCH;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.incorrectOffsetValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UploadSessionAppendError) {
            UploadSessionAppendError other = (UploadSessionAppendError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case NOT_FOUND: {
                    return true;
                }
                case INCORRECT_OFFSET: {
                    return this.incorrectOffsetValue == other.incorrectOffsetValue || this.incorrectOffsetValue.equals(other.incorrectOffsetValue);
                }
                case CLOSED: {
                    return true;
                }
                case NOT_CLOSED: {
                    return true;
                }
                case TOO_LARGE: {
                    return true;
                }
                case CONCURRENT_SESSION_INVALID_OFFSET: {
                    return true;
                }
                case CONCURRENT_SESSION_INVALID_DATA_SIZE: {
                    return true;
                }
                case PAYLOAD_TOO_LARGE: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case CONTENT_HASH_MISMATCH: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UploadSessionAppendError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadSessionAppendError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case INCORRECT_OFFSET: {
                    g.writeStartObject();
                    this.writeTag("incorrect_offset", g);
                    UploadSessionOffsetError.Serializer.INSTANCE.serialize(value.incorrectOffsetValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case CLOSED: {
                    g.writeString("closed");
                    break;
                }
                case NOT_CLOSED: {
                    g.writeString("not_closed");
                    break;
                }
                case TOO_LARGE: {
                    g.writeString("too_large");
                    break;
                }
                case CONCURRENT_SESSION_INVALID_OFFSET: {
                    g.writeString("concurrent_session_invalid_offset");
                    break;
                }
                case CONCURRENT_SESSION_INVALID_DATA_SIZE: {
                    g.writeString("concurrent_session_invalid_data_size");
                    break;
                }
                case PAYLOAD_TOO_LARGE: {
                    g.writeString("payload_too_large");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case CONTENT_HASH_MISMATCH: {
                    g.writeString("content_hash_mismatch");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public UploadSessionAppendError deserialize(JsonParser p) throws IOException, JsonParseException {
            UploadSessionAppendError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("not_found".equals(tag)) {
                value = NOT_FOUND;
            } else if ("incorrect_offset".equals(tag)) {
                UploadSessionOffsetError fieldValue = null;
                fieldValue = UploadSessionOffsetError.Serializer.INSTANCE.deserialize(p, true);
                value = UploadSessionAppendError.incorrectOffset(fieldValue);
            } else if ("closed".equals(tag)) {
                value = CLOSED;
            } else if ("not_closed".equals(tag)) {
                value = NOT_CLOSED;
            } else if ("too_large".equals(tag)) {
                value = TOO_LARGE;
            } else if ("concurrent_session_invalid_offset".equals(tag)) {
                value = CONCURRENT_SESSION_INVALID_OFFSET;
            } else if ("concurrent_session_invalid_data_size".equals(tag)) {
                value = CONCURRENT_SESSION_INVALID_DATA_SIZE;
            } else if ("payload_too_large".equals(tag)) {
                value = PAYLOAD_TOO_LARGE;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("content_hash_mismatch".equals(tag)) {
                value = CONTENT_HASH_MISMATCH;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        NOT_FOUND,
        INCORRECT_OFFSET,
        CLOSED,
        NOT_CLOSED,
        TOO_LARGE,
        CONCURRENT_SESSION_INVALID_OFFSET,
        CONCURRENT_SESSION_INVALID_DATA_SIZE,
        PAYLOAD_TOO_LARGE,
        OTHER,
        CONTENT_HASH_MISMATCH;

    }
}

