/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBColumnTypeMetaData;
import org.duckdb.DuckDBResultSet;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBTimestamp;
import org.duckdb.JsonNode;

class DuckDBVector {
    private static final BigDecimal ULONG_MULTIPLIER = new BigDecimal("18446744073709551616");
    private static final DateTimeFormatter ERA_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH).appendOptional(new DateTimeFormatterBuilder().appendLiteral(" (").appendText((TemporalField)ChronoField.ERA, TextStyle.SHORT).appendLiteral(")").toFormatter()).toFormatter();
    private final DuckDBColumnTypeMetaData meta;
    protected final DuckDBColumnType duckdb_type;
    final int length;
    private final boolean[] nullmask;
    private ByteBuffer constlen_data = null;
    private Object[] varlen_data = null;

    DuckDBVector(String string, int n, boolean[] blArray) {
        this.duckdb_type = DuckDBResultSetMetaData.TypeNameToType(string);
        this.meta = this.duckdb_type == DuckDBColumnType.DECIMAL ? DuckDBColumnTypeMetaData.parseColumnTypeMetadata(string) : null;
        this.length = n;
        this.nullmask = blArray;
    }

    Object getObject(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        switch (this.duckdb_type) {
            case BOOLEAN: {
                return this.getBoolean(n);
            }
            case TINYINT: {
                return this.getByte(n);
            }
            case SMALLINT: {
                return this.getShort(n);
            }
            case INTEGER: {
                return this.getInt(n);
            }
            case BIGINT: {
                return this.getLong(n);
            }
            case HUGEINT: {
                return this.getHugeint(n);
            }
            case UHUGEINT: {
                return this.getUhugeint(n);
            }
            case UTINYINT: {
                return this.getUint8(n);
            }
            case USMALLINT: {
                return this.getUint16(n);
            }
            case UINTEGER: {
                return this.getUint32(n);
            }
            case UBIGINT: {
                return this.getUint64(n);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(n));
            }
            case DOUBLE: {
                return this.getDouble(n);
            }
            case DECIMAL: {
                return this.getBigDecimal(n);
            }
            case TIME: {
                return this.getLocalTime(n);
            }
            case TIME_WITH_TIME_ZONE: {
                return this.getOffsetTime(n);
            }
            case DATE: {
                return this.getLocalDate(n);
            }
            case TIMESTAMP: 
            case TIMESTAMP_NS: 
            case TIMESTAMP_S: 
            case TIMESTAMP_MS: {
                return this.getTimestamp(n);
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return this.getOffsetDateTime(n);
            }
            case JSON: {
                return this.getJsonObject(n);
            }
            case BLOB: {
                return this.getBlob(n);
            }
            case UUID: {
                return this.getUuid(n);
            }
            case MAP: {
                return this.getMap(n);
            }
            case LIST: 
            case ARRAY: {
                return this.getArray(n);
            }
            case STRUCT: {
                return this.getStruct(n);
            }
            case UNION: {
                return this.getUnion(n);
            }
        }
        return this.getLazyString(n);
    }

    LocalTime getLocalTime(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIME)) {
            long l = this.getbuf(n, 8).getLong();
            long l2 = TimeUnit.MICROSECONDS.toNanos(l);
            return LocalTime.ofNanoOfDay(l2);
        }
        String string = this.getLazyString(n);
        return string == null ? null : LocalTime.parse(string);
    }

    LocalDate getLocalDate(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.DATE)) {
            return LocalDate.ofEpochDay(this.getbuf(n, 4).getInt());
        }
        String string = this.getLazyString(n);
        if ("infinity".equals(string)) {
            return LocalDate.MAX;
        }
        if ("-infinity".equals(string)) {
            return LocalDate.MIN;
        }
        return string == null ? null : LocalDate.from(ERA_FORMAT.parse(string));
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.DECIMAL)) {
            switch (this.meta.type_size) {
                case 16: {
                    return new BigDecimal(this.getbuf(n, 2).getShort()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 32: {
                    return new BigDecimal(this.getbuf(n, 4).getInt()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 64: {
                    return new BigDecimal(this.getbuf(n, 8).getLong()).scaleByPowerOfTen(this.meta.scale * -1);
                }
                case 128: {
                    ByteBuffer byteBuffer = this.getbuf(n, 16);
                    long l = byteBuffer.getLong();
                    long l2 = byteBuffer.getLong();
                    return new BigDecimal(l2).multiply(ULONG_MULTIPLIER).add(new BigDecimal(Long.toUnsignedString(l))).scaleByPowerOfTen(this.meta.scale * -1);
                }
            }
        }
        Object object = this.getObject(n);
        return new BigDecimal(object.toString());
    }

    OffsetDateTime getOffsetDateTime(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return DuckDBTimestamp.toOffsetDateTime(this.getbuf(n, 8).getLong());
        }
        Object object = this.getObject(n);
        return OffsetDateTime.parse(object.toString());
    }

    Timestamp getTimestamp(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP) || this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return DuckDBTimestamp.toSqlTimestamp(this.getbuf(n, 8).getLong());
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_MS)) {
            return DuckDBTimestamp.toSqlTimestamp(this.getbuf(n, 8).getLong() * 1000L);
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_NS)) {
            return DuckDBTimestamp.toSqlTimestampNanos(this.getbuf(n, 8).getLong());
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_S)) {
            return DuckDBTimestamp.toSqlTimestamp(this.getbuf(n, 8).getLong() * 1000000L);
        }
        Object object = this.getObject(n);
        return Timestamp.valueOf(object.toString());
    }

    UUID getUuid(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.UUID)) {
            ByteBuffer byteBuffer = this.getbuf(n, 16);
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong() - Long.MAX_VALUE - 1L;
            return new UUID(l2, l);
        }
        Object object = this.getObject(n);
        return UUID.fromString(object.toString());
    }

    String getLazyString(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.varlen_data[n].toString();
    }

    Array getArray(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.LIST) || this.isType(DuckDBColumnType.ARRAY)) {
            return (Array)this.varlen_data[n];
        }
        throw new SQLFeatureNotSupportedException("getArray");
    }

    Map<Object, Object> getMap(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (!this.isType(DuckDBColumnType.MAP)) {
            throw new SQLFeatureNotSupportedException("getMap");
        }
        Object[] objectArray = (Object[])((Array)this.varlen_data[n]).getArray();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object : objectArray) {
            Object[] objectArray2 = ((Struct)object).getAttributes();
            hashMap.put(objectArray2[0], objectArray2[1]);
        }
        return hashMap;
    }

    Blob getBlob(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.BLOB)) {
            return new DuckDBResultSet.DuckDBBlobResult((ByteBuffer)this.varlen_data[n]);
        }
        throw new SQLFeatureNotSupportedException("getBlob");
    }

    JsonNode getJsonObject(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        String string = this.getLazyString(n);
        return string == null ? null : new JsonNode(string);
    }

    Date getDate(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.DATE)) {
            return Date.valueOf(this.getLocalDate(n));
        }
        String string = this.getLazyString(n);
        if (string == null) {
            return null;
        }
        try {
            return Date.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    OffsetTime getOffsetTime(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        return DuckDBTimestamp.toOffsetTime(this.getbuf(n, 8).getLong());
    }

    Time getTime(int n) {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIME)) {
            return Time.valueOf(this.getLocalTime(n));
        }
        String string = this.getLazyString(n);
        try {
            return Time.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    Boolean getBoolean(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return false;
        }
        if (this.isType(DuckDBColumnType.BOOLEAN)) {
            return this.getbuf(n, 1).get() == 1;
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).byteValue() == 1;
        }
        return Boolean.parseBoolean(object.toString());
    }

    protected ByteBuffer getbuf(int n, int n2) {
        ByteBuffer byteBuffer = this.constlen_data;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.position(n * n2);
        return byteBuffer;
    }

    protected boolean check_and_null(int n) {
        return this.nullmask[n];
    }

    long getLong(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0L;
        }
        if (this.isType(DuckDBColumnType.BIGINT) || this.isType(DuckDBColumnType.TIMESTAMP) || this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return this.getbuf(n, 8).getLong();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    int getInt(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.INTEGER)) {
            return this.getbuf(n, 4).getInt();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    short getUint8(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.UTINYINT)) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(2);
            this.getbuf(n, 1).get(byteBuffer.array(), 1, 1);
            return byteBuffer.getShort();
        }
        throw new SQLFeatureNotSupportedException("getUint8");
    }

    long getUint32(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0L;
        }
        if (this.isType(DuckDBColumnType.UINTEGER)) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.getbuf(n, 4).get(byteBuffer.array(), 0, 4);
            return byteBuffer.getLong();
        }
        throw new SQLFeatureNotSupportedException("getUint32");
    }

    int getUint16(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.USMALLINT)) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.getbuf(n, 2).get(byteBuffer.array(), 0, 2);
            return byteBuffer.getInt();
        }
        throw new SQLFeatureNotSupportedException("getUint16");
    }

    BigInteger getUint64(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.UBIGINT)) {
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[8];
            this.getbuf(n, 8).get(byArray2);
            for (int i = 0; i < 8; ++i) {
                byArray[i + 8] = byArray2[7 - i];
            }
            return new BigInteger(byArray);
        }
        throw new SQLFeatureNotSupportedException("getUint64");
    }

    double getDouble(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return Double.NaN;
        }
        if (this.isType(DuckDBColumnType.DOUBLE)) {
            return this.getbuf(n, 8).getDouble();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.parseDouble(object.toString());
    }

    byte getByte(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.TINYINT)) {
            return this.getbuf(n, 1).get();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        return Byte.parseByte(object.toString());
    }

    short getShort(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        if (this.isType(DuckDBColumnType.SMALLINT)) {
            return this.getbuf(n, 2).getShort();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return Short.parseShort(object.toString());
    }

    BigInteger getHugeint(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.HUGEINT)) {
            byte[] byArray = new byte[16];
            this.getbuf(n, 16).get(byArray);
            for (int i = 0; i < 8; ++i) {
                byte by = byArray[i];
                byArray[i] = byArray[15 - i];
                byArray[15 - i] = by;
            }
            return new BigInteger(byArray);
        }
        Object object = this.getObject(n);
        return new BigInteger(object.toString());
    }

    BigInteger getUhugeint(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        if (this.isType(DuckDBColumnType.UHUGEINT)) {
            byte[] byArray = new byte[16];
            this.getbuf(n, 16).get(byArray);
            for (int i = 0; i < 8; ++i) {
                byte by = byArray[i];
                byArray[i] = byArray[15 - i];
                byArray[15 - i] = by;
            }
            return new BigInteger(1, byArray);
        }
        Object object = this.getObject(n);
        return new BigInteger(object.toString());
    }

    float getFloat(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return Float.NaN;
        }
        if (this.isType(DuckDBColumnType.FLOAT)) {
            return this.getbuf(n, 4).getFloat();
        }
        Object object = this.getObject(n);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return Float.parseFloat(object.toString());
    }

    private boolean isType(DuckDBColumnType duckDBColumnType) {
        return this.duckdb_type == duckDBColumnType;
    }

    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP) || this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return DuckDBTimestamp.fromMicroInstant(this.getbuf(n, 8).getLong());
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_MS)) {
            return DuckDBTimestamp.fromMilliInstant(this.getbuf(n, 8).getLong());
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_NS)) {
            return DuckDBTimestamp.fromNanoInstant(this.getbuf(n, 8).getLong());
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP_S)) {
            return DuckDBTimestamp.fromSecondInstant(this.getbuf(n, 8).getLong());
        }
        Object object = this.getObject(n);
        return Timestamp.valueOf(object.toString());
    }

    LocalDateTime getLocalDateTime(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        if (this.isType(DuckDBColumnType.TIMESTAMP) || this.isType(DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE)) {
            return DuckDBTimestamp.toLocalDateTime(this.getbuf(n, 8).getLong());
        }
        Object object = this.getObject(n);
        return LocalDateTime.parse(object.toString());
    }

    Struct getStruct(int n) {
        return this.check_and_null(n) ? null : (Struct)this.varlen_data[n];
    }

    Object getUnion(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        Struct struct = this.getStruct(n);
        Object[] objectArray = struct.getAttributes();
        short s = (Short)objectArray[0];
        return objectArray[1 + s];
    }
}

