/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.beam.runners.core.InMemoryBundleFinalizer;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.DirectMetrics;
import org.apache.beam.runners.direct.PCollectionViewWriter;
import org.apache.beam.runners.direct.SideInputContainer;
import org.apache.beam.runners.direct.StepAndKey;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.runners.direct.WatermarkCallbackExecutor;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.local.StructuralKey;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EvaluationContext {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EvaluationContext.class);
    private final @UnknownKeyFor @NonNull @Initialized DirectGraph graph;
    private final @UnknownKeyFor @NonNull @Initialized Clock clock;
    private final @UnknownKeyFor @NonNull @Initialized BundleFactory bundleFactory;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WatermarkManager<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> watermarkManager;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkCallbackExecutor callbackExecutor;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized StepAndKey, @UnknownKeyFor @NonNull @Initialized CopyOnAccessInMemoryStateInternals> applicationStateInternals;
    private final @UnknownKeyFor @NonNull @Initialized SideInputContainer sideInputContainer;
    private final @UnknownKeyFor @NonNull @Initialized DirectMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> keyedPValues;

    public static @UnknownKeyFor @NonNull @Initialized EvaluationContext create(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized BundleFactory bundleFactory, @UnknownKeyFor @NonNull @Initialized DirectGraph graph, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> keyedPValues, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        return new EvaluationContext(clock, bundleFactory, graph, keyedPValues, executorService);
    }

    private EvaluationContext(@UnknownKeyFor @NonNull @Initialized Clock clock, @UnknownKeyFor @NonNull @Initialized BundleFactory bundleFactory, @UnknownKeyFor @NonNull @Initialized DirectGraph graph, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> keyedPValues, @UnknownKeyFor @NonNull @Initialized ExecutorService executorService) {
        this.clock = clock;
        this.bundleFactory = (BundleFactory)Preconditions.checkNotNull((Object)bundleFactory);
        this.graph = (DirectGraph)Preconditions.checkNotNull((Object)graph);
        this.keyedPValues = keyedPValues;
        this.watermarkManager = WatermarkManager.create(clock, graph, AppliedPTransform::getFullName);
        this.sideInputContainer = SideInputContainer.create(this, graph.getViews());
        this.applicationStateInternals = new ConcurrentHashMap<StepAndKey, CopyOnAccessInMemoryStateInternals>();
        this.metrics = new DirectMetrics(executorService);
        this.callbackExecutor = WatermarkCallbackExecutor.create(MoreExecutors.directExecutor());
    }

    public void initialize(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> initialInputs) {
        this.watermarkManager.initialize(initialInputs);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedResult<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> handleResult(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> completedBundle, @UnknownKeyFor @NonNull @Initialized Iterable< @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> completedTimers, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> result) {
        Iterable<? extends CommittedBundle<?>> committedBundles = this.commitBundles(result.getOutputBundles());
        this.metrics.commitLogical(completedBundle, result.getLogicalMetricUpdates());
        EnumSet<CommittedResult.OutputType> outputTypes = EnumSet.copyOf(result.getOutputTypes());
        if (Iterables.isEmpty(committedBundles)) {
            outputTypes.remove((Object)CommittedResult.OutputType.BUNDLE);
        } else {
            outputTypes.add(CommittedResult.OutputType.BUNDLE);
        }
        CommittedResult<AppliedPTransform<?, ?, ?>> committedResult = CommittedResult.create(result, this.getUnprocessedInput(completedBundle, result), committedBundles, outputTypes);
        CopyOnAccessInMemoryStateInternals theirState = result.getState();
        if (theirState != null) {
            CopyOnAccessInMemoryStateInternals committedState = theirState.commit();
            StepAndKey stepAndKey = StepAndKey.of(result.getTransform(), completedBundle.getKey());
            if (!committedState.isEmpty()) {
                this.applicationStateInternals.put(stepAndKey, committedState);
            } else {
                this.applicationStateInternals.remove(stepAndKey);
            }
        }
        this.watermarkManager.updateWatermarks(completedBundle, result.getTimerUpdate().withCompletedTimers(completedTimers), committedResult.getExecutable(), committedResult.getUnprocessedInputs().orElse(null), committedResult.getOutputs(), result.getWatermarkHold());
        for (InMemoryBundleFinalizer.Finalization finalization : result.getBundleFinalizations()) {
            try {
                finalization.getCallback().onBundleSuccess();
            }
            catch (Exception e) {
                LOG.warn("Failed to finalize {} for completed bundle {}", new Object[]{finalization, completedBundle, e});
            }
        }
        return committedResult;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Optional<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getUnprocessedInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> completedBundle, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> result) {
        if (completedBundle == null || Iterables.isEmpty(result.getUnprocessedElements())) {
            return Optional.empty();
        }
        CommittedBundle<?> residual = completedBundle.withElements(result.getUnprocessedElements());
        return Optional.of(residual);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> commitBundles(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UncommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> bundles) {
        ImmutableList.Builder completed = ImmutableList.builder();
        for (UncommittedBundle<?> inProgress : bundles) {
            AppliedPTransform<?, ?, ?> producing;
            WatermarkManager.TransformWatermarks watermarks;
            CommittedBundle<?> committed = inProgress.commit((watermarks = this.watermarkManager.getWatermarks(producing = this.graph.getProducer(inProgress.getPCollection()))).getSynchronizedProcessingOutputTime());
            if (Iterables.isEmpty(committed.getElements())) continue;
            completed.add(committed);
        }
        return completed.build();
    }

    private void fireAllAvailableCallbacks() {
        for (AppliedPTransform<?, ?, ?> transform : this.graph.getExecutables()) {
            this.fireAvailableCallbacks(transform);
        }
    }

    private void fireAvailableCallbacks(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> producingTransform) {
        WatermarkManager.TransformWatermarks watermarks = this.watermarkManager.getWatermarks(producingTransform);
        Instant outputWatermark = watermarks.getOutputWatermark();
        try {
            this.callbackExecutor.fireForWatermark(producingTransform, outputWatermark);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createRootBundle() {
        return this.bundleFactory.createRootBundle();
    }

    public <T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createBundle(@UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return this.bundleFactory.createBundle(output);
    }

    public <K, T> @UnknownKeyFor @NonNull @Initialized UncommittedBundle<T> createKeyedBundle(@UnknownKeyFor @NonNull @Initialized StructuralKey<K> key, @UnknownKeyFor @NonNull @Initialized PCollection<T> output) {
        return this.bundleFactory.createKeyedBundle(key, output);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean isKeyed(@UnknownKeyFor @NonNull @Initialized PValue pValue) {
        return this.keyedPValues.contains(pValue);
    }

    public <ElemT, ViewT> @UnknownKeyFor @NonNull @Initialized PCollectionViewWriter<ElemT, ViewT> createPCollectionViewWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> input, @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> output) {
        return values -> this.sideInputContainer.write(output, values);
    }

    public void scheduleAfterOutputWouldBeProduced(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> value, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        AppliedPTransform<?, ?, ?> producing = this.graph.getProducer(value);
        this.callbackExecutor.callOnGuaranteedFiring(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(producing);
    }

    public void scheduleAfterOutputWouldBeProduced(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        AppliedPTransform<?, ?, ?> producing = this.graph.getProducer(view);
        this.callbackExecutor.callOnGuaranteedFiring(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(producing);
    }

    public void scheduleAfterWindowExpiration(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> producing, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized Runnable runnable) {
        this.callbackExecutor.callOnWindowExpiration(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(producing);
    }

    public @UnknownKeyFor @NonNull @Initialized DirectExecutionContext getExecutionContext(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StructuralKey<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> key) {
        StepAndKey stepAndKey = StepAndKey.of(application, key);
        return new DirectExecutionContext(this.clock, key, (CopyOnAccessInMemoryStateInternals)this.applicationStateInternals.get(stepAndKey), this.watermarkManager.getWatermarks(application));
    }

    @UnknownKeyFor @NonNull @Initialized String getStepName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
        return this.graph.getStepName(application);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> getSteps() {
        return this.graph.getExecutables();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader createSideInputReader(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs) {
        return this.sideInputContainer.createReaderForViews(sideInputs);
    }

    public @UnknownKeyFor @NonNull @Initialized DirectMetrics getMetrics() {
        return this.metrics;
    }

    @VisibleForTesting
    void forceRefresh() {
        this.watermarkManager.refreshAll();
        this.fireAllAvailableCallbacks();
    }

    @VisibleForTesting
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WatermarkManager.FiredTimers<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> extractFiredTimers() {
        return this.extractFiredTimers(Collections.emptyList());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WatermarkManager.FiredTimers<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> extractFiredTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> ignoredTransforms) {
        this.forceRefresh();
        return this.watermarkManager.extractFiredTimers(ignoredTransforms);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDone(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        Instant stepWatermark = this.watermarkManager.getWatermarks(transform).getOutputWatermark();
        return !stepWatermark.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDone() {
        for (AppliedPTransform<?, ?, ?> transform : this.graph.getExecutables()) {
            if (this.isDone(transform)) continue;
            return false;
        }
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant now() {
        return this.clock.now();
    }

    @UnknownKeyFor @NonNull @Initialized Clock getClock() {
        return this.clock;
    }
}

