/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ClassLoaderFileSystem
extends FileSystem<ClassLoaderResourceId> {
    public static final @UnknownKeyFor @NonNull @Initialized String SCHEMA = "classpath";
    private static final @UnknownKeyFor @NonNull @Initialized String PREFIX = "classpath://";

    ClassLoaderFileSystem() {
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Un-globbable filesystem.");
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceId.path.substring(PREFIX.length()));
        if (inputStream == null) {
            throw new IOException("Unable to load " + resourceId.path + " with " + classLoader + " URL " + classLoader.getResource(resourceId.path.substring(PREFIX.length())));
        }
        return Channels.newChannel(inputStream);
    }

    @Override
    protected void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId> destResourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new UnsupportedOperationException("Read-only filesystem.");
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        return new ClassLoaderResourceId(path);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return SCHEMA;
    }

    @AutoService(value={FileSystemRegistrar.class})
    public static class ClassLoaderFileSystemRegistrar
    implements FileSystemRegistrar {
        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized FileSystem<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> fromOptions(@Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
            return ImmutableList.of((Object)new ClassLoaderFileSystem());
        }
    }

    public static class ClassLoaderResourceId
    implements ResourceId {
        private final @UnknownKeyFor @NonNull @Initialized String path;

        private ClassLoaderResourceId(@UnknownKeyFor @NonNull @Initialized String path) {
            Preconditions.checkArgument((boolean)path.startsWith(ClassLoaderFileSystem.PREFIX), (Object)path);
            this.path = path;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId resolve(@UnknownKeyFor @NonNull @Initialized String other, @UnknownKeyFor @NonNull @Initialized ResolveOptions resolveOptions) {
            if (other.startsWith(ClassLoaderFileSystem.PREFIX)) {
                return new ClassLoaderResourceId(other);
            }
            if (other.startsWith("/")) {
                return new ClassLoaderResourceId("classpath:/" + other);
            }
            return new ClassLoaderResourceId(this.path + "/" + other);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized ClassLoaderResourceId getCurrentDirectory() {
            int ix = this.path.lastIndexOf(47);
            if (ix <= ClassLoaderFileSystem.PREFIX.length()) {
                return new ClassLoaderResourceId(ClassLoaderFileSystem.PREFIX);
            }
            return new ClassLoaderResourceId(this.path.substring(0, ix));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getScheme() {
            return ClassLoaderFileSystem.SCHEMA;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getFilename() {
            return this.path;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
            return false;
        }
    }
}

