/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.cloud.pubsublite.proto.Subscription;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedFactoryImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriber;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryBufferedSubscriberImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.MemoryLimiterImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRangeTracker;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerServerSubscriberCache;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerSubscriptionPartitionSdf;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriberAssembler;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionLoader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.UnboundedSourceImpl;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.util.construction.PTransformMatchers;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeTransform
extends PTransform<PBegin, PCollection<SequencedMessage>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SubscribeTransform.class);
    private static final @UnknownKeyFor @NonNull @Initialized long MEBIBYTE = 0x100000L;
    private static final @UnknownKeyFor @NonNull @Initialized long SOFT_MEMORY_LIMIT = 0x20000000L;
    private static final @UnknownKeyFor @NonNull @Initialized long MIN_PER_PARTITION_MEMORY = 0xA00000L;
    private static final @UnknownKeyFor @NonNull @Initialized long MAX_PER_PARTITION_MEMORY = 0x6400000L;
    private static final @UnknownKeyFor @NonNull @Initialized MemoryLimiter LIMITER = new MemoryLimiterImpl(0xA00000L, 0x6400000L, 0x20000000L);
    private final @UnknownKeyFor @NonNull @Initialized SubscriberOptions options;
    public static final @UnknownKeyFor @NonNull @Initialized PTransformOverride V1_READ_OVERRIDE = PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(SubscribeTransform.class), (PTransformOverrideFactory)new ReadOverrideFactory());

    public SubscribeTransform(@UnknownKeyFor @NonNull @Initialized SubscriberOptions options) {
        this.options = options;
    }

    private void checkSubscription(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        UncheckedApiPreconditions.checkArgument((boolean)subscriptionPartition.subscription().equals(this.options.subscriptionPath()));
    }

    private @UnknownKeyFor @NonNull @Initialized Subscriber newSubscriber(@UnknownKeyFor @NonNull @Initialized Partition partition, @UnknownKeyFor @NonNull @Initialized Offset initialOffset, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SequencedMessage>> consumer) {
        try {
            return new SubscriberAssembler(this.options, partition).getSubscriberFactory(initialOffset).newSubscriber(messages -> consumer.accept(messages.stream().collect(Collectors.toList())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized MemoryBufferedSubscriber newBufferedSubscriber(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @UnknownKeyFor @NonNull @Initialized Offset startOffset) throws @UnknownKeyFor @NonNull @Initialized ApiException {
        this.checkSubscription(subscriptionPartition);
        return new MemoryBufferedSubscriberImpl(subscriptionPartition.partition(), startOffset, LIMITER, consumer -> this.newSubscriber(subscriptionPartition.partition(), startOffset, (Consumer<List<SequencedMessage>>)consumer));
    }

    private @UnknownKeyFor @NonNull @Initialized MemoryBufferedSubscriber getCachedSubscriber(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @UnknownKeyFor @NonNull @Initialized Offset startOffset) {
        Supplier<MemoryBufferedSubscriber> getOrCreate = () -> PerServerSubscriberCache.CACHE.get(subscriptionPartition, () -> this.newBufferedSubscriber(subscriptionPartition, startOffset));
        MemoryBufferedSubscriber subscriber;
        Offset fetchOffset;
        while (!startOffset.equals(fetchOffset = (subscriber = getOrCreate.get()).fetchOffset())) {
            LOG.info("Discarding subscriber due to mismatch, this should be rare. {}, start: {} fetch: {}", new Object[]{subscriptionPartition, startOffset, fetchOffset});
            try {
                subscriber.stopAsync().awaitTerminated();
            }
            catch (Exception exception) {
            }
        }
        return subscriber;
    }

    private @UnknownKeyFor @NonNull @Initialized SubscriptionPartitionProcessor newPartitionProcessor(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetByteRange, @UnknownKeyFor @NonNull @Initialized OffsetByteProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized SequencedMessage> receiver) {
        return new SubscriptionPartitionProcessorImpl(tracker, receiver, this.getCachedSubscriber(subscriptionPartition, Offset.of((long)((OffsetByteRange)tracker.currentRestriction()).getRange().getFrom())));
    }

    private @UnknownKeyFor @NonNull @Initialized TopicBacklogReader newBacklogReader(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getBacklogReader();
    }

    private @UnknownKeyFor @NonNull @Initialized TrackerWithProgress newRestrictionTracker(@UnknownKeyFor @NonNull @Initialized TopicBacklogReader backlogReader, @UnknownKeyFor @NonNull @Initialized OffsetByteRange initial) {
        return new OffsetByteRangeTracker(initial, backlogReader);
    }

    private @UnknownKeyFor @NonNull @Initialized InitialOffsetReader newInitialOffsetReader(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getInitialOffsetReader();
    }

    private @UnknownKeyFor @NonNull @Initialized BlockingCommitter newCommitter(@UnknownKeyFor @NonNull @Initialized SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).newCommitter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @UnknownKeyFor @NonNull @Initialized TopicPath getTopicPath() {
        try (AdminClient admin = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(this.options.subscriptionPath().location().extractRegion()).build());){
            TopicPath topicPath = TopicPath.parse((String)((Subscription)admin.getSubscription(this.options.subscriptionPath()).get()).getTopic());
            return topicPath;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expandSdf(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        PCollection subscriptionPartitions = (PCollection)input.apply((PTransform)new SubscriptionPartitionLoader(this.getTopicPath(), this.options.subscriptionPath()));
        return (PCollection)subscriptionPartitions.apply((PTransform)ParDo.of((DoFn)new PerSubscriptionPartitionSdf(new ManagedFactoryImpl<TopicBacklogReader>(this::newBacklogReader), new ManagedFactoryImpl<BlockingCommitter>(this::newCommitter), (SerializableFunction<SubscriptionPartition, InitialOffsetReader>)((SerializableFunction & Serializable)this::newInitialOffsetReader), (SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress>)((SerializableBiFunction & Serializable)this::newRestrictionTracker), this::newPartitionProcessor)));
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expandSource(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return (PCollection)input.apply((PTransform)Read.from((UnboundedSource)new UnboundedSourceImpl(this.options, this::newBufferedSubscriber, this::newBacklogReader)));
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return this.expandSdf(input);
    }

    private static class ReadOverrideFactory
    implements PTransformOverrideFactory<PBegin, PCollection<SequencedMessage>, SubscribeTransform> {
        private ReadOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage>, @UnknownKeyFor @NonNull @Initialized SubscribeTransform> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), (PTransform)new SourceTransform((SubscribeTransform)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static final class SourceTransform
    extends PTransform<PBegin, PCollection<SequencedMessage>> {
        private final @UnknownKeyFor @NonNull @Initialized SubscribeTransform impl;

        private SourceTransform(@UnknownKeyFor @NonNull @Initialized SubscribeTransform impl) {
            this.impl = impl;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SequencedMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return this.impl.expandSource(input);
        }
    }
}

