/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sort;

import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sort.SortRows;
import org.apache.hop.pipeline.transforms.sort.SortRowsData;
import org.apache.hop.pipeline.transforms.sort.SortRowsField;

@Transform(id="SortRows", image="sortrows.svg", name="i18n::SortRows.Name", description="i18n::SortRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SortRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/sort.html")
public class SortRowsMeta
extends BaseTransformMeta<SortRows, SortRowsData>
implements Serializable {
    private static final long serialVersionUID = -9075883720765645655L;
    private static final Class<?> PKG = SortRowsMeta.class;
    private static final String CONST_SPACE = "      ";
    private static final String CONST_SPACE_LONG = "        ";
    private static final String CONST_FIELD = "field";
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS")
    private List<SortRowsField> sortFields = new ArrayList<SortRowsField>();
    @HopMetadataProperty(key="directory", injectionKey="SORT_DIRECTORY")
    private String directory;
    @HopMetadataProperty(key="sort_prefix", injectionKey="SORT_FILE_PREFIX")
    private String prefix;
    @HopMetadataProperty(key="sort_size", injectionKey="SORT_SIZE_ROWS")
    private String sortSize;
    @HopMetadataProperty(key="free_memory", injectionKey="FREE_MEMORY_TRESHOLD")
    private String freeMemoryLimit;
    @HopMetadataProperty(key="unique_rows", injectionKey="ONLY_PASS_UNIQUE_ROWS")
    private boolean onlyPassingUniqueRows;
    @HopMetadataProperty(key="compress", injectionKey="COMPRESS_TEMP_FILES")
    private boolean compressFiles;
    @HopMetadataProperty(key="compress_variables", injectionKey="COMPRESS_VARIABLE")
    private String compressFilesVariable;
    private List<SortRowsField> groupFields;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<SortRowsField> getSortFields() {
        return this.sortFields;
    }

    public void setSortFields(List<SortRowsField> sortFields) {
        this.sortFields = sortFields;
    }

    public Object clone() {
        SortRowsMeta retval = (SortRowsMeta)super.clone();
        return retval;
    }

    public void setDefault() {
        this.directory = "${java.io.tmpdir}";
        this.prefix = "out";
        this.sortSize = "1000000";
        this.freeMemoryLimit = null;
        this.compressFiles = false;
        this.compressFilesVariable = null;
        this.onlyPassingUniqueRows = false;
        boolean nrFields = false;
    }

    int getDefaultCollationStrength() {
        return this.getDefaultCollationStrength(Locale.getDefault());
    }

    int getDefaultCollationStrength(Locale aLocale) {
        Collator curDefCollator;
        int defaultStrength = 3;
        if (aLocale != null && (curDefCollator = Collator.getInstance(aLocale)) != null) {
            defaultStrength = curDefCollator.getStrength();
        }
        return defaultStrength;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        this.assignSortingCriteria(inputRowMeta);
    }

    public void assignSortingCriteria(IRowMeta inputRowMeta) {
        for (int i = 0; i < this.sortFields.size(); ++i) {
            SortRowsField field = this.sortFields.get(i);
            int idx = inputRowMeta.indexOfValue(field.getFieldName());
            if (idx < 0) continue;
            IValueMeta valueMeta = inputRowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(!field.isAscending());
            valueMeta.setCaseInsensitive(!field.isCaseSensitive());
            valueMeta.setCollatorDisabled(!field.isCollatorEnabled());
            valueMeta.setCollatorStrength(field.getCollatorStrength());
            valueMeta.setStorageType(0);
            valueMeta.setStorageMetadata(null);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.sortFields.size(); ++i) {
                SortRowsField field = this.sortFields.get(i);
                int idx = prev.indexOfValue(field.getFieldName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + field.getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.SortKeysNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (!this.sortFields.isEmpty()) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.AllSortKeysFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoSortKeysEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            String realDirectory = variables.resolve(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExistsButNoDirectory", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.DirectoryNotExists", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortRowsMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getSortSize() {
        return this.sortSize;
    }

    public void setSortSize(String sortSize) {
        this.sortSize = sortSize;
    }

    public boolean isCompressFiles() {
        return this.compressFiles;
    }

    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    public boolean isOnlyPassingUniqueRows() {
        return this.onlyPassingUniqueRows;
    }

    public void setOnlyPassingUniqueRows(boolean onlyPassingUniqueRows) {
        this.onlyPassingUniqueRows = onlyPassingUniqueRows;
    }

    public String getCompressFilesVariable() {
        return this.compressFilesVariable;
    }

    public void setCompressFilesVariable(String compressFilesVariable) {
        this.compressFilesVariable = compressFilesVariable;
    }

    public String getFreeMemoryLimit() {
        return this.freeMemoryLimit;
    }

    public void setFreeMemoryLimit(String freeMemoryLimit) {
        this.freeMemoryLimit = freeMemoryLimit;
    }

    public boolean isGroupSortEnabled() {
        return this.getSortFields() != null;
    }

    public void setGroupFields(List<SortRowsField> groupFields) {
        this.groupFields = groupFields;
    }

    public List<SortRowsField> getGroupFields() {
        if (this.groupFields == null) {
            this.groupFields = new ArrayList<SortRowsField>();
            for (int i = 0; i < this.getSortFields().size(); ++i) {
                if (!this.getSortFields().get(i).isPreSortedField()) continue;
                this.groupFields.add(this.getSortFields().get(i));
            }
        }
        return this.groupFields;
    }
}

