/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;

public class LdapProtocol {
    private static Class<?> classFromResourcesPackage = LdapProtocol.class;
    private static final String CONNECTION_PREFIX = "ldap://";
    public static final String NAME = "LDAP";
    private final String hostname;
    private final int port;
    private final String derefAliases;
    private final String referral;
    private final ILogChannel log;
    private InitialLdapContext ctx;
    private final Set<String> binaryAttributes;

    public InitialLdapContext getCtx() {
        return this.ctx;
    }

    public LdapProtocol(ILogChannel log, IVariables variables, ILdapMeta meta, Collection<String> binaryAttributes) {
        this.log = log;
        this.hostname = variables.resolve(meta.getHost());
        this.port = Const.toInt((String)variables.resolve(meta.getPort()), (int)389);
        this.derefAliases = meta.getDerefAliases();
        this.referral = meta.getReferrals();
        this.binaryAttributes = binaryAttributes == null ? new HashSet<String>() : new HashSet<String>(binaryAttributes);
    }

    protected String getConnectionPrefix() {
        return CONNECTION_PREFIX;
    }

    public static String getName() {
        return NAME;
    }

    protected void setupEnvironment(Map<String, String> env, String username, String password) throws HopException {
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.derefAliases", this.derefAliases);
        env.put("java.naming.referral", this.referral);
        if (this.hostname.startsWith(this.getConnectionPrefix())) {
            env.put("java.naming.provider.url", this.hostname + ":" + this.port);
        } else {
            env.put("java.naming.provider.url", this.getConnectionPrefix() + this.hostname + ":" + this.port);
        }
        if (!Utils.isEmpty((CharSequence)username)) {
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            env.put("java.naming.security.authentication", "simple");
        } else {
            env.put("java.naming.security.authentication", "none");
        }
        if (!this.binaryAttributes.isEmpty()) {
            env.put("java.naming.ldap.attributes.binary", String.join((CharSequence)" ", this.binaryAttributes));
        }
    }

    protected InitialLdapContext createLdapContext(Hashtable<String, String> env) throws NamingException {
        return new InitialLdapContext(env, null);
    }

    protected void doConnect(String username, String password) throws HopException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.setupEnvironment(env, username, password);
        try {
            this.ctx = this.createLdapContext(env);
        }
        catch (NamingException e) {
            throw new HopException((Throwable)e);
        }
    }

    public final void connect(String username, String password) throws HopException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        this.setupEnvironment(env, username, password);
        try {
            this.doConnect(username, password);
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(classFromResourcesPackage, (String)"LdapInput.Log.ConnectedToServer", (String[])new String[]{this.hostname, Const.NVL((String)username, (String)"")}));
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(classFromResourcesPackage, (String)"LdapInput.ClassUsed.Message", (String[])new String[]{this.ctx.getClass().getName()}));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(classFromResourcesPackage, (String)"LDAPinput.Exception.ErrorConnecting", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void close() throws HopException {
        if (this.ctx != null) {
            try {
                this.ctx.close();
                if (this.log.isBasic()) {
                    this.log.logBasic(BaseMessages.getString(classFromResourcesPackage, (String)"LdapInput.log.Disconnection.Done", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.log.logError(BaseMessages.getString(classFromResourcesPackage, (String)"LdapInput.Exception.ErrorDisconecting", (String[])new String[]{e.toString()}));
                this.log.logError(Const.getStackTracker((Throwable)e));
            }
            finally {
                this.ctx = null;
            }
        }
    }
}

