/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AdfsCredentialsProvider
extends SamlCredentialsProvider {
    private static final Pattern SAML_PATTERN = Pattern.compile("SAMLResponse\\W+value=\"([^\"]+)\"");
    private static final String KEY_LOGINTORP = "loginToRp";
    protected String m_loginToRp = "urn:amazon:webservices";

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_LOGINTORP.equalsIgnoreCase(key)) {
            this.m_loginToRp = value;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("m_loginToRp: ", this.m_loginToRp);
            }
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_loginToRp != null ? this.m_loginToRp : "";
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        if (StringUtils.isNullOrEmpty((String)this.m_idpHost)) {
            throw new IOException("Missing required property: idp_host");
        }
        if (StringUtils.isNullOrEmpty((String)this.m_userName) || StringUtils.isNullOrEmpty((String)this.m_password)) {
            return this.windowsIntegratedAuthentication();
        }
        return this.formBasedAuthentication();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String windowsIntegratedAuthentication() {
        String string;
        String osName = System.getProperty("os.name").toLowerCase(Locale.getDefault());
        if (!osName.contains("windows")) {
            throw new SdkClientException("WIA only support Windows platform.");
        }
        InputStream is = null;
        OutputStream os = null;
        File file = null;
        try {
            file = this.extractExecutable();
            String[] cmd = new String[]{file.getAbsolutePath(), "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=" + this.m_loginToRp, String.valueOf(Boolean.getBoolean("adfs.insecure"))};
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Command: {0}:{1}:{2}", cmd[0], cmd[1], cmd[2]);
            }
            this.validateURL(cmd[1]);
            Process process = Runtime.getRuntime().exec(cmd);
            is = process.getInputStream();
            os = process.getOutputStream();
            String samlAssertion = IOUtils.toString((InputStream)is);
            int code = process.waitFor();
            if (code != 0) {
                throw new SdkClientException("Failed execute adfs command, return: " + code);
            }
            string = samlAssertion;
        }
        catch (InterruptedException e) {
            try {
                throw new SdkClientException("Failed execute adfs command.", (Throwable)e);
                catch (IOException e2) {
                    throw new SdkClientException("Failed execute adfs command.", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is, null);
                IOUtils.closeQuietly(os, null);
                if (file != null && !file.delete()) {
                    file.deleteOnExit();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)is, null);
        IOUtils.closeQuietly((Closeable)os, null);
        if (file != null && !file.delete()) {
            file.deleteOnExit();
        }
        return string;
    }

    private String formBasedAuthentication() throws IOException {
        String string;
        String uri = "https://" + this.m_idpHost + ':' + this.m_idpPort + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=" + this.m_loginToRp;
        CloseableHttpClient client = null;
        try {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("uri: {0}", uri);
            }
            this.validateURL(uri);
            client = this.getHttpClient();
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
            if (resp.getStatusLine().getStatusCode() != 200) {
                if (RedshiftLogger.isEnable()) {
                    this.m_log.log(LogLevel.DEBUG, "formBasedAuthentication https response:" + EntityUtils.toString((HttpEntity)resp.getEntity()), new Object[0]);
                }
                throw new IOException("Failed send request: " + resp.getStatusLine().getReasonPhrase());
            }
            String body = EntityUtils.toString((HttpEntity)resp.getEntity());
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("body: {0}", body);
            }
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            for (String inputTag : this.getInputTagsfromHTML(body)) {
                String name = this.getValueByKey(inputTag, "name");
                String value = this.getValueByKey(inputTag, "value");
                String nameLower = name.toLowerCase();
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("name: {0}", name);
                }
                if (nameLower.contains("username")) {
                    parameters.add(new BasicNameValuePair(name, this.m_userName));
                    continue;
                }
                if (nameLower.contains("authmethod")) {
                    if (value.isEmpty()) continue;
                    parameters.add(new BasicNameValuePair(name, value));
                    continue;
                }
                if (nameLower.contains("password")) {
                    parameters.add(new BasicNameValuePair(name, this.m_password));
                    continue;
                }
                if (name.isEmpty()) continue;
                parameters.add(new BasicNameValuePair(name, value));
            }
            String action = this.getFormAction(body);
            if (!StringUtils.isNullOrEmpty((String)action) && action.startsWith("/")) {
                uri = "https://" + this.m_idpHost + ':' + this.m_idpPort + action;
            }
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("action uri: {0}", uri);
            }
            this.validateURL(uri);
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            resp = client.execute((HttpUriRequest)post);
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Failed send request: " + resp.getStatusLine().getReasonPhrase());
            }
            String content = EntityUtils.toString((HttpEntity)resp.getEntity());
            Matcher matcher = SAML_PATTERN.matcher(content);
            if (!matcher.find()) {
                throw new IOException("Failed to login ADFS.");
            }
            string = matcher.group(1);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new SdkClientException("Failed create SSLContext.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(client, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)client, null);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractExecutable() throws IOException {
        File file = File.createTempFile("adfs", ".exe");
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = AdfsCredentialsProvider.class.getResourceAsStream("adfs.exe");
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)is, null);
            IOUtils.closeQuietly(os, null);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is, null);
        IOUtils.closeQuietly((Closeable)os, null);
        return file;
    }
}

