/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google.auto.common.SuperficialValidation;
import autovalue.shaded.com.google.auto.service.AutoService;
import autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import autovalue.shaded.net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;
import com.google.auto.value.processor.AutoValueishProcessor;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.google.auto.value.AutoValue.Builder"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
public class AutoValueBuilderProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement autoValueBuilder = this.processingEnv.getElementUtils().getTypeElement("com.google.auto.value.AutoValue.Builder");
        Set<? extends Element> builderTypes = roundEnv.getElementsAnnotatedWith(autoValueBuilder);
        if (!SuperficialValidation.validateElements(builderTypes)) {
            return false;
        }
        for (Element element : builderTypes) {
            if (!AutoValueishProcessor.hasAnnotationMirror(element, "com.google.auto.value.AutoValue.Builder")) continue;
            this.validate(element, "@AutoValue.Builder can only be applied to a class or interface inside an @AutoValue class");
        }
        return false;
    }

    private void validate(Element annotatedType, String errorMessage) {
        Element container = annotatedType.getEnclosingElement();
        if (!AutoValueishProcessor.hasAnnotationMirror(container, "com.google.auto.value.AutoValue")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, errorMessage, annotatedType);
        }
    }
}

