/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;

public class ResourceReconcileResult {
    private final List<PendingTaskManager> pendingTaskManagersToAllocate;
    private final List<PendingTaskManager> pendingTaskManagersToRelease;
    private final List<TaskManagerInfo> taskManagersToRelease;

    public ResourceReconcileResult(List<PendingTaskManager> pendingTaskManagersToAllocate, List<PendingTaskManager> pendingTaskManagersToRelease, List<TaskManagerInfo> taskManagersToRelease) {
        this.pendingTaskManagersToAllocate = pendingTaskManagersToAllocate;
        this.pendingTaskManagersToRelease = pendingTaskManagersToRelease;
        this.taskManagersToRelease = taskManagersToRelease;
    }

    public List<PendingTaskManager> getPendingTaskManagersToAllocate() {
        return this.pendingTaskManagersToAllocate;
    }

    public List<PendingTaskManager> getPendingTaskManagersToRelease() {
        return this.pendingTaskManagersToRelease;
    }

    public List<TaskManagerInfo> getTaskManagersToRelease() {
        return this.taskManagersToRelease;
    }

    public boolean needReconcile() {
        return this.pendingTaskManagersToRelease.size() > 0 || this.taskManagersToRelease.size() > 0 || this.pendingTaskManagersToAllocate.size() > 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<PendingTaskManager> pendingTaskManagersToAllocate = new ArrayList<PendingTaskManager>();
        private final List<PendingTaskManager> pendingTaskManagersToRelease = new ArrayList<PendingTaskManager>();
        private final List<TaskManagerInfo> taskManagersToRelease = new ArrayList<TaskManagerInfo>();

        public Builder addPendingTaskManagerToAllocate(PendingTaskManager pendingTaskManager) {
            this.pendingTaskManagersToAllocate.add(pendingTaskManager);
            return this;
        }

        public Builder addPendingTaskManagerToRelease(PendingTaskManager pendingTaskManager) {
            this.pendingTaskManagersToRelease.add(pendingTaskManager);
            return this;
        }

        public Builder addTaskManagerToRelease(TaskManagerInfo taskManagerInfo) {
            this.taskManagersToRelease.add(taskManagerInfo);
            return this;
        }

        public ResourceReconcileResult build() {
            return new ResourceReconcileResult(this.pendingTaskManagersToAllocate, this.pendingTaskManagersToRelease, this.taskManagersToRelease);
        }
    }
}

