/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.SoapAddress;
import com.sforce.ws.wsdl.WsdlNode;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import javax.xml.namespace.QName;

public class Port
extends WsdlNode {
    private String name;
    private QName binding;
    private SoapAddress soapAddress;

    public String getName() {
        return this.name;
    }

    public QName getBinding() {
        return this.binding;
    }

    public boolean isSoapBinding() {
        return this.soapAddress != null;
    }

    public SoapAddress getSoapAddress() {
        return this.soapAddress;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        String bn = parser.getAttributeValue(null, "binding");
        if (bn == null) {
            throw new WsdlParseException("Unable to find binding in port " + this.name);
        }
        this.binding = ParserUtil.toQName(bn, parser);
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if (name != null && namespace != null) {
                    this.parse(name, namespace, parser);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("port".equals(name) && "http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
                    return;
                }
            }
            eventType = parser.next();
        }
    }

    private void parse(String name, String namespace, WsdlParser parser) throws WsdlParseException {
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespace) && "address".equals(name)) {
            this.soapAddress = new SoapAddress();
            this.soapAddress.read(parser);
        }
    }
}

