/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400FileRecordDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.TimestampFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

class RecordListData
implements Serializable {
    static final int KEY_EQ = 0;
    static final int KEY_GT = 1;
    static final int KEY_GE = 2;
    static final int KEY_LT = 3;
    static final int KEY_LE = 4;
    private AS400 system_ = null;
    private String fileName_ = null;
    private boolean newKeyed_ = false;
    private boolean keyed_ = false;
    private int searchType_ = 0;
    private int newSearchType_ = 0;
    private Object[] key_ = null;
    private Object[] newKey_ = null;
    private transient SequentialFile sequentialFile_ = null;
    private transient KeyedFile keyedFile_ = null;
    private transient boolean loadDone_ = false;
    private transient boolean resourceOpen_ = false;
    private transient Object[][] data_ = null;
    transient Record record_;
    private transient int numColumns_ = 0;
    transient FieldDescription[] fields_ = null;
    private static int ROW_INCREMENT_ = 100;
    private transient int numRows_ = 0;
    private transient int lastRecordRead_ = -1;
    private transient int lastLESSRecordNumber_;
    private transient boolean allRecordsRead_ = true;
    private transient boolean error_;
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private boolean fireWorkingEvents_ = true;

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public synchronized void close() {
        if (this.resourceOpen_) {
            try {
                if (this.keyed_) {
                    this.keyedFile_.close();
                } else {
                    this.sequentialFile_.close();
                }
            }
            catch (Exception e) {
                this.errorListeners_.fireError(e);
            }
            this.resourceOpen_ = false;
        }
    }

    public synchronized boolean getAllRecordsProcessed() {
        return this.allRecordsRead_;
    }

    public synchronized int getColumnDisplaySize(int index) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        FieldDescription field = this.fields_[index];
        if (field instanceof FloatFieldDescription || field instanceof PackedDecimalFieldDescription || field instanceof ZonedDecimalFieldDescription) {
            return field.getLength() + 2;
        }
        if (field instanceof TimeFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(1);
        }
        if (field instanceof DateFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(3);
        }
        if (field instanceof TimestampFieldDescription) {
            return DBDateCellRenderer.getDisplaySize(2);
        }
        if (field instanceof HexFieldDescription) {
            return field.getLength() * 2;
        }
        return field.getLength();
    }

    public synchronized String getColumnLabel(int index) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        return this.fields_[index].getFieldName();
    }

    public synchronized String getColumnName(int index) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("index");
        }
        return this.fields_[index].getFieldName();
    }

    public String getFileName() {
        return this.fileName_;
    }

    public Object[] getKey() {
        return this.newKey_;
    }

    public boolean getKeyed() {
        return this.newKeyed_;
    }

    public synchronized int getLastRecordProcessed() {
        return this.lastRecordRead_;
    }

    public synchronized int getNumberOfColumns() {
        return this.numColumns_;
    }

    public synchronized int getNumberOfRows() {
        if (!this.allRecordsRead_) {
            this.readAllRecords();
        }
        return this.numRows_;
    }

    public int getSearchType() {
        return this.newSearchType_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.loadDone_) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        if (this.lastRecordRead_ < rowIndex) {
            this.readMoreRecords(rowIndex - this.lastRecordRead_);
        }
        if (this.lastRecordRead_ < rowIndex) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        return this.data_[rowIndex][columnIndex];
    }

    public synchronized void load() {
        block30: {
            RecordFormat[] format;
            Trace.log(1, "Doing data load.");
            if (this.system_ == null || this.fileName_ == null) {
                Trace.log(1, "Data not set for load, exiting.");
                return;
            }
            if (this.fireWorkingEvents_) {
                this.workingListeners_.fireStartWorking();
            }
            if (this.resourceOpen_) {
                this.close();
            }
            this.fields_ = null;
            this.numColumns_ = 0;
            this.lastRecordRead_ = -1;
            this.allRecordsRead_ = true;
            this.loadDone_ = false;
            this.data_ = null;
            this.numRows_ = 0;
            this.key_ = this.newKey_;
            this.searchType_ = this.newSearchType_;
            this.keyed_ = this.newKeyed_;
            try {
                AS400FileRecordDescription recordDesc = new AS400FileRecordDescription(this.system_, this.fileName_);
                format = recordDesc.retrieveRecordFormat();
            }
            catch (Exception e) {
                this.errorListeners_.fireError(e);
                return;
            }
            this.fields_ = format[0].getFieldDescriptions();
            this.numColumns_ = this.fields_.length;
            if (!this.keyed_) {
                this.keyedFile_ = null;
                try {
                    this.sequentialFile_ = new SequentialFile(this.system_, this.fileName_);
                }
                catch (Exception e) {
                    this.fields_ = null;
                    this.numColumns_ = 0;
                    this.errorListeners_.fireError(e);
                    return;
                }
                try {
                    this.sequentialFile_.setRecordFormat(format[0]);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                try {
                    this.sequentialFile_.open(0, ROW_INCREMENT_, 3);
                    this.record_ = this.sequentialFile_.readNext();
                    this.resourceOpen_ = true;
                }
                catch (Exception e) {
                    try {
                        this.sequentialFile_.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.fields_ = null;
                    this.numColumns_ = 0;
                    this.errorListeners_.fireError(e);
                    return;
                }
            }
            this.sequentialFile_ = null;
            try {
                this.keyedFile_ = new KeyedFile(this.system_, this.fileName_);
            }
            catch (Exception e) {
                this.fields_ = null;
                this.numColumns_ = 0;
                this.errorListeners_.fireError(e);
                return;
            }
            try {
                this.keyedFile_.setRecordFormat(format[0]);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            try {
                this.keyedFile_.open(0, ROW_INCREMENT_, 3);
                this.resourceOpen_ = true;
                if (this.key_ != null) {
                    this.record_ = this.keyedFile_.read(this.key_, this.searchType_);
                    if (this.searchType_ == 4) {
                        try {
                            Record next = this.keyedFile_.readNextEqual(this.key_);
                            while (next != null) {
                                this.record_ = next;
                                next = this.keyedFile_.readNextEqual(this.key_);
                            }
                        }
                        catch (Exception e) {
                            this.errorListeners_.fireError(e);
                        }
                    }
                    if (this.searchType_ == 4 || this.searchType_ == 3) {
                        this.lastLESSRecordNumber_ = this.record_.getRecordNumber();
                        this.record_ = this.keyedFile_.readFirst();
                    }
                    break block30;
                }
                this.record_ = this.keyedFile_.readNext();
            }
            catch (Exception e) {
                try {
                    this.keyedFile_.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fields_ = null;
                this.numColumns_ = 0;
                this.errorListeners_.fireError(e);
                return;
            }
        }
        if (this.record_ != null) {
            this.data_ = new Object[ROW_INCREMENT_][this.numColumns_];
            this.allRecordsRead_ = false;
        }
        this.loadDone_ = true;
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    public synchronized void readAllRecords() {
        Trace.log(1, "Reading all rows.");
        this.workingListeners_.fireStartWorking();
        this.error_ = false;
        while (!this.allRecordsRead_ && !this.error_) {
            this.fireWorkingEvents_ = false;
            this.readMoreRecords(ROW_INCREMENT_);
            this.fireWorkingEvents_ = true;
        }
        this.workingListeners_.fireStopWorking();
    }

    public synchronized void readMoreRecords(int numberToRead) {
        Trace.log(1, "Reading more rows:", numberToRead);
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        this.error_ = false;
        if (!this.allRecordsRead_) {
            if (this.lastRecordRead_ + numberToRead >= this.data_.length) {
                int sizeNeeded = this.lastRecordRead_ + numberToRead + 1;
                int increment = ROW_INCREMENT_ > sizeNeeded ? ROW_INCREMENT_ : sizeNeeded;
                Object[][] newData = new Object[this.data_.length + increment][this.numColumns_];
                System.arraycopy(this.data_, 0, newData, 0, this.data_.length);
                this.data_ = newData;
            }
            for (int i = 0; i < numberToRead; ++i) {
                for (int j = 0; j < this.numColumns_; ++j) {
                    try {
                        this.data_[this.lastRecordRead_ + 1][j] = this.record_.getField(j);
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        this.data_[this.lastRecordRead_ + 1][j] = null;
                        this.errorListeners_.fireError(e);
                    }
                }
                ++this.lastRecordRead_;
                if (!this.keyed_) {
                    try {
                        this.record_ = this.sequentialFile_.readNext();
                    }
                    catch (Exception e) {
                        this.errorListeners_.fireError(e);
                        this.error_ = true;
                        this.record_ = null;
                    }
                } else {
                    try {
                        this.record_ = this.key_ != null ? (this.searchType_ == 0 ? this.keyedFile_.readNextEqual(this.key_) : ((this.searchType_ == 3 || this.searchType_ == 4) && this.lastLESSRecordNumber_ == this.record_.getRecordNumber() ? null : this.keyedFile_.readNext())) : this.keyedFile_.readNext();
                    }
                    catch (Exception e) {
                        this.errorListeners_.fireError(e);
                        this.error_ = true;
                        this.record_ = null;
                    }
                }
                if (this.record_ != null) continue;
                this.allRecordsRead_ = true;
                this.close();
                this.numRows_ = this.lastRecordRead_ + 1;
                break;
            }
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.data_ = null;
        this.sequentialFile_ = null;
        this.keyedFile_ = null;
        this.loadDone_ = false;
        this.resourceOpen_ = false;
        this.numColumns_ = 0;
        this.fields_ = null;
        this.numRows_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setFileName(String fileName) {
        this.fileName_ = fileName;
    }

    public void setKey(Object[] key) {
        this.newKey_ = key;
    }

    public void setKeyed(boolean keyed) {
        this.newKeyed_ = keyed;
    }

    public void setSearchType(int searchType) {
        this.newSearchType_ = searchType;
    }

    public void setSystem(AS400 system) {
        this.system_ = system;
    }
}

