/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.i18n;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.i18n.AbstractMessageHandler;
import org.apache.hop.i18n.GlobalMessageUtil;
import org.apache.hop.i18n.IMessageHandler;

public class GlobalMessages
extends AbstractMessageHandler {
    protected static Class<?> PKG = GlobalMessages.class;
    protected static final String SYSTEM_BUNDLE_PACKAGE = PKG.getPackage().getName();
    protected static final String BUNDLE_NAME = "messages.messages";
    protected static final Map<String, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());
    protected static final ILogChannel log = new LogChannel("i18n");
    public static final String[] localeCodes = new String[]{"en_US", "nl_NL", "zh_CN", "es_ES", "fr_FR", "de_DE", "pt_BR", "pt_PT", "es_AR", "no_NO", "it_IT", "ja_JP", "ko_KR", "pl_PL"};
    public static final String[] localeDescr = new String[]{"English (US)", "Nederlands (Beta)", "\u7b80\u4f53\u4e2d\u6587 (Simplified Chinese)", "Espa\u00f1ol (Spain) (Beta)", "Fran\u00e7ais", "Deutsch (Beta)", "Portuguese (Brazil) (Beta)", "Portuguese (Portugal) (Beta)", "Espa\u00f1ol (Argentina) (Beta)", "Norwegian (Norway) (Beta)", "Italian (Italy)", "Japanese (Japan) (Beta)", "Korean (Korea) (Beta)", "Polski (Beta)"};
    public static final String[] localeBetaStatus = new String[]{"N", "Y", "N", "Y", "N", "Y", "Y", "Y", "Y", "Y", "N", "Y", "Y", "Y"};
    protected static GlobalMessages GMinstance = null;

    public static synchronized IMessageHandler getInstance() {
        if (GMinstance == null) {
            GMinstance = new GlobalMessages();
        }
        return GMinstance;
    }

    protected static Map<String, ResourceBundle> getLocales() {
        return locales;
    }

    protected static String buildBundleName(String packageName) {
        return packageName + ".messages.messages";
    }

    public static ResourceBundle getBundle(String packageName) throws MissingResourceException {
        return GlobalMessageUtil.getBundle(packageName, PKG);
    }

    protected String calculateString(String packageName, String key, Object[] parameters) {
        return this.calculateString(packageName, key, parameters, PKG);
    }

    protected String calculateString(String packageName, String key, Object[] parameters, Class<?> resourceClass) {
        String[] pkgNames = new String[]{packageName, SYSTEM_BUNDLE_PACKAGE};
        return this.calculateString(pkgNames, key, parameters, resourceClass);
    }

    protected String calculateString(String[] pkgNames, String key, Object[] parameters, Class<?> resourceClass) {
        return GlobalMessageUtil.calculateString(pkgNames, key, parameters, resourceClass, BUNDLE_NAME);
    }

    @VisibleForTesting
    static ResourceBundle getBundle(Locale locale, String packagePath) throws MissingResourceException {
        return GlobalMessageUtil.getBundle(locale, packagePath, PKG);
    }

    @Override
    public String getString(String key) {
        Object[] parameters = null;
        return this.calculateString(SYSTEM_BUNDLE_PACKAGE, key, parameters);
    }

    @Override
    public String getString(String packageName, String key) {
        Object[] parameters = new Object[]{};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String ... parameters) {
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, Class<?> resourceClass, String ... parameters) {
        return this.calculateString(packageName, key, (Object[])parameters, resourceClass);
    }
}

