/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.AutoValue_PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
@AutoValue
abstract class PubsubMessageToRow
extends PTransform<PCollection<PubsubMessage>, PCollectionTuple>
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized String TIMESTAMP_FIELD = "event_timestamp";
    static final @UnknownKeyFor @NonNull @Initialized String ATTRIBUTES_FIELD = "attributes";
    static final @UnknownKeyFor @NonNull @Initialized String PAYLOAD_FIELD = "payload";
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> DLQ_TAG = new TupleTag<PubsubMessage>(){};
    static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> MAIN_TAG = new TupleTag<Row>(){};

    PubsubMessageToRow() {
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Schema messageSchema();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean useDlq();

    public abstract @UnknownKeyFor @NonNull @Initialized boolean useFlatSchema();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializerProvider serializerProvider();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_PubsubMessageToRow.Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized PubsubMessage> input) {
        PCollectionTuple rows = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)(this.useFlatSchema() ? new FlatSchemaPubsubMessageToRow(this.messageSchema(), this.useDlq(), this.serializerProvider()) : new NestedSchemaPubsubMessageToRow(this.messageSchema(), this.useDlq(), this.serializerProvider()))).withOutputTags(MAIN_TAG, this.useDlq() ? TupleTagList.of(DLQ_TAG) : TupleTagList.empty()));
        rows.get(MAIN_TAG).setRowSchema(this.messageSchema());
        return rows;
    }

    public static class ParseException
    extends RuntimeException {
        ParseException(@UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super("Error parsing message", cause);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder messageSchema(@UnknownKeyFor @NonNull @Initialized Schema var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder useDlq(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder useFlatSchema(@UnknownKeyFor @NonNull @Initialized boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder serializerProvider(@UnknownKeyFor @NonNull @Initialized SerializerProvider var1);

        public abstract @UnknownKeyFor @NonNull @Initialized PubsubMessageToRow build();
    }

    @Internal
    private static class NestedSchemaPubsubMessageToRow
    extends DoFn<PubsubMessage, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema messageSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean useDlq;
        @Nullable
        private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized PayloadSerializer payloadSerializer;

        private NestedSchemaPubsubMessageToRow(@UnknownKeyFor @NonNull @Initialized Schema messageSchema, @UnknownKeyFor @NonNull @Initialized boolean useDlq, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SerializerProvider serializerProvider) {
            this.messageSchema = messageSchema;
            this.useDlq = useDlq;
            if (serializerProvider == null) {
                Preconditions.checkArgument((boolean)messageSchema.getField(PubsubMessageToRow.PAYLOAD_FIELD).getType().getTypeName().equals((Object)Schema.TypeName.BYTES));
                this.payloadSerializer = null;
            } else {
                Preconditions.checkArgument((boolean)messageSchema.getField(PubsubMessageToRow.PAYLOAD_FIELD).getType().getTypeName().equals((Object)Schema.TypeName.ROW));
                Schema payloadSchema = messageSchema.getField(PubsubMessageToRow.PAYLOAD_FIELD).getType().getRowSchema();
                this.payloadSerializer = (PayloadSerializer)serializerProvider.apply(payloadSchema);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Object maybeDeserialize(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload) {
            if (this.payloadSerializer == null) {
                return payload;
            }
            return this.payloadSerializer.deserialize(payload);
        }

        private @UnknownKeyFor @NonNull @Initialized Object handleAttributes(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributeMap) {
            if (this.messageSchema.getField(PubsubMessageToRow.ATTRIBUTES_FIELD).getType().getTypeName().isMapType()) {
                return attributeMap;
            }
            ImmutableList.Builder rows = ImmutableList.builder();
            attributeMap.forEach((k, v) -> rows.add((Object)Row.withSchema((Schema)PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_ENTRY_SCHEMA).attachValues(new Object[]{k, v})));
            return rows.build();
        }

        private @UnknownKeyFor @NonNull @Initialized Object getValueForFieldNestedSchema(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> attributeMap, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] payload) {
            switch (field.getName()) {
                case "event_timestamp": {
                    return timestamp;
                }
                case "attributes": {
                    return this.handleAttributes(attributeMap);
                }
                case "payload": {
                    return this.maybeDeserialize(payload);
                }
            }
            throw new IllegalArgumentException("Unexpected field '" + field.getName() + "' in top level schema for Pubsub message. Top level schema should only contain 'timestamp', 'attributes', and 'payload' fields");
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PubsubMessage element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver o) {
            try {
                List values = this.messageSchema.getFields().stream().map(field -> this.getValueForFieldNestedSchema((Schema.Field)field, timestamp, element.getAttributeMap(), element.getPayload())).collect(Collectors.toList());
                o.get(MAIN_TAG).output((Object)Row.withSchema((Schema)this.messageSchema).addValues(values).build());
            }
            catch (Exception e) {
                if (this.useDlq) {
                    o.get(DLQ_TAG).output((Object)element);
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Internal
    private static class FlatSchemaPubsubMessageToRow
    extends DoFn<PubsubMessage, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema messageSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean useDlq;
        private final @UnknownKeyFor @NonNull @Initialized PayloadSerializer payloadSerializer;

        protected FlatSchemaPubsubMessageToRow(@UnknownKeyFor @NonNull @Initialized Schema messageSchema, @UnknownKeyFor @NonNull @Initialized boolean useDlq, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializerProvider) {
            this.messageSchema = messageSchema;
            Schema payloadSchema = new Schema(messageSchema.getFields().stream().filter(f -> !f.getName().equals(PubsubMessageToRow.TIMESTAMP_FIELD)).collect(Collectors.toList()));
            this.useDlq = useDlq;
            this.payloadSerializer = (PayloadSerializer)serializerProvider.apply(payloadSchema);
        }

        private @UnknownKeyFor @NonNull @Initialized Object getValueForFieldFlatSchema(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Row payload) {
            String fieldName = field.getName();
            if (PubsubMessageToRow.TIMESTAMP_FIELD.equals(fieldName)) {
                return timestamp;
            }
            return payload.getValue(fieldName);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PubsubMessage element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver o) {
            try {
                Row payload = this.payloadSerializer.deserialize(element.getPayload());
                List values = this.messageSchema.getFields().stream().map(field -> this.getValueForFieldFlatSchema((Schema.Field)field, timestamp, payload)).collect(Collectors.toList());
                o.get(MAIN_TAG).output((Object)Row.withSchema((Schema)this.messageSchema).addValues(values).build());
            }
            catch (Exception e) {
                if (this.useDlq) {
                    o.get(DLQ_TAG).output((Object)element);
                }
                throw new RuntimeException(e);
            }
        }
    }

    static interface SerializerProvider
    extends SerializableFunction<Schema, PayloadSerializer> {
    }
}

