/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@Internal
public class RestOptions {
    private static final String REST_PORT_KEY = "rest.port";
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> BIND_ADDRESS = ConfigOptions.key("rest.bind-address").stringType().noDefaultValue().withFallbackKeys(WebOptions.ADDRESS.key()).withDeprecatedKeys(ConfigConstants.DEFAULT_JOB_MANAGER_WEB_FRONTEND_ADDRESS.key()).withDescription("The address that the server binds itself.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> BIND_PORT = ConfigOptions.key("rest.bind-port").stringType().defaultValue("8081").withFallbackKeys("rest.port").withDeprecatedKeys(WebOptions.PORT.key(), "jobmanager.web.port").withDescription("The port that the server binds itself. Accepts a list of ports (\u201c50100,50101\u201d), ranges (\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple Rest servers are running on the same machine.");
    public static final ConfigOption<String> URL_PREFIX = ConfigOptions.key("rest.url-prefix").stringType().defaultValue("/").withDescription("The url prefix that should be used by clients to construct the full target url, must start and end with '/'. This will be added between the address and version prefix. For example, if the option is set to '/foo/', the overview query URL will be transformed to 'localhost:8081/foo/v1/overview'. Attention: This option is respected only if the high-availability configuration is NONE.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("rest.address").stringType().noDefaultValue().withFallbackKeys(JobManagerOptions.ADDRESS.key()).withDescription("The address that should be used by clients to connect to the server. Attention: This option is respected only if the high-availability configuration is NONE.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<String> PATH = ConfigOptions.key("rest.path").stringType().defaultValue("").withDescription("The path that should be used by clients to interact to the server which is accessible via URL.");
    @Documentation.Section(value={"common_host_port"})
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("rest.port").intType().defaultValue(8081).withDeprecatedKeys(WebOptions.PORT.key()).withDescription(Description.builder().text("The port that the client connects to. If %s has not been specified, then the REST server will bind to this port. Attention: This option is respected only if the high-availability configuration is NONE.", TextElement.text(BIND_PORT.key())).build());
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Long> AWAIT_LEADER_TIMEOUT = ConfigOptions.key("rest.await-leader-timeout").longType().defaultValue(30000L).withDescription("The time in ms that the client waits for the leader address, e.g., Dispatcher or WebMonitorEndpoint");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> RETRY_MAX_ATTEMPTS = ConfigOptions.key("rest.retry.max-attempts").intType().defaultValue(20).withDescription("The number of retries the client will attempt if a retryable operations fails.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Long> RETRY_DELAY = ConfigOptions.key("rest.retry.delay").longType().defaultValue(3000L).withDescription(String.format("The time in ms that the client waits between retries (See also `%s`).", RETRY_MAX_ATTEMPTS.key()));
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Long> CONNECTION_TIMEOUT = ConfigOptions.key("rest.connection-timeout").longType().defaultValue(15000L).withDescription("The maximum time in ms for the client to establish a TCP connection.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Long> IDLENESS_TIMEOUT = ConfigOptions.key("rest.idleness-timeout").longType().defaultValue(300000L).withDescription("The maximum time in ms for a connection to stay idle before failing.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> SERVER_MAX_CONTENT_LENGTH = ConfigOptions.key("rest.server.max-content-length").intType().defaultValue(0x6400000).withDescription("The maximum content length in bytes that the server will handle.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> CLIENT_MAX_CONTENT_LENGTH = ConfigOptions.key("rest.client.max-content-length").intType().defaultValue(0x6400000).withDescription("The maximum content length in bytes that the client will handle.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> SERVER_NUM_THREADS = ConfigOptions.key("rest.server.numThreads").intType().defaultValue(4).withDescription("The number of threads for the asynchronous processing of requests.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> SERVER_THREAD_PRIORITY = ConfigOptions.key("rest.server.thread-priority").intType().defaultValue(5).withDescription("Thread priority of the REST server's executor for processing asynchronous requests. Lowering the thread priority will give Flink's main components more CPU time whereas increasing will allocate more time for the REST server's processing.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> CACHE_CHECKPOINT_STATISTICS_TIMEOUT = ConfigOptions.key("rest.cache.checkpoint-statistics.timeout").durationType().defaultValue(Duration.ofMillis(WebOptions.REFRESH_INTERVAL.defaultValue())).withFallbackKeys(WebOptions.REFRESH_INTERVAL.key()).withDescription(Description.builder().text("Duration from write after which cached checkpoints statistics are cleaned up. For backwards compatibility, if no value is configured, %s will be used instead.", TextElement.code(WebOptions.REFRESH_INTERVAL.key())).build());
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> CACHE_CHECKPOINT_STATISTICS_SIZE = ConfigOptions.key("rest.cache.checkpoint-statistics.size").intType().defaultValue(1000).withDescription("Maximum number of entries in the checkpoint statistics cache.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Boolean> ENABLE_FLAMEGRAPH = ConfigOptions.key("rest.flamegraph.enabled").booleanType().defaultValue(false).withDescription("Enables the experimental flame graph feature.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> FLAMEGRAPH_CLEANUP_INTERVAL = ConfigOptions.key("rest.flamegraph.cleanup-interval").durationType().defaultValue(Duration.ofMinutes(10L)).withDescription("Time after which cached stats are cleaned up if not accessed. It can be specified using notation: \"100 s\", \"10 m\".");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> FLAMEGRAPH_REFRESH_INTERVAL = ConfigOptions.key("rest.flamegraph.refresh-interval").durationType().defaultValue(Duration.ofSeconds(60L)).withDescription("Time after which available stats are deprecated and need to be refreshed (by resampling).  It can be specified using notation: \"30 s\", \"1 m\".");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> FLAMEGRAPH_NUM_SAMPLES = ConfigOptions.key("rest.flamegraph.num-samples").intType().defaultValue(100).withDescription("Number of samples to take to build a FlameGraph.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> FLAMEGRAPH_DELAY = ConfigOptions.key("rest.flamegraph.delay-between-samples").durationType().defaultValue(Duration.ofMillis(50L)).withDescription("Delay between individual stack trace samples taken for building a FlameGraph. It can be specified using notation: \"100 ms\", \"1 s\".");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> FLAMEGRAPH_STACK_TRACE_DEPTH = ConfigOptions.key("rest.flamegraph.stack-depth").intType().defaultValue(100).withDescription("Maximum depth of stack traces used to create FlameGraphs.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> ASYNC_OPERATION_STORE_DURATION = ConfigOptions.key("rest.async.store-duration").durationType().defaultValue(Duration.ofMinutes(5L)).withDescription("Maximum duration that the result of an async operation is stored. Once elapsed the result of the operation can no longer be retrieved.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Boolean> ENABLE_PROFILER = ConfigOptions.key("rest.profiling.enabled").booleanType().defaultValue(false).withDescription("Enables the experimental profiler feature.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Integer> MAX_PROFILING_HISTORY_SIZE = ConfigOptions.key("rest.profiling.history-size").intType().defaultValue(10).withDescription("Maximum profiling history instance to be maintained for JobManager or each TaskManager. The oldest instance will be removed on a rolling basis when the history size exceeds this value.");
    @Documentation.Section(value={"expert_rest"})
    public static final ConfigOption<Duration> MAX_PROFILING_DURATION = ConfigOptions.key("rest.profiling.duration-max").durationType().defaultValue(Duration.ofSeconds(300L)).withDescription("Maximum profiling duration for each profiling request. Any profiling request's duration exceeding this value will not be accepted.");
    @Documentation.Section(value={"expert_rest"})
    @Documentation.OverrideDefault(value="System.getProperty(\"java.io.tmpdir\")")
    public static final ConfigOption<String> PROFILING_RESULT_DIR = ConfigOptions.key("rest.profiling.dir").stringType().defaultValue(System.getProperty("java.io.tmpdir")).withDescription("Profiling result storing directory.");
}

