/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kafka.KafkaCheckpointMark;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaRecordCoder;
import org.apache.beam.sdk.io.kafka.KafkaUnboundedReader;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaUnboundedSource<@UnknownKeyFor K, @UnknownKeyFor V>
extends UnboundedSource<KafkaRecord<K, V>, KafkaCheckpointMark> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KafkaUnboundedSource.class);
    private final  @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<K, V> spec;
    private final @UnknownKeyFor @NonNull @Initialized int id;

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KafkaUnboundedSource<K, V>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int i;
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>((Collection)Preconditions.checkStateNotNull(this.spec.getTopicPartitions()));
        String bootStrapServers = (String)Preconditions.checkArgumentNotNull((Object)this.spec.getConsumerConfig().get("bootstrap.servers"));
        if (partitions.isEmpty()) {
            try (Consumer consumer = (Consumer)this.spec.getConsumerFactoryFn().apply(this.spec.getConsumerConfig());){
                List topics = (List)Preconditions.checkStateNotNull(this.spec.getTopics());
                if (topics.isEmpty()) {
                    Pattern pattern = (Pattern)Preconditions.checkStateNotNull((Object)this.spec.getTopicPattern());
                    for (Map.Entry entry : consumer.listTopics().entrySet()) {
                        if (!pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
                        for (PartitionInfo p : (List)entry.getValue()) {
                            partitions.add(new TopicPartition(p.topic(), p.partition()));
                            Lineage.getSources().add("kafka", (Iterable)ImmutableList.of((Object)bootStrapServers, (Object)p.topic()));
                        }
                    }
                }
                for (String topic : topics) {
                    List partitionInfoList = consumer.partitionsFor(topic);
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((partitionInfoList != null ? 1 : 0) != 0, (Object)"Could not find any partitions info. Please check Kafka configuration and make sure that provided topics exist.");
                    for (PartitionInfo p : partitionInfoList) {
                        partitions.add(new TopicPartition(p.topic(), p.partition()));
                    }
                    Lineage.getSources().add("kafka", (Iterable)ImmutableList.of((Object)bootStrapServers, (Object)topic));
                }
            }
        } else {
            for (TopicPartition p : partitions) {
                Lineage.getSources().add("kafka", (Iterable)ImmutableList.of((Object)bootStrapServers, (Object)p.topic()));
            }
        }
        partitions.sort(Comparator.comparing(TopicPartition::topic).thenComparingInt(TopicPartition::partition));
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((desiredNumSplits > 0 ? 1 : 0) != 0);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((partitions.size() > 0 ? 1 : 0) != 0, (Object)"Could not find any partitions. Please check Kafka configuration and topic names");
        int numSplits = Math.min(desiredNumSplits, partitions.size());
        while (partitions.size() % numSplits > 0) {
            ++numSplits;
        }
        ArrayList assignments = new ArrayList(numSplits);
        for (i = 0; i < numSplits; ++i) {
            assignments.add(new ArrayList());
        }
        for (i = 0; i < partitions.size(); ++i) {
            ((List)assignments.get(i % numSplits)).add((TopicPartition)partitions.get(i));
        }
        ArrayList<KafkaUnboundedSource<K, V>> result = new ArrayList<KafkaUnboundedSource<K, V>>(numSplits);
        for (int i2 = 0; i2 < numSplits; ++i2) {
            List assignedToSplit = (List)assignments.get(i2);
            LOG.info("Partitions assigned to split {} (total {}): {}", new Object[]{i2, assignedToSplit.size(), Joiner.on((String)",").join((Iterable)assignedToSplit)});
            result.add(new KafkaUnboundedSource<K, V>(this.spec.toBuilder().setTopics(Collections.emptyList()).setTopicPartitions(assignedToSplit).build(), i2));
        }
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized KafkaUnboundedReader<K, V> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized KafkaCheckpointMark checkpointMark) {
        Preconditions.checkStateNotNull(this.spec.getTopicPartitions());
        if (this.spec.getTopicPartitions().isEmpty()) {
            LOG.warn("Looks like generateSplits() is not called. Generate single split.");
            try {
                return new KafkaUnboundedReader<K, V>(this.split(1, options).get(0), checkpointMark);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new KafkaUnboundedReader(this, checkpointMark);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KafkaCheckpointMark> getCheckpointMarkCoder() {
        return AvroCoder.of(KafkaCheckpointMark.class);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean requiresDeduping() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>> getOutputCoder() {
        Coder keyCoder = (Coder)Preconditions.checkStateNotNull(this.spec.getKeyCoder());
        Coder valueCoder = (Coder)Preconditions.checkStateNotNull(this.spec.getValueCoder());
        return KafkaRecordCoder.of(keyCoder, valueCoder);
    }

    public KafkaUnboundedSource( @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<K, V> spec, @UnknownKeyFor @NonNull @Initialized int id) {
        this.spec = spec;
        this.id = id;
    }

     @UnknownKeyFor @NonNull @Initialized KafkaIO.Read<K, V> getSpec() {
        return this.spec;
    }

    @UnknownKeyFor @NonNull @Initialized int getId() {
        return this.id;
    }
}

