/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import com.azure.security.keyvault.secrets.implementation.models.BackupSecretResult;
import com.azure.security.keyvault.secrets.implementation.models.DeletedSecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.secrets.implementation.models.SecretBundle;
import com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

@ServiceClient(builder=SecretClientBuilder.class, serviceInterfaces={SecretClientImpl.SecretClientService.class})
public final class SecretClient {
    private static final ClientLogger LOGGER = new ClientLogger(SecretClient.class);
    private final SecretClientImpl implClient;
    private final String vaultUrl;

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    SecretClient(SecretClientImpl implClient, String vaultUrl) {
        this.implClient = implClient;
        this.vaultUrl = vaultUrl;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(KeyVaultSecret secret) {
        return (KeyVaultSecret)this.setSecretWithResponse(secret, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret setSecret(String name, String value) {
        return (KeyVaultSecret)this.setSecretWithResponse(new KeyVaultSecret(name, value), Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            SecretProperties secretProperties = secret.getProperties();
            if (secretProperties == null) {
                Response<SecretBundle> response = this.implClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), null, null, null, context);
                return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue()));
            }
            Response<SecretBundle> response = this.implClient.setSecretWithResponse(this.vaultUrl, secret.getName(), secret.getValue(), secretProperties.getTags(), secretProperties.getContentType(), SecretsModelsUtils.createSecretAttributes(secretProperties), context);
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue()));
        }, SecretAsyncClient::mapSetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret getSecret(String name, String version) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, version, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)name)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'name' cannot be null or empty."));
        }
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<SecretBundle> response = this.implClient.getSecretWithResponse(this.vaultUrl, name, version, context);
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue()));
        }, SecretAsyncClient::mapGetSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecretProperties updateSecretProperties(SecretProperties secretProperties) {
        return (SecretProperties)this.updateSecretPropertiesWithResponse(secretProperties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        Response<SecretBundle> response = this.implClient.updateSecretWithResponse(this.vaultUrl, secretProperties.getName(), secretProperties.getVersion(), secretProperties.getContentType(), SecretsModelsUtils.createSecretAttributes(secretProperties), secretProperties.getTags(), context);
        return new SimpleResponse(response, (Object)SecretsModelsUtils.createSecretProperties((SecretBundle)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.deleteActivationOperation(name), this.deletePollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deleteActivationOperation(String name) {
        return pollingContext -> SecretClient.callWithMappedException(() -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)SecretsModelsUtils.createDeletedSecret(this.implClient.deleteSecret(this.vaultUrl, name))), SecretAsyncClient::mapDeleteSecretException);
    }

    private Function<PollingContext<DeletedSecret>, PollResponse<DeletedSecret>> deletePollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createDeletedSecret(this.implClient.getDeletedSecret(this.vaultUrl, name)));
            }
            catch (HttpResponseException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
            }
            catch (Exception ex) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((DeletedSecret)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedSecret getDeletedSecret(String name) {
        return (DeletedSecret)this.getDeletedSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<DeletedSecretBundle> response = this.implClient.getDeletedSecretWithResponse(this.vaultUrl, name, context);
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createDeletedSecret((DeletedSecretBundle)response.getValue()));
        }, SecretAsyncClient::mapGetDeletedSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedSecret(String name) {
        this.purgeDeletedSecretWithResponse(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        return SecretClient.callWithMappedException(() -> this.implClient.purgeDeletedSecretWithResponse(this.vaultUrl, name, context), SecretAsyncClient::mapPurgeDeletedSecretException);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), this.recoverActivationOperation(name), this.recoverPollOperation(name), (context, response) -> null, context -> null);
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverActivationOperation(String name) {
        return pollingContext -> SecretClient.callWithMappedException(() -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)SecretsModelsUtils.createKeyVaultSecret(this.implClient.recoverDeletedSecret(this.vaultUrl, name))), SecretAsyncClient::mapRecoverDeletedSecretException);
    }

    private Function<PollingContext<KeyVaultSecret>, PollResponse<KeyVaultSecret>> recoverPollOperation(String name) {
        return pollingContext -> {
            try {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)SecretsModelsUtils.createKeyVaultSecret(this.implClient.getSecret(this.vaultUrl, name, null)));
            }
            catch (HttpResponseException ex) {
                if (ex.getResponse().getStatusCode() == 404) {
                    return new PollResponse(LongRunningOperationStatus.IN_PROGRESS, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
                }
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
            }
            catch (Exception ex) {
                return new PollResponse(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, (Object)((KeyVaultSecret)pollingContext.getLatestResponse().getValue()));
            }
        };
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] backupSecret(String name) {
        return (byte[])this.backupSecretWithResponse(name, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<BackupSecretResult> response = this.implClient.backupSecretWithResponse(this.vaultUrl, name, context);
            return new SimpleResponse(response, (Object)((BackupSecretResult)response.getValue()).getValue());
        }, SecretAsyncClient::mapBackupSecretException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSecret restoreSecretBackup(byte[] backup) {
        return (KeyVaultSecret)this.restoreSecretBackupWithResponse(backup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        return (Response)SecretClient.callWithMappedException(() -> {
            Response<SecretBundle> response = this.implClient.restoreSecretWithResponse(this.vaultUrl, backup, context);
            return new SimpleResponse(response, (Object)SecretsModelsUtils.createKeyVaultSecret((SecretBundle)response.getValue()));
        }, SecretAsyncClient::mapRestoreSecretException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets() {
        return this.listPropertiesOfSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedIterable(maxResults -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretsSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets() {
        return this.listDeletedSecrets(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedIterable(maxResults -> SecretAsyncClient.mapDeletedSecretItemPage(this.implClient.getDeletedSecretsSinglePage(this.vaultUrl, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapDeletedSecretItemPage(this.implClient.getDeletedSecretsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return this.listPropertiesOfSecretVersions(name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedIterable(maxResults -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretVersionsSinglePage(this.vaultUrl, name, (Integer)maxResults, context)), (continuationToken, maxResults) -> SecretAsyncClient.mapSecretItemPage(this.implClient.getSecretVersionsNextSinglePage((String)continuationToken, this.vaultUrl, context)));
    }

    private static <T> T callWithMappedException(Supplier<T> call, Function<KeyVaultErrorException, HttpResponseException> exceptionMapper) {
        try {
            return call.get();
        }
        catch (KeyVaultErrorException ex) {
            throw exceptionMapper.apply(ex);
        }
    }
}

