/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.javacc;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;

public class JavaCC
extends Task {
    private static final String LOOKAHEAD = "LOOKAHEAD";
    private static final String CHOICE_AMBIGUITY_CHECK = "CHOICE_AMBIGUITY_CHECK";
    private static final String OTHER_AMBIGUITY_CHECK = "OTHER_AMBIGUITY_CHECK";
    private static final String STATIC = "STATIC";
    private static final String DEBUG_PARSER = "DEBUG_PARSER";
    private static final String DEBUG_LOOKAHEAD = "DEBUG_LOOKAHEAD";
    private static final String DEBUG_TOKEN_MANAGER = "DEBUG_TOKEN_MANAGER";
    private static final String OPTIMIZE_TOKEN_MANAGER = "OPTIMIZE_TOKEN_MANAGER";
    private static final String ERROR_REPORTING = "ERROR_REPORTING";
    private static final String JAVA_UNICODE_ESCAPE = "JAVA_UNICODE_ESCAPE";
    private static final String UNICODE_INPUT = "UNICODE_INPUT";
    private static final String IGNORE_CASE = "IGNORE_CASE";
    private static final String COMMON_TOKEN_ACTION = "COMMON_TOKEN_ACTION";
    private static final String USER_TOKEN_MANAGER = "USER_TOKEN_MANAGER";
    private static final String USER_CHAR_STREAM = "USER_CHAR_STREAM";
    private static final String BUILD_PARSER = "BUILD_PARSER";
    private static final String BUILD_TOKEN_MANAGER = "BUILD_TOKEN_MANAGER";
    private static final String SANITY_CHECK = "SANITY_CHECK";
    private static final String FORCE_LA_CHECK = "FORCE_LA_CHECK";
    private static final String CACHE_TOKENS = "CACHE_TOKENS";
    private static final String KEEP_LINE_COLUMN = "KEEP_LINE_COLUMN";
    private final Hashtable optionalAttrs = new Hashtable();
    private File outputDirectory = null;
    private File target = null;
    private File javaccHome = null;
    private CommandlineJava cmdl = new CommandlineJava();
    protected static final int TASKDEF_TYPE_JAVACC = 1;
    protected static final int TASKDEF_TYPE_JJTREE = 2;
    protected static final int TASKDEF_TYPE_JJDOC = 3;
    protected static final String[] ARCHIVE_LOCATIONS = new String[]{"JavaCC.zip", "bin/lib/JavaCC.zip", "bin/lib/javacc.jar", "javacc.jar"};
    protected static final int[] ARCHIVE_LOCATIONS_VS_MAJOR_VERSION = new int[]{1, 2, 3, 3};
    protected static final String COM_PACKAGE = "COM.sun.labs.";
    protected static final String COM_JAVACC_CLASS = "javacc.Main";
    protected static final String COM_JJTREE_CLASS = "jjtree.Main";
    protected static final String COM_JJDOC_CLASS = "jjdoc.JJDocMain";
    protected static final String ORG_PACKAGE_3_0 = "org.netbeans.javacc.";
    protected static final String ORG_PACKAGE_3_1 = "org.javacc.";
    protected static final String ORG_JAVACC_CLASS = "parser.Main";
    protected static final String ORG_JJTREE_CLASS = "jjtree.Main";
    protected static final String ORG_JJDOC_CLASS = "jjdoc.JJDocMain";

    public void setLookahead(int lookahead) {
        this.optionalAttrs.put(LOOKAHEAD, new Integer(lookahead));
    }

    public void setChoiceambiguitycheck(int choiceAmbiguityCheck) {
        this.optionalAttrs.put(CHOICE_AMBIGUITY_CHECK, new Integer(choiceAmbiguityCheck));
    }

    public void setOtherambiguityCheck(int otherAmbiguityCheck) {
        this.optionalAttrs.put(OTHER_AMBIGUITY_CHECK, new Integer(otherAmbiguityCheck));
    }

    public void setStatic(boolean staticParser) {
        this.optionalAttrs.put(STATIC, new Boolean(staticParser));
    }

    public void setDebugparser(boolean debugParser) {
        this.optionalAttrs.put(DEBUG_PARSER, new Boolean(debugParser));
    }

    public void setDebuglookahead(boolean debugLookahead) {
        this.optionalAttrs.put(DEBUG_LOOKAHEAD, new Boolean(debugLookahead));
    }

    public void setDebugtokenmanager(boolean debugTokenManager) {
        this.optionalAttrs.put(DEBUG_TOKEN_MANAGER, new Boolean(debugTokenManager));
    }

    public void setOptimizetokenmanager(boolean optimizeTokenManager) {
        this.optionalAttrs.put(OPTIMIZE_TOKEN_MANAGER, new Boolean(optimizeTokenManager));
    }

    public void setErrorreporting(boolean errorReporting) {
        this.optionalAttrs.put(ERROR_REPORTING, new Boolean(errorReporting));
    }

    public void setJavaunicodeescape(boolean javaUnicodeEscape) {
        this.optionalAttrs.put(JAVA_UNICODE_ESCAPE, new Boolean(javaUnicodeEscape));
    }

    public void setUnicodeinput(boolean unicodeInput) {
        this.optionalAttrs.put(UNICODE_INPUT, new Boolean(unicodeInput));
    }

    public void setIgnorecase(boolean ignoreCase) {
        this.optionalAttrs.put(IGNORE_CASE, new Boolean(ignoreCase));
    }

    public void setCommontokenaction(boolean commonTokenAction) {
        this.optionalAttrs.put(COMMON_TOKEN_ACTION, new Boolean(commonTokenAction));
    }

    public void setUsertokenmanager(boolean userTokenManager) {
        this.optionalAttrs.put(USER_TOKEN_MANAGER, new Boolean(userTokenManager));
    }

    public void setUsercharstream(boolean userCharStream) {
        this.optionalAttrs.put(USER_CHAR_STREAM, new Boolean(userCharStream));
    }

    public void setBuildparser(boolean buildParser) {
        this.optionalAttrs.put(BUILD_PARSER, new Boolean(buildParser));
    }

    public void setBuildtokenmanager(boolean buildTokenManager) {
        this.optionalAttrs.put(BUILD_TOKEN_MANAGER, new Boolean(buildTokenManager));
    }

    public void setSanitycheck(boolean sanityCheck) {
        this.optionalAttrs.put(SANITY_CHECK, new Boolean(sanityCheck));
    }

    public void setForcelacheck(boolean forceLACheck) {
        this.optionalAttrs.put(FORCE_LA_CHECK, new Boolean(forceLACheck));
    }

    public void setCachetokens(boolean cacheTokens) {
        this.optionalAttrs.put(CACHE_TOKENS, new Boolean(cacheTokens));
    }

    public void setKeeplinecolumn(boolean keepLineColumn) {
        this.optionalAttrs.put(KEEP_LINE_COLUMN, new Boolean(keepLineColumn));
    }

    public void setOutputdirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    public void setJavacchome(File javaccHome) {
        this.javaccHome = javaccHome;
    }

    public JavaCC() {
        this.cmdl.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
    }

    public void execute() throws BuildException {
        Enumeration iter = this.optionalAttrs.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = this.optionalAttrs.get(name);
            this.cmdl.createArgument().setValue("-" + name + ":" + value.toString());
        }
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.target.getParent());
        } else if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Outputdir not a directory.");
        }
        this.cmdl.createArgument().setValue("-OUTPUT_DIRECTORY:" + this.outputDirectory.getAbsolutePath());
        File javaFile = this.getOutputJavaFile(this.outputDirectory, this.target);
        if (javaFile.exists() && this.target.lastModified() < javaFile.lastModified()) {
            this.log("Target is already built - skipping (" + this.target + ")", 3);
            return;
        }
        this.cmdl.createArgument().setValue(this.target.getAbsolutePath());
        this.cmdl.setClassname(JavaCC.getMainClass(this.javaccHome, 1));
        Path classpath = this.cmdl.createClasspath(this.getProject());
        File javaccJar = JavaCC.getArchiveFile(this.javaccHome);
        classpath.createPathElement().setPath(javaccJar.getAbsolutePath());
        classpath.addJavaRuntime();
        Commandline.Argument arg = this.cmdl.createVmArgument();
        arg.setValue("-mx140M");
        arg.setValue("-Dinstall.root=" + this.javaccHome.getAbsolutePath());
        Execute.runCommand((Task)this, (String[])this.cmdl.getCommandline());
    }

    protected static File getArchiveFile(File home) throws BuildException {
        return new File(home, ARCHIVE_LOCATIONS[JavaCC.getArchiveLocationIndex(home)]);
    }

    protected static String getMainClass(File home, int type) throws BuildException {
        int majorVersion = JavaCC.getMajorVersionNumber(home);
        String packagePrefix = null;
        String mainClass = null;
        block4 : switch (majorVersion) {
            case 1: 
            case 2: {
                packagePrefix = COM_PACKAGE;
                switch (type) {
                    case 1: {
                        mainClass = COM_JAVACC_CLASS;
                        break;
                    }
                    case 2: {
                        mainClass = "jjtree.Main";
                        break;
                    }
                    case 3: {
                        mainClass = "jjdoc.JJDocMain";
                    }
                }
                break;
            }
            case 3: {
                ZipFile zf = null;
                try {
                    zf = new ZipFile(JavaCC.getArchiveFile(home));
                    packagePrefix = zf.getEntry(ORG_PACKAGE_3_0.replace('.', '/')) != null ? ORG_PACKAGE_3_0 : ORG_PACKAGE_3_1;
                }
                catch (IOException e) {
                    throw new BuildException("Error reading javacc.jar", (Throwable)e);
                }
                finally {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException e) {
                            throw new BuildException((Throwable)e);
                        }
                    }
                }
                switch (type) {
                    case 1: {
                        mainClass = ORG_JAVACC_CLASS;
                        break block4;
                    }
                    case 2: {
                        mainClass = "jjtree.Main";
                        break block4;
                    }
                    case 3: {
                        mainClass = "jjdoc.JJDocMain";
                    }
                }
            }
        }
        return packagePrefix + mainClass;
    }

    private static int getArchiveLocationIndex(File home) throws BuildException {
        if (home == null || !home.isDirectory()) {
            throw new BuildException("JavaCC home must be a valid directory.");
        }
        int i = 0;
        while (i < ARCHIVE_LOCATIONS.length) {
            File f = new File(home, ARCHIVE_LOCATIONS[i]);
            if (f.exists()) {
                return i;
            }
            ++i;
        }
        throw new BuildException("Could not find a path to JavaCC.zip or javacc.jar from '" + home + "'.");
    }

    protected static int getMajorVersionNumber(File home) throws BuildException {
        return ARCHIVE_LOCATIONS_VS_MAJOR_VERSION[JavaCC.getArchiveLocationIndex(home)];
    }

    private File getOutputJavaFile(File outputdir, File srcfile) {
        int startExtn;
        String path = srcfile.getPath();
        int startBasename = path.lastIndexOf(File.separator);
        if (startBasename != -1) {
            path = path.substring(startBasename + 1);
        }
        path = (startExtn = path.lastIndexOf(46)) != -1 ? path.substring(0, startExtn) + ".java" : path + ".java";
        if (outputdir != null) {
            path = outputdir + File.separator + path;
        }
        return new File(path);
    }
}

