/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.view;

import org.apache.ignite.internal.managers.systemview.walker.Filtrable;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;

public class StatisticsColumnConfigurationView {
    public static final String TABLE_TYPE = "TABLE";
    private final StatisticsObjectConfiguration objCfg;
    private final StatisticsColumnConfiguration colCfg;

    public StatisticsColumnConfigurationView(StatisticsObjectConfiguration objCfg, StatisticsColumnConfiguration colCfg) {
        this.objCfg = objCfg;
        this.colCfg = colCfg;
    }

    @Order
    @Filtrable
    public String schema() {
        return this.objCfg.key().schema();
    }

    @Order(value=1)
    @Filtrable
    public String type() {
        return TABLE_TYPE;
    }

    @Order(value=2)
    @Filtrable
    public String name() {
        return this.objCfg.key().obj();
    }

    @Order(value=3)
    @Filtrable
    public String column() {
        return this.colCfg.name();
    }

    @Order(value=4)
    public byte maxPartitionObsolescencePercent() {
        return this.objCfg.maxPartitionObsolescencePercent();
    }

    @Order(value=5)
    public Long manualNulls() {
        return this.colCfg.overrides() == null ? null : this.colCfg.overrides().nulls();
    }

    @Order(value=6)
    public Long manualDistinct() {
        return this.colCfg.overrides() == null ? null : this.colCfg.overrides().distinct();
    }

    @Order(value=7)
    public Long manualTotal() {
        return this.colCfg.overrides() == null ? null : this.colCfg.overrides().total();
    }

    @Order(value=8)
    public Integer manualSize() {
        return this.colCfg.overrides() == null ? null : this.colCfg.overrides().size();
    }

    @Order(value=9)
    public long version() {
        return this.colCfg.version();
    }
}

