/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.AlignedBuffers;
import org.apache.ignite.internal.processors.cache.persistence.file.IgniteNativeIoLib;
import org.apache.ignite.internal.processors.compress.FileSystemUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class AlignedBuffersDirectFileIO
extends AbstractFileIO {
    private static final int FILE_POS_USE_CURRENT = -1;
    private final int ioBlockSize;
    private final int pageSize;
    private final int fsBlockSize;
    private final File file;
    private final IgniteLogger log;
    private ThreadLocal<ByteBuffer> tlbOnePageAligned;
    private ConcurrentHashMap<Long, Thread> managedAlignedBuffers;
    private int fd = -1;
    private static final int CACHED_LONGS = 512;
    private static final int NL_CACHE_DIVISOR = 4096;
    private static final AtomicReferenceArray<NativeLong> nativeLongCache = new AtomicReferenceArray(512);

    AlignedBuffersDirectFileIO(int ioBlockSize, int pageSize, File file, OpenOption[] modes, ThreadLocal<ByteBuffer> tlbOnePageAligned, ConcurrentHashMap<Long, Thread> managedAlignedBuffers, IgniteLogger log) throws IOException {
        this.log = log;
        this.ioBlockSize = ioBlockSize;
        this.pageSize = pageSize;
        this.file = file;
        this.tlbOnePageAligned = tlbOnePageAligned;
        this.managedAlignedBuffers = managedAlignedBuffers;
        String pathname = file.getAbsolutePath();
        int openFlags = AlignedBuffersDirectFileIO.setupOpenFlags(modes, log, true);
        int mode = 420;
        int fd = IgniteNativeIoLib.open(pathname, openFlags, mode);
        if (fd < 0) {
            int error = Native.getLastError();
            String msg = "Error opening file [" + pathname + "] with flags [0x" + String.format("%2X", openFlags) + ": DIRECT & " + Arrays.asList(modes) + "], got error [" + error + ": " + AlignedBuffersDirectFileIO.getLastError() + "]";
            if (error == 22 && (fd = IgniteNativeIoLib.open(pathname, openFlags = AlignedBuffersDirectFileIO.setupOpenFlags(modes, log, false), mode)) > 0) {
                U.warn((IgniteLogger)log, (Object)("Disable Direct IO mode for path " + file.getParentFile() + "(probably incompatible file system selected, for example, tmpfs): " + msg));
                this.fd = fd;
                this.fsBlockSize = FileSystemUtils.getFileSystemBlockSize((int)fd);
                return;
            }
            throw new IOException(msg);
        }
        this.fd = fd;
        this.fsBlockSize = FileSystemUtils.getFileSystemBlockSize((int)fd);
    }

    private static int setupOpenFlags(OpenOption[] modes, IgniteLogger log, boolean enableDirect) {
        int flags = enableDirect ? 16384 : 0;
        List<OpenOption> openOptionList = Arrays.asList(modes);
        for (OpenOption mode : openOptionList) {
            if (mode == StandardOpenOption.READ) {
                flags |= openOptionList.contains(StandardOpenOption.WRITE) ? 2 : 0;
                continue;
            }
            if (mode == StandardOpenOption.WRITE) {
                flags |= openOptionList.contains(StandardOpenOption.READ) ? 2 : 1;
                continue;
            }
            if (mode == StandardOpenOption.CREATE) {
                flags |= 0x40;
                continue;
            }
            if (mode == StandardOpenOption.TRUNCATE_EXISTING) {
                flags |= 0x200;
                continue;
            }
            if (mode == StandardOpenOption.SYNC) {
                flags |= 0x100000;
                continue;
            }
            log.error("Unsupported open option [" + mode + "]");
        }
        return flags;
    }

    public int getFileSystemBlockSize() {
        return this.fsBlockSize;
    }

    public long getSparseSize() {
        return FileSystemUtils.getSparseFileSize((int)this.fd);
    }

    public int punchHole(long position, int len) {
        return (int)FileSystemUtils.punchHole((int)this.fd, (long)position, (long)len, (int)this.fsBlockSize);
    }

    public long position() throws IOException {
        long position = IgniteNativeIoLib.lseek(this.fdCheckOpened(), 0L, 1);
        if (position < 0L) {
            throw new IOException(String.format("Error checking file [%s] position: %s", this.file, AlignedBuffersDirectFileIO.getLastError()));
        }
        return position;
    }

    public void position(long newPosition) throws IOException {
        if (IgniteNativeIoLib.lseek(this.fdCheckOpened(), newPosition, 0) < 0L) {
            throw new IOException(String.format("Error setting file [%s] position to [%s]: %s", this.file, Long.toString(newPosition), AlignedBuffersDirectFileIO.getLastError()));
        }
    }

    public int read(ByteBuffer destBuf) throws IOException {
        return this.read(destBuf, -1L);
    }

    public int read(ByteBuffer destBuf, long filePosition) throws IOException {
        int size = this.checkSizeIsPadded(destBuf.remaining());
        return this.isKnownAligned(destBuf) ? this.readIntoAlignedBuffer(destBuf, filePosition) : this.readIntoUnalignedBuffer(destBuf, filePosition, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readIntoUnalignedBuffer(ByteBuffer destBuf, long filePosition, int size) throws IOException {
        boolean useTlb = size == this.pageSize;
        ByteBuffer alignedBuf = useTlb ? this.tlbOnePageAligned.get() : AlignedBuffers.allocate(this.ioBlockSize, size);
        try {
            assert (alignedBuf.position() == 0) : "Temporary aligned buffer is in incorrect state: position is set incorrectly";
            assert (alignedBuf.limit() == size) : "Temporary aligned buffer is in incorrect state: limit is set incorrectly";
            int loaded = this.readIntoAlignedBuffer(alignedBuf, filePosition);
            alignedBuf.flip();
            if (loaded > 0) {
                destBuf.put(alignedBuf);
            }
            int n = loaded;
            return n;
        }
        finally {
            alignedBuf.clear();
            if (!useTlb) {
                AlignedBuffers.free(alignedBuf);
            }
        }
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(buf, off, len));
    }

    public int write(ByteBuffer srcBuf) throws IOException {
        return this.write(srcBuf, -1L);
    }

    public int write(ByteBuffer srcBuf, long filePosition) throws IOException {
        return this.isKnownAligned(srcBuf) ? this.writeFromAlignedBuffer(srcBuf, filePosition) : this.writeFromUnalignedBuffer(srcBuf, filePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeFromUnalignedBuffer(ByteBuffer srcBuf, long filePosition) throws IOException {
        int size = srcBuf.remaining();
        boolean useTlb = size <= this.pageSize;
        ByteBuffer alignedBuf = useTlb ? this.tlbOnePageAligned.get() : AlignedBuffers.allocate(this.ioBlockSize, size);
        try {
            int written;
            assert (alignedBuf.position() == 0) : "Temporary aligned buffer is in incorrect state: position is set incorrectly";
            assert (alignedBuf.limit() >= size) : "Temporary aligned buffer is in incorrect state: limit is set incorrectly";
            int initPos = srcBuf.position();
            alignedBuf.put(srcBuf);
            alignedBuf.flip();
            int len = alignedBuf.remaining();
            if (len % this.ioBlockSize != 0) {
                this.alignBufferLimit(alignedBuf);
            }
            if ((written = this.writeFromAlignedBuffer(alignedBuf, filePosition)) > len) {
                written = len;
            }
            srcBuf.position(initPos + written);
            int n = written;
            return n;
        }
        finally {
            alignedBuf.clear();
            if (!useTlb) {
                AlignedBuffers.free(alignedBuf);
            }
        }
    }

    private void alignBufferLimit(ByteBuffer buf) {
        int len = buf.remaining();
        int alignedLen = (len / this.ioBlockSize + 1) * this.ioBlockSize;
        buf.limit(buf.limit() + alignedLen - len);
    }

    private boolean isKnownAligned(ByteBuffer srcBuf) {
        return srcBuf.isDirect() && this.managedAlignedBuffers != null && this.managedAlignedBuffers.containsKey(GridUnsafe.bufferAddress((ByteBuffer)srcBuf));
    }

    private int checkSizeIsPadded(int size) throws IOException {
        if (size % this.ioBlockSize != 0) {
            throw new IOException(String.format("Unable to apply DirectIO for read/write buffer [%d] bytes on block size [%d]. Consider setting %s.setPageSize(%d) or disable Direct IO.", size, this.ioBlockSize, DataStorageConfiguration.class.getSimpleName(), this.ioBlockSize));
        }
        return size;
    }

    private int fdCheckOpened() throws IOException {
        if (this.fd < 0) {
            throw new IOException(String.format("Error %s not opened", this.file));
        }
        return this.fd;
    }

    private int readIntoAlignedBuffer(ByteBuffer destBuf, long filePos) throws IOException {
        int limit;
        int toRead;
        int pos = destBuf.position();
        int n = toRead = pos <= (limit = destBuf.limit()) ? limit - pos : 0;
        if (toRead == 0) {
            return 0;
        }
        if (pos + toRead > destBuf.capacity()) {
            throw new BufferOverflowException();
        }
        Pointer ptr = this.bufferPtrAtPosition(destBuf, pos);
        int rd = filePos == -1L ? IgniteNativeIoLib.read(this.fdCheckOpened(), ptr, AlignedBuffersDirectFileIO.nl(toRead)).intValue() : IgniteNativeIoLib.pread(this.fdCheckOpened(), ptr, AlignedBuffersDirectFileIO.nl(toRead), AlignedBuffersDirectFileIO.nl(filePos)).intValue();
        if (rd == 0) {
            return -1;
        }
        if (rd < 0) {
            throw new IOException(String.format("Error during reading file [%s] from position [%s] : %s", this.file, filePos == -1L ? "current" : Long.toString(filePos), AlignedBuffersDirectFileIO.getLastError()));
        }
        destBuf.position(pos + rd);
        return rd;
    }

    private int writeFromAlignedBuffer(ByteBuffer srcBuf, long filePos) throws IOException {
        int limit;
        int toWrite;
        int pos = srcBuf.position();
        int n = toWrite = pos <= (limit = srcBuf.limit()) ? limit - pos : 0;
        if (toWrite == 0) {
            return 0;
        }
        Pointer ptr = this.bufferPtrAtPosition(srcBuf, pos);
        int wr = filePos == -1L ? IgniteNativeIoLib.write(this.fdCheckOpened(), ptr, AlignedBuffersDirectFileIO.nl(toWrite)).intValue() : IgniteNativeIoLib.pwrite(this.fdCheckOpened(), ptr, AlignedBuffersDirectFileIO.nl(toWrite), AlignedBuffersDirectFileIO.nl(filePos)).intValue();
        if (wr < 0) {
            throw new IOException(String.format("Error during writing file [%s] to position [%s]: %s", this.file, filePos == -1L ? "current" : Long.toString(filePos), AlignedBuffersDirectFileIO.getLastError()));
        }
        if (pos + wr > limit) {
            throw new IllegalStateException(String.format("Write illegal state for file [%s]: pos=%d, wr=%d, limit=%d", this.file, pos, wr, limit));
        }
        srcBuf.position(pos + wr);
        return wr;
    }

    @NotNull
    private static NativeLong nl(long val) {
        if (val % 4096L == 0L && val < 0x200000L) {
            int cacheIdx = (int)(val / 4096L);
            NativeLong curCached = nativeLongCache.get(cacheIdx);
            if (curCached != null) {
                return curCached;
            }
            NativeLong nl = new NativeLong(val);
            nativeLongCache.compareAndSet(cacheIdx, null, nl);
            return nl;
        }
        return new NativeLong(val);
    }

    private static String getLastError() {
        return IgniteNativeIoLib.strerror(Native.getLastError());
    }

    @NotNull
    private Pointer bufferPtrAtPosition(ByteBuffer buf, int pos) {
        long alignedPointer = GridUnsafe.bufferAddress((ByteBuffer)buf);
        if (pos < 0) {
            throw new IllegalArgumentException();
        }
        if (pos > buf.capacity()) {
            throw new BufferOverflowException();
        }
        if ((alignedPointer + (long)pos) % (long)this.ioBlockSize != 0L) {
            U.warn((IgniteLogger)this.log, (Object)String.format("IO Buffer Pointer [%d] and/or offset [%d] seems to be not aligned for IO block size [%d]. Direct IO may fail.", alignedPointer, buf.position(), this.ioBlockSize));
        }
        return new Pointer(alignedPointer + (long)pos);
    }

    public int write(byte[] buf, int off, int len) throws IOException {
        return this.write(ByteBuffer.wrap(buf, off, len));
    }

    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException("AsynchronousFileChannel doesn't support mmap.");
    }

    public void force() throws IOException {
        this.force(false);
    }

    public void force(boolean withMetadata) throws IOException {
        int res;
        int fd = this.fdCheckOpened();
        int n = res = withMetadata ? IgniteNativeIoLib.fsync(fd) : IgniteNativeIoLib.fdatasync(fd);
        if (res < 0) {
            throw new IOException(String.format("Error fsync()'ing %s, got %s", this.file, AlignedBuffersDirectFileIO.getLastError()));
        }
    }

    public long size() throws IOException {
        return this.file.length();
    }

    public void clear() throws IOException {
        this.truncate(0L);
    }

    private void truncate(long size) throws IOException {
        if (IgniteNativeIoLib.ftruncate(this.fdCheckOpened(), size) < 0) {
            throw new IOException(String.format("Error truncating file %s, got %s", this.file, AlignedBuffersDirectFileIO.getLastError()));
        }
        if (this.position() > size) {
            this.position(size);
        }
    }

    public void close() throws IOException {
        if (IgniteNativeIoLib.close(this.fdCheckOpened()) < 0) {
            throw new IOException(String.format("Error closing %s, got %s", this.file, AlignedBuffersDirectFileIO.getLastError()));
        }
        this.fd = -1;
    }
}

