/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.tags;

import io.opencensus.implcore.tags.TagValueWithMetadata;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TagMapImpl
extends TagContext {
    public static final TagMapImpl EMPTY = new TagMapImpl(Collections.emptyMap());
    private final Map<TagKey, TagValueWithMetadata> tags;

    public TagMapImpl(Map<? extends TagKey, ? extends TagValueWithMetadata> tags) {
        this.tags = Collections.unmodifiableMap(new HashMap<TagKey, TagValueWithMetadata>(tags));
    }

    public Map<TagKey, TagValueWithMetadata> getTags() {
        return this.tags;
    }

    protected Iterator<Tag> getIterator() {
        return new TagIterator(this.tags);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof TagMapImpl) {
            return this.getTags().equals(((TagMapImpl)((Object)other)).getTags());
        }
        return super.equals(other);
    }

    private static final class TagIterator
    implements Iterator<Tag> {
        Iterator<Map.Entry<TagKey, TagValueWithMetadata>> iterator;

        TagIterator(Map<TagKey, TagValueWithMetadata> tags) {
            this.iterator = tags.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Tag next() {
            Map.Entry<TagKey, TagValueWithMetadata> next = this.iterator.next();
            TagValueWithMetadata valueWithMetadata = next.getValue();
            return Tag.create((TagKey)next.getKey(), (TagValue)valueWithMetadata.getTagValue(), (TagMetadata)valueWithMetadata.getTagMetadata());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TagIterator.remove()");
        }
    }
}

