/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.sql.Timestamp;
import java.util.UUID;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionLockResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionLockProcessor
implements CacheEntryProcessor<String, PlatformDotNetSessionData, Object> {
    private static final long serialVersionUID = 0L;
    private UUID lockNodeId;
    private long lockId;
    private Timestamp lockTime;

    public PlatformDotNetSessionLockProcessor(UUID lockNodeId, long lockId, Timestamp lockTime) {
        this.lockNodeId = lockNodeId;
        this.lockId = lockId;
        this.lockTime = lockTime;
    }

    public Object process(MutableEntry<String, PlatformDotNetSessionData> entry, Object ... args) throws EntryProcessorException {
        if (!entry.exists()) {
            return null;
        }
        PlatformDotNetSessionData data = (PlatformDotNetSessionData)entry.getValue();
        assert (data != null);
        if (data.isLocked()) {
            return new PlatformDotNetSessionLockResult(false, null, data.lockTime(), data.lockId());
        }
        data = data.lock(this.lockNodeId, this.lockId, this.lockTime);
        entry.setValue((Object)data);
        return new PlatformDotNetSessionLockResult(true, data, null, data.lockId());
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionLockProcessor.class, this);
    }
}

