/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import io.javalin.http.HttpCode;
import io.javalin.plugin.json.JavalinJackson;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.events.Event;
import org.apache.amoro.api.events.IcebergReportEvent;
import org.apache.amoro.server.catalog.InternalCatalog;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.exception.ObjectNotExistsException;
import org.apache.amoro.server.manager.EventsManager;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequestParser;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestCatalogService
extends PersistentBase {
    private static final Logger LOG = LoggerFactory.getLogger(RestCatalogService.class);
    public static final String ICEBERG_REST_API_PREFIX = "/api/iceberg/rest";
    private static final String ICEBERG_CATALOG_PREFIX_KEY = "prefix";
    private static final Set<String> catalogPropertiesNotReturned = Collections.emptySet();
    private static final Set<String> catalogPropertiesOverwrite = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"warehouse"}));
    private final JavalinJackson jsonMapper;
    private final TableService tableService;

    public RestCatalogService(TableService tableService) {
        this.tableService = tableService;
        ObjectMapper objectMapper = this.jsonMapper();
        this.jsonMapper = new JavalinJackson(objectMapper);
    }

    public EndpointGroup endpoints() {
        return () -> ApiBuilder.path((String)ICEBERG_REST_API_PREFIX, () -> {
            ApiBuilder.get((String)"/v1/config", this::getCatalogConfig);
            ApiBuilder.get((String)"/v1/catalogs/{catalog}/namespaces", this::listNamespaces);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/namespaces", this::createNamespace);
            ApiBuilder.get((String)"/v1/catalogs/{catalog}/namespaces/{namespace}", this::getNamespace);
            ApiBuilder.delete((String)"/v1/catalogs/{catalog}/namespaces/{namespace}", this::dropNamespace);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/namespaces/{namespace}", this::setNamespaceProperties);
            ApiBuilder.get((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables", this::listTablesInNamespace);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables", this::createTable);
            ApiBuilder.get((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}", this::loadTable);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}", this::commitTable);
            ApiBuilder.delete((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}", this::deleteTable);
            ApiBuilder.head((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}", this::tableExists);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/tables/rename", this::renameTable);
            ApiBuilder.post((String)"/v1/catalogs/{catalog}/namespaces/{namespace}/tables/{table}/metrics", this::reportMetrics);
        });
    }

    public boolean needHandleException(Context ctx) {
        return ctx.req.getRequestURI().startsWith(ICEBERG_REST_API_PREFIX);
    }

    public void handleException(Exception e, Context ctx) {
        IcebergRestErrorCode code = IcebergRestErrorCode.exceptionToCode(e);
        ErrorResponse response = ErrorResponse.builder().responseCode(Integer.valueOf(code.code)).withType(e.getClass().getSimpleName()).withMessage(e.getMessage()).build();
        ctx.res.setStatus(code.code);
        this.jsonResponse(ctx, (RESTResponse)response);
        if (code.code >= 500) {
            LOG.warn("InternalServer Error", (Throwable)e);
        } else {
            LOG.info("Exception when handle request: {} {}, code: {} message: {}", new Object[]{ctx.req.getMethod(), ctx.req.getRequestURI().substring(ICEBERG_REST_API_PREFIX.length()), code.code, e.getMessage()});
        }
    }

    public void getCatalogConfig(Context ctx) {
        String warehouse = ctx.req.getParameter("warehouse");
        Preconditions.checkNotNull((Object)warehouse, (Object)"lack required params: warehouse");
        InternalCatalog catalog = this.getCatalog(warehouse);
        HashMap properties = Maps.newHashMap();
        HashMap overwrites = Maps.newHashMap();
        catalog.getMetadata().getCatalogProperties().forEach((k, v) -> {
            if (!catalogPropertiesNotReturned.contains(k)) {
                if (catalogPropertiesOverwrite.contains(k)) {
                    overwrites.put(k, v);
                } else {
                    properties.put(k, v);
                }
            }
        });
        overwrites.put(ICEBERG_CATALOG_PREFIX_KEY, "catalogs/" + warehouse);
        ConfigResponse configResponse = ConfigResponse.builder().withDefaults((Map)properties).withOverrides((Map)overwrites).build();
        this.jsonResponse(ctx, (RESTResponse)configResponse);
    }

    public void listNamespaces(Context ctx) {
        this.handleCatalog(ctx, catalog -> {
            String ns = ctx.req.getParameter("parent");
            List<Object> nsLists = Lists.newArrayList();
            List<String> databases = catalog.listDatabases();
            if (ns == null) {
                nsLists = databases.stream().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(Collectors.toList());
            } else {
                RestCatalogService.checkUnsupported(!ns.contains("."), "multi-level namespace is not supported, parent: " + ns);
                RestCatalogService.checkDatabaseExist(catalog.databaseExists(ns), ns);
            }
            return ListNamespacesResponse.builder().addAll((Collection)nsLists).build();
        });
    }

    public void createNamespace(Context ctx) {
        this.handleCatalog(ctx, catalog -> {
            CreateNamespaceRequest request = this.bodyAsClass(ctx, CreateNamespaceRequest.class);
            Namespace ns = request.namespace();
            RestCatalogService.checkUnsupported(ns.length() == 1, "multi-level namespace is not supported now");
            String database = ns.level(0);
            RestCatalogService.checkAlreadyExists(!catalog.databaseExists(database), "Database", database);
            catalog.createDatabase(database);
            return CreateNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{database})).build();
        });
    }

    public void getNamespace(Context ctx) {
        this.handleNamespace(ctx, (catalog, database) -> GetNamespaceResponse.builder().withNamespace(Namespace.of((String[])new String[]{database})).build());
    }

    public void dropNamespace(Context ctx) {
        String catalog = ctx.pathParam("catalog");
        String ns = ctx.pathParam("namespace");
        Preconditions.checkNotNull((Object)ns, (Object)"namespace is null");
        RestCatalogService.checkUnsupported(!ns.contains("."), "multi-level namespace is not supported");
        InternalCatalog internalCatalog = this.getCatalog(catalog);
        internalCatalog.dropDatabase(ns);
    }

    public void setNamespaceProperties(Context ctx) {
        throw new UnsupportedOperationException("namespace properties is not supported");
    }

    public void listTablesInNamespace(Context ctx) {
        this.handleNamespace(ctx, (catalog, database) -> {
            List tableIdentifiers = catalog.listTables((String)database).stream().map(i -> TableIdentifier.of((String[])new String[]{database, i.getIdentifier().getTableName()})).collect(Collectors.toList());
            return ListTablesResponse.builder().addAll(tableIdentifiers).build();
        });
    }

    public void createTable(Context ctx) {
        this.handleNamespace(ctx, (catalog, database) -> {
            CreateTableRequest request = this.bodyAsClass(ctx, CreateTableRequest.class);
            String tableName = request.name();
            TableFormat format = TablePropertyUtil.isBaseStore((Map)request.properties(), (TableFormat)TableFormat.MIXED_ICEBERG) ? TableFormat.MIXED_ICEBERG : TableFormat.ICEBERG;
            try (InternalTableCreator creator = catalog.newTableCreator((String)database, tableName, format, request);){
                try {
                    TableMetadata metadata = creator.create();
                    this.tableService.createTable(catalog.name(), metadata);
                }
                catch (RuntimeException e) {
                    creator.rollback();
                    throw e;
                }
            }
            var8_8 = null;
            try (InternalTableHandler handler = catalog.newTableHandler((String)database, tableName);){
                org.apache.iceberg.TableMetadata current = ((TableOperations)handler.newTableOperator()).current();
                LoadTableResponse loadTableResponse = LoadTableResponse.builder().withTableMetadata(current).build();
                return loadTableResponse;
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
        });
    }

    public void loadTable(Context ctx) {
        this.handleTable(ctx, handler -> {
            TableOperations ops = (TableOperations)handler.newTableOperator();
            org.apache.iceberg.TableMetadata tableMetadata = ops.current();
            if (tableMetadata == null) {
                throw new NoSuchTableException("failed to load table from metadata file.", new Object[0]);
            }
            return LoadTableResponse.builder().withTableMetadata(tableMetadata).build();
        });
    }

    public void commitTable(Context ctx) {
        this.handleTable(ctx, handler -> {
            UpdateTableRequest request = this.bodyAsClass(ctx, UpdateTableRequest.class);
            TableOperations ops = (TableOperations)handler.newTableOperator();
            org.apache.iceberg.TableMetadata base = ops.current();
            if (base == null) {
                throw new CommitFailedException("table metadata lost.", new Object[0]);
            }
            TableMetadata.Builder builder = org.apache.iceberg.TableMetadata.buildFrom((org.apache.iceberg.TableMetadata)base);
            request.requirements().forEach(r -> r.validate(base));
            request.updates().forEach(u -> u.applyTo(builder));
            org.apache.iceberg.TableMetadata newMetadata = builder.build();
            ops.commit(base, newMetadata);
            org.apache.iceberg.TableMetadata current = ops.current();
            return LoadTableResponse.builder().withTableMetadata(current).build();
        });
    }

    public void deleteTable(Context ctx) {
        this.handleTable(ctx, handler -> {
            boolean purge = Boolean.parseBoolean(Optional.ofNullable(ctx.req.getParameter("purgeRequested")).orElse("false"));
            TableMetadata tableMetadata = handler.tableMetadata();
            this.tableService.dropTableMetadata(tableMetadata.getTableIdentifier().getIdentifier(), purge);
            handler.dropTable(purge);
            return null;
        });
    }

    public void tableExists(Context ctx) {
        this.handleTable(ctx, handler -> null);
    }

    public void renameTable(Context ctx) {
        throw new UnsupportedOperationException("rename is not supported now.");
    }

    public void reportMetrics(Context ctx) {
        this.handleTable(ctx, handler -> {
            String bodyJson = ctx.body();
            ReportMetricsRequest metricsRequest = ReportMetricsRequestParser.fromJson((String)bodyJson);
            ServerTableIdentifier identifier = handler.tableMetadata().getTableIdentifier();
            IcebergReportEvent event = new IcebergReportEvent(identifier.getCatalog(), identifier.getDatabase(), identifier.getTableName(), false, metricsRequest.report());
            EventsManager.getInstance().emit((Event)event);
            return null;
        });
    }

    private <T> T bodyAsClass(Context ctx, Class<T> clz) {
        return (T)this.jsonMapper.fromJsonString(ctx.body(), clz);
    }

    private void jsonResponse(Context ctx, RESTResponse rsp) {
        ctx.contentType(ContentType.APPLICATION_JSON).result(this.jsonMapper.toJsonString((Object)rsp));
    }

    private void handleCatalog(Context ctx, Function<InternalCatalog, ? extends RESTResponse> handler) {
        String catalog = ctx.pathParam("catalog");
        Preconditions.checkNotNull((Object)catalog, (Object)"lack require path params: catalog");
        InternalCatalog internalCatalog = this.getCatalog(catalog);
        RESTResponse r = handler.apply(internalCatalog);
        if (r != null) {
            this.jsonResponse(ctx, r);
        } else {
            ctx.status(HttpCode.NO_CONTENT);
        }
    }

    private void handleNamespace(Context ctx, BiFunction<InternalCatalog, String, ? extends RESTResponse> handler) {
        this.handleCatalog(ctx, catalog -> {
            String ns = ctx.pathParam("namespace");
            Preconditions.checkNotNull((Object)ns, (Object)"namespace is null");
            RestCatalogService.checkUnsupported(!ns.contains("."), "multi-level namespace is not supported");
            RestCatalogService.checkDatabaseExist(catalog.databaseExists(ns), ns);
            return (RESTResponse)handler.apply((InternalCatalog)catalog, ns);
        });
    }

    private void handleTable(Context ctx, Function<InternalTableHandler<TableOperations>, ? extends RESTResponse> tableHandler) {
        this.handleNamespace(ctx, (catalog, database) -> {
            String tableName = ctx.pathParam("table");
            Preconditions.checkNotNull((Object)tableName, (Object)"table name is null");
            try (InternalTableHandler internalTableHandler = catalog.newTableHandler((String)database, tableName);){
                RESTResponse rESTResponse = (RESTResponse)tableHandler.apply(internalTableHandler);
                return rESTResponse;
            }
        });
    }

    private InternalCatalog getCatalog(String catalog) {
        Preconditions.checkNotNull((Object)catalog, (Object)"lack required path variables: catalog");
        ServerCatalog internalCatalog = this.tableService.getServerCatalog(catalog);
        Preconditions.checkArgument((boolean)(internalCatalog instanceof InternalCatalog), (Object)"The catalog is not an iceberg rest catalog");
        Set tableFormats = MixedCatalogUtil.tableFormats((CatalogMeta)internalCatalog.getMetadata());
        Preconditions.checkArgument((tableFormats.size() == 1 && (tableFormats.contains(TableFormat.ICEBERG) || tableFormats.contains(TableFormat.MIXED_ICEBERG)) ? 1 : 0) != 0, (Object)"The catalog is not an iceberg rest catalog");
        return (InternalCatalog)internalCatalog;
    }

    private static void checkUnsupported(boolean condition, String message) {
        if (!condition) {
            throw new UnsupportedOperationException(message);
        }
    }

    private static void checkDatabaseExist(boolean checkCondition, String database) {
        if (!checkCondition) {
            throw new NoSuchNamespaceException("Database: " + database + " doesn't exists", new Object[0]);
        }
    }

    private static void checkAlreadyExists(boolean checkCondition, String resourceType, String object) {
        if (!checkCondition) {
            throw new AlreadyExistsException(resourceType + ": " + object + " already exists.", new Object[0]);
        }
    }

    private ObjectMapper jsonMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.KebabCaseStrategy());
        RESTSerializers.registerAll((ObjectMapper)mapper);
        return mapper;
    }

    static enum IcebergRestErrorCode {
        BadRequest(400),
        NotAuthorized(401),
        Forbidden(403),
        UnsupportedOperation(406),
        AuthenticationTimeout(419),
        NotFound(404),
        Conflict(409),
        InternalServerError(500),
        ServiceUnavailable(503);

        public final int code;

        private IcebergRestErrorCode(int code) {
            this.code = code;
        }

        public static IcebergRestErrorCode exceptionToCode(Exception e) {
            if (e instanceof UnsupportedOperationException) {
                return UnsupportedOperation;
            }
            if (e instanceof ObjectNotExistsException) {
                return NotFound;
            }
            if (e instanceof CommitFailedException) {
                return Conflict;
            }
            if (e instanceof NoSuchTableException) {
                return NotFound;
            }
            if (e instanceof NoSuchNamespaceException) {
                return NotFound;
            }
            if (e instanceof AlreadyExistsException) {
                return Conflict;
            }
            return InternalServerError;
        }
    }
}

