/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.mapper;

import java.util.List;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.server.persistence.converter.Map2StringConverter;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface CatalogMetaMapper {
    public static final String TABLE_NAME = "catalog_metadata";

    @Select(value={"SELECT catalog_name, catalog_metastore, storage_configs, auth_configs, catalog_properties FROM catalog_metadata"})
    @Results(value={@Result(property="catalogName", column="catalog_name"), @Result(property="catalogType", column="catalog_metastore"), @Result(property="storageConfigs", column="storage_configs", typeHandler=Map2StringConverter.class), @Result(property="authConfigs", column="auth_configs", typeHandler=Map2StringConverter.class), @Result(property="catalogProperties", column="catalog_properties", typeHandler=Map2StringConverter.class)})
    public List<CatalogMeta> getCatalogs();

    @Select(value={"SELECT catalog_name, catalog_metastore, storage_configs, auth_configs, catalog_properties FROM catalog_metadata WHERE catalog_name = #{catalogName}"})
    @Results(value={@Result(property="catalogName", column="catalog_name"), @Result(property="catalogType", column="catalog_metastore"), @Result(property="storageConfigs", column="storage_configs", typeHandler=Map2StringConverter.class), @Result(property="authConfigs", column="auth_configs", typeHandler=Map2StringConverter.class), @Result(property="catalogProperties", column="catalog_properties", typeHandler=Map2StringConverter.class)})
    public List<CatalogMeta> getCatalog(@Param(value="catalogName") String var1);

    @Insert(value={"INSERT INTO catalog_metadata (catalog_name, catalog_metastore, storage_configs, auth_configs, catalog_properties) VALUES (#{catalogMeta.catalogName}, #{catalogMeta.catalogType}, #{catalogMeta.storageConfigs, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter}, #{catalogMeta.authConfigs, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter}, #{catalogMeta.catalogProperties, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter})"})
    public void insertCatalog(@Param(value="catalogMeta") CatalogMeta var1);

    @Delete(value={"DELETE FROM catalog_metadata WHERE catalog_name = #{catalogName} AND database_count = 0 AND table_count = 0"})
    public int deleteCatalog(@Param(value="catalogName") String var1);

    @Update(value={"UPDATE catalog_metadata SET catalog_metastore = #{catalogMeta.catalogType}, storage_configs = #{catalogMeta.storageConfigs, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter}, auth_configs=#{catalogMeta.authConfigs, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter}, catalog_properties=#{catalogMeta.catalogProperties, typeHandler=org.apache.amoro.server.persistence.converter.Map2StringConverter} WHERE catalog_name = #{catalogMeta.catalogName}"})
    public Integer updateCatalog(@Param(value="catalogMeta") CatalogMeta var1);

    @Select(value={"SELECT table_count FROM catalog_metadata WHERE catalog_name = #{catalogName}"})
    public Integer selectTableCount(@Param(value="catalogName") String var1);

    @Update(value={"UPDATE catalog_metadata SET table_count = table_count + #{tableCount} WHERE catalog_name = #{catalogName}"})
    public Integer incTableCount(@Param(value="tableCount") Integer var1, @Param(value="catalogName") String var2);

    @Update(value={"UPDATE catalog_metadata SET database_count = database_count + #{databaseCount} WHERE catalog_name = #{catalogName}"})
    public Integer incDatabaseCount(@Param(value="databaseCount") Integer var1, @Param(value="catalogName") String var2);

    @Update(value={"UPDATE catalog_metadata SET table_count = table_count - #{tableCount} WHERE catalog_name = #{catalogName}"})
    public Integer decTableCount(@Param(value="tableCount") Integer var1, @Param(value="catalogName") String var2);

    @Update(value={"UPDATE catalog_metadata SET database_count = database_count - #{databaseCount} WHERE catalog_name = #{catalogName}"})
    public Integer decDatabaseCount(@Param(value="databaseCount") Integer var1, @Param(value="catalogName") String var2);
}

