/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.utils;

import java.util.Map;
import java.util.UUID;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOs;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedCatalogUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.LocationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InternalTableUtil.class);

    public static boolean isLegacyMixedIceberg(org.apache.amoro.server.table.TableMetadata internalTableMetadata) {
        return TableFormat.MIXED_ICEBERG == internalTableMetadata.getFormat() && !Boolean.parseBoolean(internalTableMetadata.getProperties().get("mixed-iceberg.based-on-rest-catalog"));
    }

    public static boolean isKeyedMixedTable(org.apache.amoro.server.table.TableMetadata serverTableMetadata) {
        return StringUtils.isNotBlank((CharSequence)serverTableMetadata.getChangeLocation()) && StringUtils.isNotBlank((CharSequence)serverTableMetadata.getPrimaryKey());
    }

    public static AuthenticatedFileIO newIcebergFileIo(CatalogMeta meta) {
        Map catalogProperties = meta.getCatalogProperties();
        TableMetaStore store = MixedCatalogUtil.buildMetaStore((CatalogMeta)meta);
        Configuration conf = store.getConfiguration();
        String warehouse = (String)meta.getCatalogProperties().get("warehouse");
        String defaultImpl = "org.apache.iceberg.hadoop.HadoopFileIO";
        if (warehouse.toLowerCase().startsWith("s3://")) {
            defaultImpl = "org.apache.iceberg.aws.s3.S3FileIO";
        }
        String ioImpl = catalogProperties.getOrDefault("io-impl", defaultImpl);
        FileIO fileIO = CatalogUtil.loadFileIO((String)ioImpl, (Map)catalogProperties, (Object)conf);
        return AuthenticatedFileIOs.buildAdaptIcebergFileIO((TableMetaStore)store, (FileIO)fileIO);
    }

    private static String genNewMetadataFileLocation(TableMetadata meta, long newVersion) {
        String codecName = meta.property("write.metadata.compression-codec", "none");
        String fileExtension = TableMetadataParser.getFileExtension((String)codecName);
        return InternalTableUtil.genMetadataFileLocation(meta, String.format("v%05d-%s%s", newVersion, UUID.randomUUID(), fileExtension));
    }

    public static String genNewMetadataFileLocation(TableMetadata base, TableMetadata current) {
        if (current == null) {
            return null;
        }
        long version = 0L;
        if (base != null && StringUtils.isNotBlank((CharSequence)base.metadataFileLocation())) {
            version = InternalTableUtil.parseMetadataFileVersion(base.metadataFileLocation());
        }
        return InternalTableUtil.genNewMetadataFileLocation(current, version + 1L);
    }

    public static String genMetadataFileLocation(TableMetadata metadata, String filename) {
        String metadataLocation = (String)metadata.properties().get("write.metadata.path");
        if (metadataLocation != null) {
            return String.format("%s/%s", LocationUtil.stripTrailingSlash((String)metadataLocation), filename);
        }
        return String.format("%s/%s/%s", metadata.location(), "metadata", filename);
    }

    private static long parseMetadataFileVersion(String metadataLocation) {
        int versionEnd;
        int fileNameStart = metadataLocation.lastIndexOf(47) + 1;
        String fileName = metadataLocation.substring(fileNameStart);
        if (fileName.startsWith("v")) {
            fileName = fileName.substring(1);
        }
        if ((versionEnd = fileName.indexOf(45)) < 0) {
            return 0L;
        }
        try {
            return Long.parseLong(fileName.substring(0, versionEnd));
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse version from metadata location: {}", (Object)metadataLocation, (Object)e);
            return 0L;
        }
    }
}

