/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.amoro.client.AmsThriftUrl;
import org.apache.amoro.client.ConnectionFailException;
import org.apache.amoro.client.NoBackendServiceException;
import org.apache.amoro.client.PoolConfig;
import org.apache.amoro.client.ServiceInfo;
import org.apache.amoro.client.ThriftClient;
import org.apache.amoro.client.ThriftClientFactory;
import org.apache.amoro.client.ThriftException;
import org.apache.amoro.client.ThriftPingFactory;
import org.apache.amoro.shade.thrift.org.apache.thrift.TServiceClient;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TSocket;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransport;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.TTransportException;
import org.apache.amoro.shade.thrift.org.apache.thrift.transport.layered.TFramedTransport;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClientPool<T extends TServiceClient> {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftClientPool.class);
    private static final int retries = 5;
    private static final int retryInterval = 2000;
    private static final int maxMessageSize = 0x6400000;
    private final ThriftClientFactory clientFactory;
    private final ThriftPingFactory pingFactory;
    private final GenericObjectPool<ThriftClient<T>> pool;
    private final PoolConfig poolConfig;
    private final String serviceName;
    private final String url;
    private final boolean serviceReset = false;

    public ThriftClientPool(final String url, ThriftClientFactory factory, ThriftPingFactory pingFactory, PoolConfig config, final String serviceName) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("url is empty!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory is empty!");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is empty!");
        }
        this.url = url;
        this.clientFactory = factory;
        this.pingFactory = pingFactory;
        this.poolConfig = config;
        this.poolConfig.setTestOnReturn(true);
        this.poolConfig.setTestOnBorrow(true);
        this.serviceName = serviceName;
        this.pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<ThriftClient<T>>(){

            public ThriftClient<T> create() throws Exception {
                AmsThriftUrl amsThriftUrl = AmsThriftUrl.parse(url, serviceName);
                ServiceInfo serviceInfo = new ServiceInfo(amsThriftUrl.host(), amsThriftUrl.port());
                TTransport transport = ThriftClientPool.this.getTransport(serviceInfo);
                try {
                    transport.open();
                }
                catch (TTransportException e) {
                    LOG.warn("transport open fail service: host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                    if (ThriftClientPool.this.poolConfig.isFailover()) {
                        for (int i = 0; i < 5; ++i) {
                            try {
                                amsThriftUrl = AmsThriftUrl.parse(url, serviceName);
                                serviceInfo.setHost(amsThriftUrl.host());
                                serviceInfo.setPort(amsThriftUrl.port());
                                transport = ThriftClientPool.this.getTransport(serviceInfo);
                                LOG.info("failover to next service host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                                transport.open();
                                break;
                            }
                            catch (TTransportException e2) {
                                LOG.warn("transport open fail service: host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                                Thread.sleep(2000L);
                                continue;
                            }
                        }
                        if (!transport.isOpen()) {
                            throw new ConnectionFailException("connect error after try 5 times, last connect is: host=" + serviceInfo.getHost() + ", ip=" + serviceInfo.getPort(), e);
                        }
                    }
                    throw new ConnectionFailException("host=" + serviceInfo.getHost() + ", ip=" + serviceInfo.getPort(), e);
                }
                ThriftClient client = new ThriftClient(ThriftClientPool.this.clientFactory.createClient(transport), ThriftClientPool.this.pool, serviceInfo);
                LOG.debug("create new object for pool {}", client);
                return client;
            }

            public PooledObject<ThriftClient<T>> wrap(ThriftClient<T> obj) {
                return new DefaultPooledObject(obj);
            }

            public void destroyObject(PooledObject<ThriftClient<T>> p) throws Exception {
                ((ThriftClient)p.getObject()).closeClient();
                super.destroyObject(p);
            }
        }, (GenericObjectPoolConfig)this.poolConfig);
    }

    private TTransport getTransport(ServiceInfo serviceInfo) throws TTransportException {
        if (serviceInfo == null) {
            throw new NoBackendServiceException();
        }
        TFramedTransport transport = null;
        transport = this.poolConfig.getTimeout() > 0 ? new TFramedTransport((TTransport)new TSocket(serviceInfo.getHost(), serviceInfo.getPort(), this.poolConfig.getTimeout()), 0x6400000) : new TFramedTransport((TTransport)new TSocket(serviceInfo.getHost(), serviceInfo.getPort()), 0x6400000);
        return transport;
    }

    private ServiceInfo getRandomService(List<ServiceInfo> serviceList) {
        if (serviceList == null || serviceList.size() == 0) {
            return null;
        }
        return serviceList.get(new Random().nextInt(serviceList.size()));
    }

    private List<ServiceInfo> removeFailService(List<ServiceInfo> list, ServiceInfo serviceInfo) {
        LOG.info("remove service from current service list: host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
        return list.stream().filter(si -> !serviceInfo.equals(si)).collect(Collectors.toList());
    }

    public <X> X iface() {
        int attempt;
        ThriftClient client = null;
        for (attempt = 0; attempt < 5; ++attempt) {
            try {
                client = (ThriftClient)this.pool.borrowObject();
                if (!client.isDisConnected() && this.pingFactory.ping((TServiceClient)client.iface())) break;
                if (attempt > 1) {
                    LOG.warn("maybe server is restarting, wait a while");
                    Thread.sleep(2000L);
                }
                this.pool.invalidateObject((Object)client);
                this.pool.clear();
                continue;
            }
            catch (Exception e) {
                if (e instanceof ThriftException) {
                    throw (ThriftException)e;
                }
                throw new ThriftException("Get client from pool failed.", e);
            }
        }
        if (attempt >= 5) {
            throw new ThriftException("Client can not connect.");
        }
        AtomicBoolean returnToPool = new AtomicBoolean(false);
        ThriftClient finalClient = client;
        return (X)Proxy.newProxyInstance(this.getClass().getClassLoader(), finalClient.iface().getClass().getInterfaces(), (proxy, method, args) -> {
            if (returnToPool.get()) {
                throw new IllegalStateException("Object returned via iface can only used once!");
            }
            boolean success = false;
            try {
                Object result = method.invoke(finalClient.iface(), args);
                success = true;
                Object object = result;
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                if (success) {
                    this.pool.returnObject((Object)finalClient);
                } else {
                    finalClient.closeClient();
                    this.pool.invalidateObject((Object)finalClient);
                }
                returnToPool.set(true);
            }
        });
    }
}

