/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.io.File;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TableFileUtil.class);

    public static String getFileName(String filePath) {
        int lastSlash = filePath.lastIndexOf(47);
        return filePath.substring(lastSlash + 1);
    }

    public static String getFileDir(String filePath) {
        int lastSlash = filePath.lastIndexOf(47);
        return filePath.substring(0, lastSlash);
    }

    public static void deleteEmptyDirectory(AuthenticatedFileIO io, String directoryPath, Set<String> exclude) {
        if (!io.exists(directoryPath)) {
            LOG.debug("The target directory {} does not exist or has been deleted", (Object)directoryPath);
            return;
        }
        String parent = new Path(directoryPath).getParent().toString();
        if (!io.asFileSystemIO().isDirectory(directoryPath) || exclude.contains(directoryPath) || exclude.contains(parent)) {
            return;
        }
        LOG.debug("current path {} and parent path {} not in exclude.", (Object)directoryPath, (Object)parent);
        if (io.asFileSystemIO().isEmptyDirectory(directoryPath)) {
            io.asFileSystemIO().deletePrefix(directoryPath);
            LOG.debug("success delete empty directory {}", (Object)directoryPath);
            TableFileUtil.deleteEmptyDirectory(io, parent, exclude);
        }
    }

    public static int deleteFiles(AuthenticatedFileIO io, Set<String> files, ExecutorService workPool) {
        if (files == null || files.isEmpty()) {
            return 0;
        }
        AtomicInteger failedFileCnt = new AtomicInteger(0);
        if (io.supportBulkOperations()) {
            try {
                io.asBulkFileIO().deleteFiles(files);
            }
            catch (BulkDeletionFailureException e) {
                failedFileCnt.set(e.numberFailedObjects());
                LOG.warn("Failed to bulk delete {} files", (Object)e.numberFailedObjects(), (Object)e);
            }
            catch (RuntimeException e) {
                failedFileCnt.set(files.size());
                LOG.warn("Failed to bulk delete files", (Throwable)e);
            }
        } else if (workPool != null) {
            Tasks.foreach(files).executeWith(workPool).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> {
                failedFileCnt.addAndGet(1);
                LOG.warn("Failed to delete file {}", file, (Object)exc);
            }).run(arg_0 -> ((AuthenticatedFileIO)io).deleteFile(arg_0));
        } else {
            files.forEach(f -> {
                try {
                    io.deleteFile((String)f);
                }
                catch (RuntimeException e) {
                    failedFileCnt.addAndGet(1);
                    LOG.warn("Failed to delete file {}", f, (Object)e);
                }
            });
        }
        return files.size() - failedFileCnt.get();
    }

    public static int deleteFiles(AuthenticatedFileIO io, Set<String> files) {
        return TableFileUtil.deleteFiles(io, files, null);
    }

    public static int parallelDeleteFiles(AuthenticatedFileIO io, Set<String> files, ExecutorService workPool) {
        return TableFileUtil.deleteFiles(io, files, workPool);
    }

    public static String getNewFilePath(String newDirectory, String filePath) {
        return newDirectory + File.separator + TableFileUtil.getFileName(filePath);
    }

    public static String getUriPath(String path) {
        return URI.create(path).getPath();
    }

    public static String getParent(String path) {
        Path p = new Path(path);
        return p.getParent().toString();
    }
}

