/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api.process;

import org.apache.amoro.api.Action;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.StateField;
import org.apache.amoro.api.process.OptimizingStage;
import org.apache.amoro.api.process.TableProcessState;

public abstract class OptimizingState
extends TableProcessState {
    @StateField
    private volatile long targetSnapshotId;
    @StateField
    private volatile long watermark;
    @StateField
    private volatile OptimizingStage stage;
    @StateField
    private volatile long currentStageStartTime;

    public OptimizingState(Action action, ServerTableIdentifier tableIdentifier) {
        super(action, tableIdentifier);
    }

    public OptimizingState(long id, Action action, ServerTableIdentifier tableIdentifier) {
        super(id, action, tableIdentifier);
    }

    protected void setStage(OptimizingStage stage) {
        this.stage = stage;
        this.currentStageStartTime = System.currentTimeMillis();
    }

    protected void setStage(OptimizingStage stage, long stageStartTime) {
        this.stage = stage;
        this.currentStageStartTime = stageStartTime;
    }

    protected void setTargetSnapshotId(long targetSnapshotId) {
        this.targetSnapshotId = targetSnapshotId;
    }

    protected void setWatermark(long watermark) {
        this.watermark = watermark;
    }

    public long getWatermark() {
        return this.watermark;
    }

    public OptimizingStage getStage() {
        return this.stage;
    }

    public long getTargetSnapshotId() {
        return this.targetSnapshotId;
    }

    public long getCurrentStageStartTime() {
        return this.currentStageStartTime;
    }

    @Override
    public String getName() {
        return this.stage.displayValue();
    }
}

