/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import org.apache.iceberg.arrow.vectorized.VectorHolder;
import org.apache.iceberg.spark.data.vectorized.IcebergArrowColumnVector;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.unsafe.types.UTF8String;

public class ColumnVectorWithFilter
extends IcebergArrowColumnVector {
    private final int[] rowIdMapping;

    public ColumnVectorWithFilter(VectorHolder holder, int[] rowIdMapping) {
        super(holder);
        this.rowIdMapping = rowIdMapping;
    }

    @Override
    public boolean isNullAt(int rowId) {
        return this.nullabilityHolder().isNullAt(this.rowIdMapping[rowId]) == 1;
    }

    @Override
    public boolean getBoolean(int rowId) {
        return this.accessor().getBoolean(this.rowIdMapping[rowId]);
    }

    @Override
    public int getInt(int rowId) {
        return this.accessor().getInt(this.rowIdMapping[rowId]);
    }

    @Override
    public long getLong(int rowId) {
        return this.accessor().getLong(this.rowIdMapping[rowId]);
    }

    @Override
    public float getFloat(int rowId) {
        return this.accessor().getFloat(this.rowIdMapping[rowId]);
    }

    @Override
    public double getDouble(int rowId) {
        return this.accessor().getDouble(this.rowIdMapping[rowId]);
    }

    @Override
    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (ColumnarArray)this.accessor().getArray(this.rowIdMapping[rowId]);
    }

    @Override
    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (Decimal)this.accessor().getDecimal(this.rowIdMapping[rowId], precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return (UTF8String)this.accessor().getUTF8String(this.rowIdMapping[rowId]);
    }

    @Override
    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor().getBinary(this.rowIdMapping[rowId]);
    }
}

