/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.SparkPositionDeletesRewrite;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;

public class SparkPositionDeletesRewriteBuilder
implements WriteBuilder {
    private final SparkSession spark;
    private final Table table;
    private final SparkWriteConf writeConf;
    private final LogicalWriteInfo writeInfo;
    private final StructType dsSchema;
    private final Schema writeSchema;

    SparkPositionDeletesRewriteBuilder(SparkSession spark, Table table, String branch, LogicalWriteInfo info) {
        this.spark = spark;
        this.table = table;
        this.writeConf = new SparkWriteConf(spark, table, branch, (Map<String, String>)info.options());
        this.writeInfo = info;
        this.dsSchema = info.schema();
        this.writeSchema = SparkSchemaUtil.convert(table.schema(), this.dsSchema, this.writeConf.caseSensitive());
    }

    public Write build() {
        String fileSetId = this.writeConf.rewrittenFileSetId();
        boolean handleTimestampWithoutZone = this.writeConf.handleTimestampWithoutZone();
        Preconditions.checkArgument((fileSetId != null ? 1 : 0) != 0, (String)"Can only write to %s via actions", (Object)this.table.name());
        Preconditions.checkArgument((handleTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.table.schema()) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
        ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
        List<PositionDeletesScanTask> tasks = taskSetManager.fetchTasks(this.table, fileSetId);
        Preconditions.checkArgument((tasks != null && tasks.size() > 0 ? 1 : 0) != 0, (String)"No scan tasks found for %s", (Object)fileSetId);
        int specId = this.specId(fileSetId, tasks);
        StructLike partition = this.partition(fileSetId, tasks);
        return new SparkPositionDeletesRewrite(this.spark, this.table, this.writeConf, this.writeInfo, this.writeSchema, this.dsSchema, specId, partition);
    }

    private int specId(String fileSetId, List<PositionDeletesScanTask> tasks) {
        Set specIds = tasks.stream().map(t -> t.spec().specId()).collect(Collectors.toSet());
        Preconditions.checkArgument((specIds.size() == 1 ? 1 : 0) != 0, (String)"All scan tasks of %s are expected to have same spec id, but got %s", (Object)fileSetId, (Object)Joiner.on((String)",").join(specIds));
        return tasks.get(0).spec().specId();
    }

    private StructLike partition(String fileSetId, List<PositionDeletesScanTask> tasks) {
        StructLikeSet partitions = StructLikeSet.create((Types.StructType)tasks.get(0).spec().partitionType());
        tasks.stream().map(ContentScanTask::partition).forEach(arg_0 -> ((StructLikeSet)partitions).add(arg_0));
        Preconditions.checkArgument((partitions.size() == 1 ? 1 : 0) != 0, (String)"All scan tasks of %s are expected to have the same partition, but got %s", (Object)fileSetId, (Object)Joiner.on((String)",").join((Iterable)partitions));
        return tasks.get(0).partition();
    }
}

