/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.reader.DataReaderCommon;
import org.apache.amoro.io.reader.DeleteFilter;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.NodeFilter;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.Filter;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public abstract class AbstractUnkeyedDataReader<T> {
    protected final Schema tableSchema;
    protected final Schema projectedSchema;
    protected final String nameMapping;
    protected final boolean caseSensitive;
    protected final AuthenticatedFileIO fileIO;
    protected final BiFunction<Type, Object, Object> convertConstant;
    protected final Filter<T> dataNodeFilter;
    protected final boolean reuseContainer;
    private StructLikeCollections structLikeCollections = StructLikeCollections.DEFAULT;

    public AbstractUnkeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, boolean reuseContainer, StructLikeCollections structLikeCollections) {
        this(fileIO, tableSchema, projectedSchema, null, nameMapping, caseSensitive, convertConstant, null, reuseContainer);
        this.structLikeCollections = structLikeCollections;
    }

    public AbstractUnkeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, boolean reuseContainer) {
        this(fileIO, tableSchema, projectedSchema, null, nameMapping, caseSensitive, convertConstant, null, reuseContainer);
    }

    public AbstractUnkeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, PrimaryKeySpec primaryKeySpec, String nameMapping, boolean caseSensitive, BiFunction<Type, Object, Object> convertConstant, Set<DataTreeNode> sourceNodes, boolean reuseContainer) {
        this.tableSchema = tableSchema;
        this.projectedSchema = projectedSchema;
        this.nameMapping = nameMapping;
        this.caseSensitive = caseSensitive;
        this.fileIO = fileIO;
        this.convertConstant = convertConstant;
        this.reuseContainer = reuseContainer;
        this.dataNodeFilter = sourceNodes != null ? new NodeFilter<T>(sourceNodes, projectedSchema, primaryKeySpec, this.toStructLikeFunction().apply(projectedSchema)) : null;
    }

    public CloseableIterable<T> readData(FileScanTask task) {
        Map<Integer, ?> idToConstant = DataReaderCommon.getIdToConstant(task, this.projectedSchema, this.convertConstant);
        GenericDeleteFilter deleteFilter = new GenericDeleteFilter(task, this.tableSchema, this.projectedSchema, this.structLikeCollections);
        CloseableIterable<T> iterable = deleteFilter.filter(this.newIterable(task, deleteFilter.requiredSchema(), idToConstant));
        if (this.dataNodeFilter != null) {
            return this.dataNodeFilter.filter(iterable);
        }
        return iterable;
    }

    private CloseableIterable<T> newIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        CloseableIterable<T> iter;
        if (task.isDataTask()) {
            throw new UnsupportedOperationException("Cannot read data task.");
        }
        switch (((DataFile)task.file()).format()) {
            case PARQUET: {
                iter = this.newParquetIterable(task, schema, idToConstant);
                break;
            }
            case ORC: {
                iter = this.newOrcIterable(task, schema, idToConstant);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot read unknown format: " + ((DataFile)task.file()).format());
            }
        }
        return iter;
    }

    protected CloseableIterable<T> newParquetIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Parquet.ReadBuilder builder = Parquet.read((InputFile)this.fileIO.newInputFile(((DataFile)task.file()).path().toString())).split(task.start(), task.length()).project(schema).createReaderFunc(this.getParquetReaderFunction(schema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.reuseContainer) {
            builder.reuseContainers();
        }
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
        }
        return this.fileIO.doAs(() -> ((Parquet.ReadBuilder)builder).build());
    }

    protected CloseableIterable<T> newOrcIterable(FileScanTask task, Schema schema, Map<Integer, ?> idToConstant) {
        Schema readSchemaWithoutConstantAndMetadataFields = TypeUtil.selectNot((Schema)schema, (Set)Sets.union(idToConstant.keySet(), (Set)MetadataColumns.metadataFieldIds()));
        ORC.ReadBuilder builder = ORC.read((InputFile)this.fileIO.newInputFile(((DataFile)task.file()).path().toString())).project(readSchemaWithoutConstantAndMetadataFields).split(task.start(), task.length()).createReaderFunc(this.getOrcReaderFunction(schema, idToConstant)).filter(task.residual()).caseSensitive(this.caseSensitive);
        if (this.nameMapping != null) {
            builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
        }
        return builder.build();
    }

    protected abstract Function<MessageType, ParquetValueReader<?>> getParquetReaderFunction(Schema var1, Map<Integer, ?> var2);

    protected abstract Function<TypeDescription, OrcRowReader<?>> getOrcReaderFunction(Schema var1, Map<Integer, ?> var2);

    protected abstract Function<Schema, Function<T, StructLike>> toStructLikeFunction();

    protected class GenericDeleteFilter
    extends DeleteFilter<T> {
        protected Function<T, StructLike> asStructLike;

        GenericDeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema, StructLikeCollections structLikeCollections) {
            super(task, tableSchema, requestedSchema, structLikeCollections);
            this.asStructLike = AbstractUnkeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        GenericDeleteFilter(FileScanTask task, Schema tableSchema, Schema requestedSchema) {
            super(task, tableSchema, requestedSchema);
            this.asStructLike = AbstractUnkeyedDataReader.this.toStructLikeFunction().apply(this.requiredSchema());
        }

        @Override
        protected StructLike asStructLike(T row) {
            return this.asStructLike.apply(row);
        }

        @Override
        protected InputFile getInputFile(String location) {
            return AbstractUnkeyedDataReader.this.fileIO.newInputFile(location);
        }
    }
}

