/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.function.Supplier;
import org.apache.amoro.op.MixedUpdate;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;

public class MixedOverwriteFiles
extends MixedUpdate<OverwriteFiles>
implements OverwriteFiles {
    private final OverwriteFiles overwriteFiles;

    public static Builder buildFor(MixedTable table) {
        return new Builder(table);
    }

    private MixedOverwriteFiles(MixedTable mixedTable, OverwriteFiles overwriteFiles) {
        super(mixedTable, overwriteFiles);
        this.overwriteFiles = overwriteFiles;
    }

    private MixedOverwriteFiles(MixedTable mixedTable, OverwriteFiles overwriteFiles, Transaction transaction, boolean autoCommitTransaction) {
        super(mixedTable, overwriteFiles, transaction, autoCommitTransaction);
        this.overwriteFiles = overwriteFiles;
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.overwriteFiles.overwriteByRowFilter(expr);
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        this.overwriteFiles.addFile(file);
        this.addIcebergDataFile(file);
        return this;
    }

    public OverwriteFiles deleteFile(DataFile file) {
        this.overwriteFiles.deleteFile(file);
        this.deleteIcebergDataFile(file);
        return this;
    }

    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.overwriteFiles.validateAddedFilesMatchOverwriteFilter();
        return this;
    }

    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        this.overwriteFiles.validateFromSnapshot(snapshotId);
        return this;
    }

    public OverwriteFiles caseSensitive(boolean caseSensitive) {
        this.overwriteFiles.caseSensitive(caseSensitive);
        return this;
    }

    public OverwriteFiles conflictDetectionFilter(Expression conflictDetectionFilter) {
        this.overwriteFiles.conflictDetectionFilter(conflictDetectionFilter);
        return this;
    }

    public OverwriteFiles validateNoConflictingData() {
        this.overwriteFiles.validateNoConflictingData();
        return this;
    }

    public OverwriteFiles validateNoConflictingDeletes() {
        this.overwriteFiles.validateNoConflictingDeletes();
        return this;
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    public static class Builder
    extends MixedUpdate.Builder<MixedOverwriteFiles, OverwriteFiles> {
        private Builder(MixedTable table) {
            super(table);
            this.generateWatermark();
        }

        @Override
        protected MixedOverwriteFiles updateWithWatermark(Transaction transaction, boolean autoCommitTransaction) {
            return new MixedOverwriteFiles(this.table, transaction.newOverwrite(), transaction, autoCommitTransaction);
        }

        @Override
        protected MixedOverwriteFiles updateWithoutWatermark(Supplier<OverwriteFiles> delegateSupplier) {
            return new MixedOverwriteFiles(this.table, delegateSupplier.get());
        }

        @Override
        protected Supplier<OverwriteFiles> transactionDelegateSupplier(Transaction transaction) {
            return () -> ((Transaction)transaction).newOverwrite();
        }

        @Override
        protected Supplier<OverwriteFiles> tableStoreDelegateSupplier(Table tableStore) {
            return () -> ((Table)tableStore).newOverwrite();
        }
    }
}

