/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.op.UpdatePartitionProperties;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeMap;

public class PartitionPropertiesUpdate
implements UpdatePartitionProperties {
    private final UnkeyedTable table;
    private final Table transactionTable;
    private final StructLikeMap<Map<String, String>> setProperties;
    private final StructLikeMap<Set<String>> removeProperties;
    private final Transaction transaction;

    public PartitionPropertiesUpdate(UnkeyedTable table, Transaction transaction) {
        this.table = table;
        this.setProperties = StructLikeMap.create((Types.StructType)table.spec().partitionType());
        this.removeProperties = StructLikeMap.create((Types.StructType)table.spec().partitionType());
        this.transaction = transaction;
        this.transactionTable = transaction != null ? transaction.table() : null;
    }

    @Override
    public PartitionPropertiesUpdate set(StructLike partitionData, String key, String value) {
        Preconditions.checkNotNull((Object)partitionData, (Object)"partition cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"Value cannot be null");
        Set removePropertiesForPartition = (Set)this.removeProperties.get((Object)partitionData);
        Preconditions.checkArgument((removePropertiesForPartition == null || !removePropertiesForPartition.contains(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        Map properties = (Map)this.setProperties.computeIfAbsent((Object)partitionData, k -> Maps.newHashMap());
        properties.put(key, value);
        return this;
    }

    @Override
    public PartitionPropertiesUpdate remove(StructLike partitionData, String key) {
        Preconditions.checkNotNull((Object)partitionData, (Object)"partition cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        Map setPropertiesForPartition = (Map)this.setProperties.get((Object)partitionData);
        Preconditions.checkArgument((setPropertiesForPartition == null || !setPropertiesForPartition.containsKey(key) ? 1 : 0) != 0, (String)"Cannot remove and update the same key: %s", (Object)key);
        Set properties = (Set)this.removeProperties.computeIfAbsent((Object)partitionData, k -> Sets.newHashSet());
        properties.add(key);
        return this;
    }

    public StructLikeMap<Map<String, String>> apply() {
        String s;
        Object partitionProperties = this.transactionTable != null ? ((s = (String)this.transactionTable.properties().get("table.partition-properties")) != null ? TablePropertyUtil.decodePartitionProperties(this.table.spec(), s) : StructLikeMap.create((Types.StructType)this.table.spec().partitionType())) : this.table.partitionProperty();
        this.setProperties.forEach((partitionData, properties) -> {
            Map oldProperties = (Map)partitionProperties.computeIfAbsent(partitionData, k -> Maps.newHashMap());
            oldProperties.putAll(properties);
        });
        this.removeProperties.forEach((partitionData, keys) -> {
            Map oldProperties = (Map)partitionProperties.get(partitionData);
            if (oldProperties != null) {
                keys.forEach(oldProperties::remove);
            }
        });
        return partitionProperties;
    }

    public void commit() {
        StructLikeMap<Map<String, String>> result = this.apply();
        UpdateProperties updateProperties = this.transaction == null ? this.table.updateProperties() : this.transaction.updateProperties();
        updateProperties.set("table.partition-properties", TablePropertyUtil.encodePartitionProperties(this.table.spec(), result));
        updateProperties.commit();
    }
}

