/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.spark.TaskContext$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.apache.spark.storage.BlockInfoWrapper;
import org.slf4j.Logger;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import org.sparkproject.guava.util.concurrent.Striped;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Iterable$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-h!\u0002\u000f\u001e\u0001u)\u0003\"\u0002\u001a\u0001\t\u0003!T\u0001B\u001c\u0001\taBaa\u000f\u0001!\u0002\u0013a\u0004B\u0002'\u0001A\u0003%Q\n\u0003\u0004_\u0001\u0001\u0006Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011B4\t\u000b9\u0004A\u0011A8\t\u000bU\u0004A\u0011\u0002<\t\u000b]\u0004A\u0011\u0002=\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\"CA(\u0001E\u0005I\u0011AA)\u0011\u001d\t9\u0007\u0001C\u0001\u0003SB\u0011\"a\u001c\u0001#\u0003%\t!!\u0015\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!A\u0011q\u000f\u0001\u0005\u0002u\tI\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"I\u0011q\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\ty\n\u0001C\u0001\u0003CC\u0001\"!0\u0001\t\u0003i\u0012q\u0018\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011!\ti\r\u0001C\u0001;\u0005=\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\u0014\u0001C\u00117pG.LeNZ8NC:\fw-\u001a:\u000b\u0005yy\u0012aB:u_J\fw-\u001a\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sON\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\ti\u0003'D\u0001/\u0015\tys$\u0001\u0005j]R,'O\\1m\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u000e\t\u0003m\u0001i\u0011!\b\u0002\u000e)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0011\u0005\u001dJ\u0014B\u0001\u001e)\u0005\u0011auN\\4\u0002#\tdwnY6J]\u001a|wK]1qa\u0016\u00148\u000f\u0005\u0003>\t\u001aKU\"\u0001 \u000b\u0005}\u0002\u0015AC2p]\u000e,(O]3oi*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015s$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011agR\u0005\u0003\u0011v\u0011qA\u00117pG.LE\r\u0005\u00027\u0015&\u00111*\b\u0002\u0011\u00052|7m[%oM><&/\u00199qKJ\fQ\u0001\\8dWN\u00042AT,Z\u001b\u0005y%BA Q\u0015\t\t\u0015K\u0003\u0002S'\u000611m\\7n_:T!\u0001V+\u0002\r\u001d|wn\u001a7f\u0015\u00051\u0016aA2p[&\u0011\u0001l\u0014\u0002\b'R\u0014\u0018\u000e]3e!\tQF,D\u0001\\\u0015\tae(\u0003\u0002^7\n!Aj\\2l\u0003A9(/\u001b;f\u0019>\u001c7n\u001d\"z)\u0006\u001c8\u000e\u0005\u0003>\t\u0002\u0014\u0007CA1\u0003\u001b\u0005\u0001\u0001cA2e\r6\t\u0001)\u0003\u0002f\u0001\n\u00191+\u001a;\u0002\u001fI,\u0017\r\u001a'pG.\u001c()\u001f+bg.\u0004B!\u0010#aQB\u0019\u0011\u000e\u001c$\u000e\u0003)T!a[)\u0002\u000f\r|G\u000e\\3di&\u0011QN\u001b\u0002\u0017\u0007>t7-\u001e:sK:$\b*Y:i\u001bVdG/[:fi\u0006a!/Z4jgR,'\u000fV1tWR\u0011\u0001o\u001d\t\u0003OEL!A\u001d\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006i\u001e\u0001\r\u0001Y\u0001\u000ei\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0002)\r,(O]3oiR\u000b7o[!ui\u0016l\u0007\u000f^%e+\u0005\u0001\u0017aC1dcVL'/\u001a'pG.$R!_A\t\u0003+!2A_A\u0001!\r930`\u0005\u0003y\"\u0012aa\u00149uS>t\u0007C\u0001\u001c\u007f\u0013\tyXDA\u0005CY>\u001c7.\u00138g_\"9\u00111A\u0005A\u0002\u0005\u0015\u0011!\u00014\u0011\r\u001d\n9!`A\u0006\u0013\r\tI\u0001\u000b\u0002\n\rVt7\r^5p]F\u00022aJA\u0007\u0013\r\ty\u0001\u000b\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019\"\u0003a\u0001\r\u00069!\r\\8dW&#\u0007bBA\f\u0013\u0001\u0007\u00111B\u0001\tE2|7m[5oO\u0006I!\r\\8dW&sgm\\\u000b\u0005\u0003;\t)\u0003\u0006\u0003\u0002 \u0005\u0015C\u0003BA\u0011\u0003o\u0001B!a\t\u0002&1\u0001AaBA\u0014\u0015\t\u0007\u0011\u0011\u0006\u0002\u0002)F!\u00111FA\u0019!\r9\u0013QF\u0005\u0004\u0003_A#a\u0002(pi\"Lgn\u001a\t\u0004O\u0005M\u0012bAA\u001bQ\t\u0019\u0011I\\=\t\u000f\u0005\r!\u00021\u0001\u0002:AAq%a\u000f~\u0003\u007f\t\t#C\u0002\u0002>!\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007i\u000b\t%C\u0002\u0002Dm\u0013\u0011bQ8oI&$\u0018n\u001c8\t\r\u0005M!\u00021\u0001G\u00039awnY6G_J\u0014V-\u00193j]\u001e$RA_A&\u0003\u001bBa!a\u0005\f\u0001\u00041\u0005\"CA\f\u0017A\u0005\t\u0019AA\u0006\u0003aawnY6G_J\u0014V-\u00193j]\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0003'RC!a\u0003\u0002V-\u0012\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003%)hn\u00195fG.,GMC\u0002\u0002b!\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)'a\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bm_\u000e\\gi\u001c:Xe&$\u0018N\\4\u0015\u000bi\fY'!\u001c\t\r\u0005MQ\u00021\u0001G\u0011%\t9\"\u0004I\u0001\u0002\u0004\tY!\u0001\rm_\u000e\\gi\u001c:Xe&$\u0018N\\4%I\u00164\u0017-\u001e7uII\nQ$Y:tKJ$(\t\\8dW&\u001bHj\\2lK\u00124uN],sSRLgn\u001a\u000b\u0004{\u0006U\u0004BBA\n\u001f\u0001\u0007a)A\u0002hKR$2A_A>\u0011\u0019\t\u0019\u0002\u0005a\u0001\r\u0006iAm\\<oOJ\fG-\u001a'pG.$2\u0001]AA\u0011\u0019\t\u0019\"\u0005a\u0001\r\u00061QO\u001c7pG.$R\u0001]AD\u0003\u0013Ca!a\u0005\u0013\u0001\u00041\u0005\"CAF%A\u0005\t\u0019AAG\u0003M!\u0018m]6BiR,W\u000e\u001d;JI>\u0003H/[8o!\r93\u0010Y\u0001\u0011k:dwnY6%I\u00164\u0017-\u001e7uII*\"!a%+\t\u00055\u0015QK\u0001\u0017Y>\u001c7NT3x\u00052|7m\u001b$pe^\u0013\u0018\u000e^5oOR1\u00111BAM\u00037Ca!a\u0005\u0015\u0001\u00041\u0005BBAO)\u0001\u0007Q0\u0001\u0007oK^\u0014En\\2l\u0013:4w.\u0001\fsK2,\u0017m]3BY2dunY6t\r>\u0014H+Y:l)\u0011\t\u0019+a/\u0011\u000b\u0005\u0015\u0016Q\u0017$\u000f\t\u0005\u001d\u0016\u0011\u0017\b\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011QV\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013bAAZQ\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u00131aU3r\u0015\r\t\u0019\f\u000b\u0005\u0006iV\u0001\r\u0001Y\u0001\u0011O\u0016$H+Y:l\u0019>\u001c7nQ8v]R$B!!1\u0002HB\u0019q%a1\n\u0007\u0005\u0015\u0007FA\u0002J]RDQ\u0001\u001e\fA\u0002\u0001\fAa]5{KV\u0011\u0011\u0011Y\u0001\u0016O\u0016$h*^7cKJ|e-T1q\u000b:$(/[3t+\u0005A\u0014aB3oiJLWm]\u000b\u0003\u0003+\u0004b!!*\u0002X\u0006m\u0017\u0002BAm\u0003s\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0006O\u0005ug)`\u0005\u0004\u0003?D#A\u0002+va2,''A\u0006sK6|g/\u001a\"m_\u000e\\Gc\u00019\u0002f\"1\u00111\u0003\u000eA\u0002\u0019\u000bQa\u00197fCJ$\u0012\u0001\u001d")
public class BlockInfoManager
implements Logging {
    private final ConcurrentHashMap<BlockId, BlockInfoWrapper> blockInfoWrappers;
    private final Striped<Lock> locks;
    private final ConcurrentHashMap<Object, Set<BlockId>> writeLocksByTask;
    private final ConcurrentHashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void registerTask(long taskAttemptId) {
        this.writeLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), Collections.synchronizedSet(new HashSet()));
        this.readLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), (ConcurrentHashMultiset<BlockId>)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    private Option<BlockInfo> acquireLock(BlockId blockId, boolean blocking, Function1<BlockInfo, Object> f) {
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        while (!done.elem) {
            Object object;
            BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
            if (wrapper == null) {
                done.elem = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = wrapper.withLock((Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$acquireLock$1(f, result, done, blocking, info, condition);
                return BoxedUnit.UNIT;
            });
        }
        return (Option)result.elem;
    }

    private <T> T blockInfo(BlockId blockId, Function2<BlockInfo, Condition, T> f) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper == null) {
            throw SparkCoreErrors$.MODULE$.blockDoesNotExistError(blockId);
        }
        return wrapper.withLock(f);
    }

    public Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Task ").append(taskAttemptId).append(" trying to acquire read lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForReading$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Task ").append(taskAttemptId).append(" trying to acquire write lock for ").append(blockId).toString());
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForWriting$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        return (BlockInfo)this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$2) -> {
            if (info.writerTask() != taskAttemptId) {
                throw SparkCoreErrors$.MODULE$.taskHasNotLockedBlockError(this.currentTaskAttemptId(), blockId);
            }
            return info;
        });
    }

    public Option<BlockInfo> get(BlockId blockId) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        return wrapper != null ? new Some((Object)wrapper.info()) : None$.MODULE$;
    }

    public void downgradeLock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Task ").append(taskAttemptId).append(" downgrading write lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, x$3) -> {
            BlockInfoManager.$anonfun$downgradeLock$2(this, taskAttemptId, blockId, info, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void unlock(BlockId blockId, Option<Object> taskAttemptIdOption) {
        long taskAttemptId = BoxesRunTime.unboxToLong((Object)taskAttemptIdOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Task ").append(taskAttemptId).append(" releasing lock for ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$unlock$3(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo) {
        boolean bl;
        block4: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Task ").append(this.currentTaskAttemptId()).append(" trying to put ").append(blockId).toString());
            Lock lock = (Lock)this.locks.get((Object)blockId);
            lock.lock();
            try {
                BlockInfoWrapper wrapper = new BlockInfoWrapper(newBlockInfo, lock);
                do {
                    BlockInfoWrapper previous;
                    if ((previous = this.blockInfoWrappers.putIfAbsent(blockId, wrapper)) != null) continue;
                    Option<BlockInfo> result = this.lockForWriting(blockId, false);
                    Predef$.MODULE$.assert(result.isDefined());
                    bl = true;
                    break block4;
                } while (!this.lockForReading(blockId, this.lockForReading$default$2()).isDefined());
                bl = false;
            }
            finally {
                lock.unlock();
            }
        }
        return bl;
    }

    public Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set writeLocks = (Set)Option$.MODULE$.apply(this.writeLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptySet());
        writeLocks.forEach(blockId -> {
            this.blockInfo((BlockId)blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$3(taskAttemptId, info, condition);
                return BoxedUnit.UNIT;
            });
            blocksWithReleasedLocks.$plus$eq(blockId);
        });
        Multiset readLocks = (Multiset)Option$.MODULE$.apply(this.readLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableMultiset.of());
        readLocks.entrySet().forEach(entry -> {
            BlockId blockId = (BlockId)entry.getElement();
            int lockCount = entry.getCount();
            blocksWithReleasedLocks.$plus$eq((Object)blockId);
            this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info, condition);
                return BoxedUnit.UNIT;
            });
        });
        return blocksWithReleasedLocks.toSeq();
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public int size() {
        return this.blockInfoWrappers.size();
    }

    public long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.readLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$6)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.writeLocksByTask).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$7)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.blockInfoWrappers.entrySet().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), (Object)((BlockInfoWrapper)kv.getValue()).info()));
    }

    public void removeBlock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId).append(" trying to remove block ").append(blockId).toString());
        this.blockInfo(blockId, (Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$removeBlock$2(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.blockInfoWrappers.values().forEach(wrapper -> wrapper.tryLock((Function2<BlockInfo, Condition, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$clear$2(info, condition);
            return BoxedUnit.UNIT;
        }));
        this.blockInfoWrappers.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
    }

    public static final /* synthetic */ void $anonfun$acquireLock$1(Function1 f$1, ObjectRef result$1, BooleanRef done$1, boolean blocking$1, BlockInfo info, Condition condition) {
        if (BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)info))) {
            result$1.elem = new Some((Object)info);
            done$1.elem = true;
        } else if (!blocking$1) {
            done$1.elem = true;
        } else {
            condition.await();
        }
    }

    public static final /* synthetic */ boolean $anonfun$lockForReading$2(BlockInfoManager $this, long taskAttemptId$1, BlockId blockId$1, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER();
            if (!acquire) break block0;
            info.readerCount_$eq(info.readerCount() + 1);
            $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$1)).add((Object)blockId$1);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(taskAttemptId$1).append(" acquired read lock for ").append(blockId$1).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ boolean $anonfun$lockForWriting$2(BlockInfoManager $this, long taskAttemptId$2, BlockId blockId$2, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0;
            if (!acquire) break block0;
            info.writerTask_$eq(taskAttemptId$2);
            $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$2)).add(blockId$2);
            $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Task ").append(taskAttemptId$2).append(" acquired write lock for ").append(blockId$2).toString());
        }
        return acquire;
    }

    public static final /* synthetic */ void $anonfun$downgradeLock$2(BlockInfoManager $this, long taskAttemptId$4, BlockId blockId$4, BlockInfo info, Condition x$3) {
        Predef$.MODULE$.require(info.writerTask() == taskAttemptId$4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Task ").append(taskAttemptId$4).append(" tried to downgrade a write lock that it does not hold on").append(" block ").append(blockId$4).toString());
        $this.unlock(blockId$4, $this.unlock$default$2());
        Option<BlockInfo> lockOutcome = $this.lockForReading(blockId$4, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public static final /* synthetic */ void $anonfun$unlock$3(BlockInfoManager $this, long taskAttemptId$5, BlockId blockId$5, BlockInfo info, Condition condition) {
        Object object;
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            object = BoxesRunTime.boxToBoolean((boolean)$this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5)).remove(blockId$5));
        } else {
            ConcurrentHashMultiset<BlockId> countsForTask = $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            if (countsForTask != null) {
                Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Block ").append(blockId$5).append(" is not locked for reading").toString());
                info.readerCount_$eq(info.readerCount() - 1);
                int newPinCountForTask = countsForTask.remove((Object)blockId$5, 1) - 1;
                Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Task ").append(taskAttemptId$5).append(" release lock on block ").append(blockId$5).append(" more times than it acquired it").toString());
            }
            object = BoxedUnit.UNIT;
        }
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$3(long taskAttemptId$6, BlockInfo info, Condition condition) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$6);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info, Condition condition) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
        condition.signalAll();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$6) {
        return ((ConcurrentHashMultiset)x$6._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$7) {
        return ((Set)x$7._2()).size();
    }

    public static final /* synthetic */ void $anonfun$removeBlock$2(BlockInfoManager $this, long taskAttemptId$7, BlockId blockId$7, BlockInfo info, Condition condition) {
        if (info.writerTask() != taskAttemptId$7) {
            throw new IllegalStateException(new StringBuilder(52).append("Task ").append(taskAttemptId$7).append(" called remove() on block ").append(blockId$7).append(" without a write lock").toString());
        }
        $this.blockInfoWrappers.remove(blockId$7);
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$7)).remove(blockId$7);
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$clear$2(BlockInfo info, Condition condition) {
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public BlockInfoManager() {
        Logging.$init$(this);
        this.blockInfoWrappers = new ConcurrentHashMap();
        this.locks = Striped.lock((int)1024);
        this.writeLocksByTask = new ConcurrentHashMap();
        this.readLocksByTask = new ConcurrentHashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

