/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOption;
import software.amazon.awssdk.services.glue.model.AmazonRedshiftAdvancedOptionsCopier;
import software.amazon.awssdk.services.glue.model.Option;
import software.amazon.awssdk.services.glue.model.OptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonRedshiftNodeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonRedshiftNodeData> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessType").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::accessType)).setter(AmazonRedshiftNodeData.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::sourceType)).setter(AmazonRedshiftNodeData.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<Option> CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Connection").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::connection)).setter(AmazonRedshiftNodeData.setter(Builder::connection)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connection").build()}).build();
    private static final SdkField<Option> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Schema").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::schema)).setter(AmazonRedshiftNodeData.setter(Builder::schema)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<Option> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Table").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::table)).setter(AmazonRedshiftNodeData.setter(Builder::table)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<Option> CATALOG_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogDatabase").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::catalogDatabase)).setter(AmazonRedshiftNodeData.setter(Builder::catalogDatabase)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogDatabase").build()}).build();
    private static final SdkField<Option> CATALOG_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogTable").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::catalogTable)).setter(AmazonRedshiftNodeData.setter(Builder::catalogTable)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogTable").build()}).build();
    private static final SdkField<String> CATALOG_REDSHIFT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogRedshiftSchema").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::catalogRedshiftSchema)).setter(AmazonRedshiftNodeData.setter(Builder::catalogRedshiftSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogRedshiftSchema").build()}).build();
    private static final SdkField<String> CATALOG_REDSHIFT_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogRedshiftTable").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::catalogRedshiftTable)).setter(AmazonRedshiftNodeData.setter(Builder::catalogRedshiftTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogRedshiftTable").build()}).build();
    private static final SdkField<String> TEMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TempDir").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::tempDir)).setter(AmazonRedshiftNodeData.setter(Builder::tempDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDir").build()}).build();
    private static final SdkField<Option> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamRole").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::iamRole)).setter(AmazonRedshiftNodeData.setter(Builder::iamRole)).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<List<AmazonRedshiftAdvancedOption>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedOptions").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::advancedOptions)).setter(AmazonRedshiftNodeData.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AmazonRedshiftAdvancedOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SAMPLE_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleQuery").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::sampleQuery)).setter(AmazonRedshiftNodeData.setter(Builder::sampleQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleQuery").build()}).build();
    private static final SdkField<String> PRE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreAction").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::preAction)).setter(AmazonRedshiftNodeData.setter(Builder::preAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAction").build()}).build();
    private static final SdkField<String> POST_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAction").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::postAction)).setter(AmazonRedshiftNodeData.setter(Builder::postAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAction").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::action)).setter(AmazonRedshiftNodeData.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> TABLE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TablePrefix").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::tablePrefix)).setter(AmazonRedshiftNodeData.setter(Builder::tablePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePrefix").build()}).build();
    private static final SdkField<Boolean> UPSERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Upsert").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::upsert)).setter(AmazonRedshiftNodeData.setter(Builder::upsert)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Upsert").build()}).build();
    private static final SdkField<String> MERGE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeAction").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::mergeAction)).setter(AmazonRedshiftNodeData.setter(Builder::mergeAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeAction").build()}).build();
    private static final SdkField<String> MERGE_WHEN_MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeWhenMatched").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::mergeWhenMatched)).setter(AmazonRedshiftNodeData.setter(Builder::mergeWhenMatched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenMatched").build()}).build();
    private static final SdkField<String> MERGE_WHEN_NOT_MATCHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeWhenNotMatched").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::mergeWhenNotMatched)).setter(AmazonRedshiftNodeData.setter(Builder::mergeWhenNotMatched)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeWhenNotMatched").build()}).build();
    private static final SdkField<String> MERGE_CLAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergeClause").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::mergeClause)).setter(AmazonRedshiftNodeData.setter(Builder::mergeClause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeClause").build()}).build();
    private static final SdkField<String> CRAWLER_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerConnection").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::crawlerConnection)).setter(AmazonRedshiftNodeData.setter(Builder::crawlerConnection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerConnection").build()}).build();
    private static final SdkField<List<Option>> TABLE_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableSchema").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::tableSchema)).setter(AmazonRedshiftNodeData.setter(Builder::tableSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STAGING_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StagingTable").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::stagingTable)).setter(AmazonRedshiftNodeData.setter(Builder::stagingTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagingTable").build()}).build();
    private static final SdkField<List<Option>> SELECTED_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedColumns").getter(AmazonRedshiftNodeData.getter(AmazonRedshiftNodeData::selectedColumns)).setter(AmazonRedshiftNodeData.setter(Builder::selectedColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD, SOURCE_TYPE_FIELD, CONNECTION_FIELD, SCHEMA_FIELD, TABLE_FIELD, CATALOG_DATABASE_FIELD, CATALOG_TABLE_FIELD, CATALOG_REDSHIFT_SCHEMA_FIELD, CATALOG_REDSHIFT_TABLE_FIELD, TEMP_DIR_FIELD, IAM_ROLE_FIELD, ADVANCED_OPTIONS_FIELD, SAMPLE_QUERY_FIELD, PRE_ACTION_FIELD, POST_ACTION_FIELD, ACTION_FIELD, TABLE_PREFIX_FIELD, UPSERT_FIELD, MERGE_ACTION_FIELD, MERGE_WHEN_MATCHED_FIELD, MERGE_WHEN_NOT_MATCHED_FIELD, MERGE_CLAUSE_FIELD, CRAWLER_CONNECTION_FIELD, TABLE_SCHEMA_FIELD, STAGING_TABLE_FIELD, SELECTED_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessType;
    private final String sourceType;
    private final Option connection;
    private final Option schema;
    private final Option table;
    private final Option catalogDatabase;
    private final Option catalogTable;
    private final String catalogRedshiftSchema;
    private final String catalogRedshiftTable;
    private final String tempDir;
    private final Option iamRole;
    private final List<AmazonRedshiftAdvancedOption> advancedOptions;
    private final String sampleQuery;
    private final String preAction;
    private final String postAction;
    private final String action;
    private final String tablePrefix;
    private final Boolean upsert;
    private final String mergeAction;
    private final String mergeWhenMatched;
    private final String mergeWhenNotMatched;
    private final String mergeClause;
    private final String crawlerConnection;
    private final List<Option> tableSchema;
    private final String stagingTable;
    private final List<Option> selectedColumns;

    private AmazonRedshiftNodeData(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.sourceType = builder.sourceType;
        this.connection = builder.connection;
        this.schema = builder.schema;
        this.table = builder.table;
        this.catalogDatabase = builder.catalogDatabase;
        this.catalogTable = builder.catalogTable;
        this.catalogRedshiftSchema = builder.catalogRedshiftSchema;
        this.catalogRedshiftTable = builder.catalogRedshiftTable;
        this.tempDir = builder.tempDir;
        this.iamRole = builder.iamRole;
        this.advancedOptions = builder.advancedOptions;
        this.sampleQuery = builder.sampleQuery;
        this.preAction = builder.preAction;
        this.postAction = builder.postAction;
        this.action = builder.action;
        this.tablePrefix = builder.tablePrefix;
        this.upsert = builder.upsert;
        this.mergeAction = builder.mergeAction;
        this.mergeWhenMatched = builder.mergeWhenMatched;
        this.mergeWhenNotMatched = builder.mergeWhenNotMatched;
        this.mergeClause = builder.mergeClause;
        this.crawlerConnection = builder.crawlerConnection;
        this.tableSchema = builder.tableSchema;
        this.stagingTable = builder.stagingTable;
        this.selectedColumns = builder.selectedColumns;
    }

    public final String accessType() {
        return this.accessType;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final Option connection() {
        return this.connection;
    }

    public final Option schema() {
        return this.schema;
    }

    public final Option table() {
        return this.table;
    }

    public final Option catalogDatabase() {
        return this.catalogDatabase;
    }

    public final Option catalogTable() {
        return this.catalogTable;
    }

    public final String catalogRedshiftSchema() {
        return this.catalogRedshiftSchema;
    }

    public final String catalogRedshiftTable() {
        return this.catalogRedshiftTable;
    }

    public final String tempDir() {
        return this.tempDir;
    }

    public final Option iamRole() {
        return this.iamRole;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructList);
    }

    public final List<AmazonRedshiftAdvancedOption> advancedOptions() {
        return this.advancedOptions;
    }

    public final String sampleQuery() {
        return this.sampleQuery;
    }

    public final String preAction() {
        return this.preAction;
    }

    public final String postAction() {
        return this.postAction;
    }

    public final String action() {
        return this.action;
    }

    public final String tablePrefix() {
        return this.tablePrefix;
    }

    public final Boolean upsert() {
        return this.upsert;
    }

    public final String mergeAction() {
        return this.mergeAction;
    }

    public final String mergeWhenMatched() {
        return this.mergeWhenMatched;
    }

    public final String mergeWhenNotMatched() {
        return this.mergeWhenNotMatched;
    }

    public final String mergeClause() {
        return this.mergeClause;
    }

    public final String crawlerConnection() {
        return this.crawlerConnection;
    }

    public final boolean hasTableSchema() {
        return this.tableSchema != null && !(this.tableSchema instanceof SdkAutoConstructList);
    }

    public final List<Option> tableSchema() {
        return this.tableSchema;
    }

    public final String stagingTable() {
        return this.stagingTable;
    }

    public final boolean hasSelectedColumns() {
        return this.selectedColumns != null && !(this.selectedColumns instanceof SdkAutoConstructList);
    }

    public final List<Option> selectedColumns() {
        return this.selectedColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.connection());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogRedshiftSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogRedshiftTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.tempDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.preAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.upsert());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeWhenMatched());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeWhenNotMatched());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeClause());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableSchema() ? this.tableSchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedColumns() ? this.selectedColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonRedshiftNodeData)) {
            return false;
        }
        AmazonRedshiftNodeData other = (AmazonRedshiftNodeData)obj;
        return Objects.equals(this.accessType(), other.accessType()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.connection(), other.connection()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.catalogDatabase(), other.catalogDatabase()) && Objects.equals(this.catalogTable(), other.catalogTable()) && Objects.equals(this.catalogRedshiftSchema(), other.catalogRedshiftSchema()) && Objects.equals(this.catalogRedshiftTable(), other.catalogRedshiftTable()) && Objects.equals(this.tempDir(), other.tempDir()) && Objects.equals(this.iamRole(), other.iamRole()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.sampleQuery(), other.sampleQuery()) && Objects.equals(this.preAction(), other.preAction()) && Objects.equals(this.postAction(), other.postAction()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.tablePrefix(), other.tablePrefix()) && Objects.equals(this.upsert(), other.upsert()) && Objects.equals(this.mergeAction(), other.mergeAction()) && Objects.equals(this.mergeWhenMatched(), other.mergeWhenMatched()) && Objects.equals(this.mergeWhenNotMatched(), other.mergeWhenNotMatched()) && Objects.equals(this.mergeClause(), other.mergeClause()) && Objects.equals(this.crawlerConnection(), other.crawlerConnection()) && this.hasTableSchema() == other.hasTableSchema() && Objects.equals(this.tableSchema(), other.tableSchema()) && Objects.equals(this.stagingTable(), other.stagingTable()) && this.hasSelectedColumns() == other.hasSelectedColumns() && Objects.equals(this.selectedColumns(), other.selectedColumns());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonRedshiftNodeData").add("AccessType", (Object)this.accessType()).add("SourceType", (Object)this.sourceType()).add("Connection", (Object)this.connection()).add("Schema", (Object)this.schema()).add("Table", (Object)this.table()).add("CatalogDatabase", (Object)this.catalogDatabase()).add("CatalogTable", (Object)this.catalogTable()).add("CatalogRedshiftSchema", (Object)this.catalogRedshiftSchema()).add("CatalogRedshiftTable", (Object)this.catalogRedshiftTable()).add("TempDir", (Object)this.tempDir()).add("IamRole", (Object)this.iamRole()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).add("SampleQuery", (Object)this.sampleQuery()).add("PreAction", (Object)this.preAction()).add("PostAction", (Object)this.postAction()).add("Action", (Object)this.action()).add("TablePrefix", (Object)this.tablePrefix()).add("Upsert", (Object)this.upsert()).add("MergeAction", (Object)this.mergeAction()).add("MergeWhenMatched", (Object)this.mergeWhenMatched()).add("MergeWhenNotMatched", (Object)this.mergeWhenNotMatched()).add("MergeClause", (Object)this.mergeClause()).add("CrawlerConnection", (Object)this.crawlerConnection()).add("TableSchema", this.hasTableSchema() ? this.tableSchema() : null).add("StagingTable", (Object)this.stagingTable()).add("SelectedColumns", this.hasSelectedColumns() ? this.selectedColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessType": {
                return Optional.ofNullable(clazz.cast(this.accessType()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "Connection": {
                return Optional.ofNullable(clazz.cast(this.connection()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "CatalogDatabase": {
                return Optional.ofNullable(clazz.cast(this.catalogDatabase()));
            }
            case "CatalogTable": {
                return Optional.ofNullable(clazz.cast(this.catalogTable()));
            }
            case "CatalogRedshiftSchema": {
                return Optional.ofNullable(clazz.cast(this.catalogRedshiftSchema()));
            }
            case "CatalogRedshiftTable": {
                return Optional.ofNullable(clazz.cast(this.catalogRedshiftTable()));
            }
            case "TempDir": {
                return Optional.ofNullable(clazz.cast(this.tempDir()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "SampleQuery": {
                return Optional.ofNullable(clazz.cast(this.sampleQuery()));
            }
            case "PreAction": {
                return Optional.ofNullable(clazz.cast(this.preAction()));
            }
            case "PostAction": {
                return Optional.ofNullable(clazz.cast(this.postAction()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "TablePrefix": {
                return Optional.ofNullable(clazz.cast(this.tablePrefix()));
            }
            case "Upsert": {
                return Optional.ofNullable(clazz.cast(this.upsert()));
            }
            case "MergeAction": {
                return Optional.ofNullable(clazz.cast(this.mergeAction()));
            }
            case "MergeWhenMatched": {
                return Optional.ofNullable(clazz.cast(this.mergeWhenMatched()));
            }
            case "MergeWhenNotMatched": {
                return Optional.ofNullable(clazz.cast(this.mergeWhenNotMatched()));
            }
            case "MergeClause": {
                return Optional.ofNullable(clazz.cast(this.mergeClause()));
            }
            case "CrawlerConnection": {
                return Optional.ofNullable(clazz.cast(this.crawlerConnection()));
            }
            case "TableSchema": {
                return Optional.ofNullable(clazz.cast(this.tableSchema()));
            }
            case "StagingTable": {
                return Optional.ofNullable(clazz.cast(this.stagingTable()));
            }
            case "SelectedColumns": {
                return Optional.ofNullable(clazz.cast(this.selectedColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonRedshiftNodeData, T> g) {
        return obj -> g.apply((AmazonRedshiftNodeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessType;
        private String sourceType;
        private Option connection;
        private Option schema;
        private Option table;
        private Option catalogDatabase;
        private Option catalogTable;
        private String catalogRedshiftSchema;
        private String catalogRedshiftTable;
        private String tempDir;
        private Option iamRole;
        private List<AmazonRedshiftAdvancedOption> advancedOptions = DefaultSdkAutoConstructList.getInstance();
        private String sampleQuery;
        private String preAction;
        private String postAction;
        private String action;
        private String tablePrefix;
        private Boolean upsert;
        private String mergeAction;
        private String mergeWhenMatched;
        private String mergeWhenNotMatched;
        private String mergeClause;
        private String crawlerConnection;
        private List<Option> tableSchema = DefaultSdkAutoConstructList.getInstance();
        private String stagingTable;
        private List<Option> selectedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonRedshiftNodeData model) {
            this.accessType(model.accessType);
            this.sourceType(model.sourceType);
            this.connection(model.connection);
            this.schema(model.schema);
            this.table(model.table);
            this.catalogDatabase(model.catalogDatabase);
            this.catalogTable(model.catalogTable);
            this.catalogRedshiftSchema(model.catalogRedshiftSchema);
            this.catalogRedshiftTable(model.catalogRedshiftTable);
            this.tempDir(model.tempDir);
            this.iamRole(model.iamRole);
            this.advancedOptions(model.advancedOptions);
            this.sampleQuery(model.sampleQuery);
            this.preAction(model.preAction);
            this.postAction(model.postAction);
            this.action(model.action);
            this.tablePrefix(model.tablePrefix);
            this.upsert(model.upsert);
            this.mergeAction(model.mergeAction);
            this.mergeWhenMatched(model.mergeWhenMatched);
            this.mergeWhenNotMatched(model.mergeWhenNotMatched);
            this.mergeClause(model.mergeClause);
            this.crawlerConnection(model.crawlerConnection);
            this.tableSchema(model.tableSchema);
            this.stagingTable(model.stagingTable);
            this.selectedColumns(model.selectedColumns);
        }

        public final String getAccessType() {
            return this.accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Option.Builder getConnection() {
            return this.connection != null ? this.connection.toBuilder() : null;
        }

        public final void setConnection(Option.BuilderImpl connection) {
            this.connection = connection != null ? connection.build() : null;
        }

        @Override
        public final Builder connection(Option connection) {
            this.connection = connection;
            return this;
        }

        public final Option.Builder getSchema() {
            return this.schema != null ? this.schema.toBuilder() : null;
        }

        public final void setSchema(Option.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Option schema) {
            this.schema = schema;
            return this;
        }

        public final Option.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        public final void setTable(Option.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public final Builder table(Option table) {
            this.table = table;
            return this;
        }

        public final Option.Builder getCatalogDatabase() {
            return this.catalogDatabase != null ? this.catalogDatabase.toBuilder() : null;
        }

        public final void setCatalogDatabase(Option.BuilderImpl catalogDatabase) {
            this.catalogDatabase = catalogDatabase != null ? catalogDatabase.build() : null;
        }

        @Override
        public final Builder catalogDatabase(Option catalogDatabase) {
            this.catalogDatabase = catalogDatabase;
            return this;
        }

        public final Option.Builder getCatalogTable() {
            return this.catalogTable != null ? this.catalogTable.toBuilder() : null;
        }

        public final void setCatalogTable(Option.BuilderImpl catalogTable) {
            this.catalogTable = catalogTable != null ? catalogTable.build() : null;
        }

        @Override
        public final Builder catalogTable(Option catalogTable) {
            this.catalogTable = catalogTable;
            return this;
        }

        public final String getCatalogRedshiftSchema() {
            return this.catalogRedshiftSchema;
        }

        public final void setCatalogRedshiftSchema(String catalogRedshiftSchema) {
            this.catalogRedshiftSchema = catalogRedshiftSchema;
        }

        @Override
        public final Builder catalogRedshiftSchema(String catalogRedshiftSchema) {
            this.catalogRedshiftSchema = catalogRedshiftSchema;
            return this;
        }

        public final String getCatalogRedshiftTable() {
            return this.catalogRedshiftTable;
        }

        public final void setCatalogRedshiftTable(String catalogRedshiftTable) {
            this.catalogRedshiftTable = catalogRedshiftTable;
        }

        @Override
        public final Builder catalogRedshiftTable(String catalogRedshiftTable) {
            this.catalogRedshiftTable = catalogRedshiftTable;
            return this;
        }

        public final String getTempDir() {
            return this.tempDir;
        }

        public final void setTempDir(String tempDir) {
            this.tempDir = tempDir;
        }

        @Override
        public final Builder tempDir(String tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public final Option.Builder getIamRole() {
            return this.iamRole != null ? this.iamRole.toBuilder() : null;
        }

        public final void setIamRole(Option.BuilderImpl iamRole) {
            this.iamRole = iamRole != null ? iamRole.build() : null;
        }

        @Override
        public final Builder iamRole(Option iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final List<AmazonRedshiftAdvancedOption.Builder> getAdvancedOptions() {
            List<AmazonRedshiftAdvancedOption.Builder> result = AmazonRedshiftAdvancedOptionsCopier.copyToBuilder(this.advancedOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedOptions(Collection<AmazonRedshiftAdvancedOption.BuilderImpl> advancedOptions) {
            this.advancedOptions = AmazonRedshiftAdvancedOptionsCopier.copyFromBuilder(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Collection<AmazonRedshiftAdvancedOption> advancedOptions) {
            this.advancedOptions = AmazonRedshiftAdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedOptions(AmazonRedshiftAdvancedOption ... advancedOptions) {
            this.advancedOptions(Arrays.asList(advancedOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedOptions(Consumer<AmazonRedshiftAdvancedOption.Builder> ... advancedOptions) {
            this.advancedOptions(Stream.of(advancedOptions).map(c -> (AmazonRedshiftAdvancedOption)((AmazonRedshiftAdvancedOption.Builder)AmazonRedshiftAdvancedOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSampleQuery() {
            return this.sampleQuery;
        }

        public final void setSampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
        }

        @Override
        public final Builder sampleQuery(String sampleQuery) {
            this.sampleQuery = sampleQuery;
            return this;
        }

        public final String getPreAction() {
            return this.preAction;
        }

        public final void setPreAction(String preAction) {
            this.preAction = preAction;
        }

        @Override
        public final Builder preAction(String preAction) {
            this.preAction = preAction;
            return this;
        }

        public final String getPostAction() {
            return this.postAction;
        }

        public final void setPostAction(String postAction) {
            this.postAction = postAction;
        }

        @Override
        public final Builder postAction(String postAction) {
            this.postAction = postAction;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getTablePrefix() {
            return this.tablePrefix;
        }

        public final void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        @Override
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public final Boolean getUpsert() {
            return this.upsert;
        }

        public final void setUpsert(Boolean upsert) {
            this.upsert = upsert;
        }

        @Override
        public final Builder upsert(Boolean upsert) {
            this.upsert = upsert;
            return this;
        }

        public final String getMergeAction() {
            return this.mergeAction;
        }

        public final void setMergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
        }

        @Override
        public final Builder mergeAction(String mergeAction) {
            this.mergeAction = mergeAction;
            return this;
        }

        public final String getMergeWhenMatched() {
            return this.mergeWhenMatched;
        }

        public final void setMergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
        }

        @Override
        public final Builder mergeWhenMatched(String mergeWhenMatched) {
            this.mergeWhenMatched = mergeWhenMatched;
            return this;
        }

        public final String getMergeWhenNotMatched() {
            return this.mergeWhenNotMatched;
        }

        public final void setMergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
        }

        @Override
        public final Builder mergeWhenNotMatched(String mergeWhenNotMatched) {
            this.mergeWhenNotMatched = mergeWhenNotMatched;
            return this;
        }

        public final String getMergeClause() {
            return this.mergeClause;
        }

        public final void setMergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
        }

        @Override
        public final Builder mergeClause(String mergeClause) {
            this.mergeClause = mergeClause;
            return this;
        }

        public final String getCrawlerConnection() {
            return this.crawlerConnection;
        }

        public final void setCrawlerConnection(String crawlerConnection) {
            this.crawlerConnection = crawlerConnection;
        }

        @Override
        public final Builder crawlerConnection(String crawlerConnection) {
            this.crawlerConnection = crawlerConnection;
            return this;
        }

        public final List<Option.Builder> getTableSchema() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.tableSchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableSchema(Collection<Option.BuilderImpl> tableSchema) {
            this.tableSchema = OptionListCopier.copyFromBuilder(tableSchema);
        }

        @Override
        public final Builder tableSchema(Collection<Option> tableSchema) {
            this.tableSchema = OptionListCopier.copy(tableSchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Option ... tableSchema) {
            this.tableSchema(Arrays.asList(tableSchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableSchema(Consumer<Option.Builder> ... tableSchema) {
            this.tableSchema(Stream.of(tableSchema).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStagingTable() {
            return this.stagingTable;
        }

        public final void setStagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
        }

        @Override
        public final Builder stagingTable(String stagingTable) {
            this.stagingTable = stagingTable;
            return this;
        }

        public final List<Option.Builder> getSelectedColumns() {
            List<Option.Builder> result = OptionListCopier.copyToBuilder(this.selectedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedColumns(Collection<Option.BuilderImpl> selectedColumns) {
            this.selectedColumns = OptionListCopier.copyFromBuilder(selectedColumns);
        }

        @Override
        public final Builder selectedColumns(Collection<Option> selectedColumns) {
            this.selectedColumns = OptionListCopier.copy(selectedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Option ... selectedColumns) {
            this.selectedColumns(Arrays.asList(selectedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedColumns(Consumer<Option.Builder> ... selectedColumns) {
            this.selectedColumns(Stream.of(selectedColumns).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AmazonRedshiftNodeData build() {
            return new AmazonRedshiftNodeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonRedshiftNodeData> {
        public Builder accessType(String var1);

        public Builder sourceType(String var1);

        public Builder connection(Option var1);

        default public Builder connection(Consumer<Option.Builder> connection) {
            return this.connection((Option)((Option.Builder)Option.builder().applyMutation(connection)).build());
        }

        public Builder schema(Option var1);

        default public Builder schema(Consumer<Option.Builder> schema) {
            return this.schema((Option)((Option.Builder)Option.builder().applyMutation(schema)).build());
        }

        public Builder table(Option var1);

        default public Builder table(Consumer<Option.Builder> table) {
            return this.table((Option)((Option.Builder)Option.builder().applyMutation(table)).build());
        }

        public Builder catalogDatabase(Option var1);

        default public Builder catalogDatabase(Consumer<Option.Builder> catalogDatabase) {
            return this.catalogDatabase((Option)((Option.Builder)Option.builder().applyMutation(catalogDatabase)).build());
        }

        public Builder catalogTable(Option var1);

        default public Builder catalogTable(Consumer<Option.Builder> catalogTable) {
            return this.catalogTable((Option)((Option.Builder)Option.builder().applyMutation(catalogTable)).build());
        }

        public Builder catalogRedshiftSchema(String var1);

        public Builder catalogRedshiftTable(String var1);

        public Builder tempDir(String var1);

        public Builder iamRole(Option var1);

        default public Builder iamRole(Consumer<Option.Builder> iamRole) {
            return this.iamRole((Option)((Option.Builder)Option.builder().applyMutation(iamRole)).build());
        }

        public Builder advancedOptions(Collection<AmazonRedshiftAdvancedOption> var1);

        public Builder advancedOptions(AmazonRedshiftAdvancedOption ... var1);

        public Builder advancedOptions(Consumer<AmazonRedshiftAdvancedOption.Builder> ... var1);

        public Builder sampleQuery(String var1);

        public Builder preAction(String var1);

        public Builder postAction(String var1);

        public Builder action(String var1);

        public Builder tablePrefix(String var1);

        public Builder upsert(Boolean var1);

        public Builder mergeAction(String var1);

        public Builder mergeWhenMatched(String var1);

        public Builder mergeWhenNotMatched(String var1);

        public Builder mergeClause(String var1);

        public Builder crawlerConnection(String var1);

        public Builder tableSchema(Collection<Option> var1);

        public Builder tableSchema(Option ... var1);

        public Builder tableSchema(Consumer<Option.Builder> ... var1);

        public Builder stagingTable(String var1);

        public Builder selectedColumns(Collection<Option> var1);

        public Builder selectedColumns(Option ... var1);

        public Builder selectedColumns(Consumer<Option.Builder> ... var1);
    }
}

